/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ShardQueryRequest;
import javax.annotation.Nullable;

final class AutoValue_ShardQueryRequest
extends ShardQueryRequest {
    private final Query query;
    private final int shardCount;
    private final Cursor resumeCursor;

    AutoValue_ShardQueryRequest(Query query, int shardCount, @Nullable Cursor resumeCursor) {
        if (query == null) {
            throw new NullPointerException("Null query");
        }
        this.query = query;
        this.shardCount = shardCount;
        this.resumeCursor = resumeCursor;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int shardCount() {
        return this.shardCount;
    }

    @Override
    @Nullable
    public Cursor resumeCursor() {
        return this.resumeCursor;
    }

    public String toString() {
        String string = String.valueOf(this.query);
        int n = this.shardCount;
        String string2 = String.valueOf(this.resumeCursor);
        return new StringBuilder(64 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ShardQueryRequest{query=").append(string).append(", shardCount=").append(n).append(", resumeCursor=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShardQueryRequest) {
            ShardQueryRequest that = (ShardQueryRequest)o;
            return this.query.equals(that.query()) && this.shardCount == that.shardCount() && (this.resumeCursor == null ? that.resumeCursor() == null : this.resumeCursor.equals(that.resumeCursor()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.shardCount;
        h$ *= 1000003;
        return h$ ^= this.resumeCursor == null ? 0 : this.resumeCursor.hashCode();
    }
}

