/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexConfiguration;
import com.google.cloud.datastore.core.rep.KindIndexGroup;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatabaseIndexGroup {
    public static final DatabaseIndexGroup NO_INDEXES = DatabaseIndexGroup.create((ImmutableMultiset<Index>)ImmutableMultiset.of(), (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), SingleFieldIndexingConfiguration.EMPTY);
    public static final DatabaseIndexGroup METADATA_INDEXES = DatabaseIndexGroup.create((ImmutableMultiset<Index>)ImmutableMultiset.of(), (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of((Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.ASC, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.DESC, WorkflowState.SERVING)), SingleFieldIndexingConfiguration.EMPTY);

    public KindIndexGroup kindIndexGroup(@Nullable String kind) {
        KindIndexGroup kindIndexGroup;
        KindIndexGroup kindIndexGroup2 = kindIndexGroup = kind == null ? null : (KindIndexGroup)this.kindToIndexGroupMap().get((Object)kind);
        if (kindIndexGroup == null) {
            return DatabaseIndexGroup.makeKindIndexGroup(kind, (ImmutableMultiset<Index>)ImmutableMultiset.of(), this.allDatastoreBuiltins(), this.singleFieldIndexing());
        }
        return kindIndexGroup;
    }

    abstract ImmutableMap<String, KindIndexGroup> kindToIndexGroupMap();

    public abstract ImmutableMap<Long, Index> allCompositeIndexesById();

    public abstract ImmutableMultiset<Index> allCompositeIndexes();

    public abstract ImmutableMultiset<DatastoreBuiltinIndex> allDatastoreBuiltins();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    @Memoized
    public IndexConfiguration indexConfiguration() {
        return IndexConfiguration.create(this.allDatastoreBuiltins(), this.singleFieldIndexing());
    }

    public static DatabaseIndexGroup create(ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return new AutoValue_DatabaseIndexGroup(DatabaseIndexGroup.makeKindToIndexGroupMap(compositeIndexes, datastoreBuiltins, singleFieldIndexing), DatabaseIndexGroup.makeCompositeIndexMap(compositeIndexes), compositeIndexes, datastoreBuiltins, singleFieldIndexing);
    }

    public static DatabaseIndexGroup create(ImmutableMultiset<Index> compositeIndexes, IndexConfiguration indexConfiguration) {
        return DatabaseIndexGroup.create(compositeIndexes, indexConfiguration.datastoreBuiltinIndexes(), indexConfiguration.singleFieldIndexing());
    }

    public DatabaseIndexGroup withKindToIndexGroupMap(ImmutableMap<String, KindIndexGroup> value) {
        return new AutoValue_DatabaseIndexGroup(value, this.allCompositeIndexesById(), this.allCompositeIndexes(), this.allDatastoreBuiltins(), this.singleFieldIndexing());
    }

    private static ImmutableMap<String, KindIndexGroup> makeKindToIndexGroupMap(ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        ArrayListMultimap kindToIndexMultimap = ArrayListMultimap.create();
        for (Index index : compositeIndexes) {
            kindToIndexMultimap.put((Object)index.definition().kind(), (Object)index);
        }
        ImmutableMap.Builder kindToIndexGroupMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : kindToIndexMultimap.asMap().entrySet()) {
            String kind = (String)entry.getKey();
            Collection kindIndexes = (Collection)entry.getValue();
            KindIndexGroup kindIndexGroup = DatabaseIndexGroup.makeKindIndexGroup(kind, (ImmutableMultiset<Index>)ImmutableMultiset.copyOf((Iterable)kindIndexes), datastoreBuiltins, singleFieldIndexing);
            kindToIndexGroupMapBuilder.put((Object)kind, (Object)kindIndexGroup);
        }
        return kindToIndexGroupMapBuilder.build();
    }

    private static ImmutableMap<Long, Index> makeCompositeIndexMap(ImmutableMultiset<Index> compositeIndexes) {
        HashMap<Long, Index> results = new HashMap<Long, Index>();
        for (Index index : compositeIndexes) {
            results.put(index.id(), index);
        }
        return ImmutableMap.copyOf(results);
    }

    private static KindIndexGroup makeKindIndexGroup(String kind, ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return KindIndexGroup.create(kind, compositeIndexes, (ImmutableMultiset<DatastoreBuiltinIndex>)((ImmutableMultiset)datastoreBuiltins.stream().filter(builtin -> builtin.appliesToKind(kind)).collect(ImmutableMultiset.toImmutableMultiset())), kind == null || Names.isNameReserved(kind) ? SingleFieldIndexingConfiguration.EMPTY : singleFieldIndexing);
    }
}

