/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexEntry;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexValue;
import java.util.Collection;
import javax.annotation.Nullable;

@AutoValue
public abstract class IndexEntry {
    public static IndexEntry create(Index index, @Nullable IndexValue ancestor, ImmutableList<IndexValue> values, EntityRef ref) {
        Preconditions.checkArgument((index.definition().hasParentOrAncestor() == (ancestor != null) ? 1 : 0) != 0);
        return new AutoValue_IndexEntry(index, ancestor, values, ref);
    }

    public abstract Index index();

    @Nullable
    public abstract IndexValue ancestorValue();

    public abstract ImmutableList<IndexValue> values();

    public abstract EntityRef entityRef();

    public int billedSize() {
        switch (this.index().definition().form()) {
            case KEY_ASCENDING: 
            case PARENT_AND_KEY_ASCENDING: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize();
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize();
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(false, false, false);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(false, false, false);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public int storageSize() {
        switch (this.index().definition().form()) {
            case KEY_ASCENDING: {
                return 0;
            }
            case PARENT_AND_KEY_ASCENDING: {
                return this.builtinParentNaturalSize();
            }
            case KIND_AND_KEY_ASCENDING: {
                return this.builtinKindNaturalSize();
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return this.builtinPropertyNaturalSize();
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: {
                return this.firestoreCollectionNaturalSize(true, true, true);
            }
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return this.firestoreCollectionGroupNaturalSize(true, true, true);
            }
            case USER_DEFINED: {
                return this.userDefinedNaturalSize(true);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private int builtinKindNaturalSize() {
        Preconditions.checkState((boolean)this.index().definition().isKindAndKeyAscending());
        return 32 + EntitySize.entityRefSize(this.entityRef()) + EntitySize.stringSize(this.entityRef().collectionId());
    }

    private int builtinParentNaturalSize() {
        Preconditions.checkState((boolean)this.index().definition().isParentAndKeyAscending());
        return 32 + EntitySize.entityRefSize(this.entityRef()) + this.ancestorValue().naturalSize();
    }

    private int builtinPropertyNaturalSize() {
        Preconditions.checkState((boolean)this.index().definition().isBuiltinSingleProperty());
        IndexDef.PropertyDef builtinPropertyDef = (IndexDef.PropertyDef)this.index().definition().propertyDefs().get(0);
        IndexValue builtinIndexValue = (IndexValue)this.values().get(0);
        return 32 + EntitySize.entityRefSize(this.entityRef()) + EntitySize.stringSize(this.entityRef().collectionId()) + EntitySize.propertyPathSize(builtinPropertyDef.path()) + builtinIndexValue.naturalSize();
    }

    private int firestoreCollectionNaturalSize(boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index().definition().isBuiltinFirestoreCollectionSingleProperty());
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index().definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(this.entityRef().collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(this.entityRef().partitionRef().namespace()) : 0) + EntitySize.entityRefSize(this.entityRef()) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + this.ancestorValue().naturalSize() + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValue)this.values().get(0)).naturalSize();
    }

    private int firestoreCollectionGroupNaturalSize(boolean includeCollectionId, boolean includeNamespace, boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index().definition().isBuiltinFirestoreCollectionGroupSingleProperty());
        int rootAncestorSize = EntitySize.entityRefSize(EntityRef.createEmpty(this.entityRef().partitionRef()));
        ImmutableList<IndexDef.PropertyDef> propertyDefs = this.index().definition().propertyDefs();
        return 32 + (includeCollectionId ? EntitySize.stringSize(this.entityRef().collectionId()) : 0) + (includeNamespace ? EntitySize.stringSize(this.entityRef().partitionRef().namespace()) : 0) + EntitySize.entityRefSize(this.entityRef()) * (includeKeyDescending && propertyDefs.size() == 2 ? 2 : 1) + rootAncestorSize + EntitySize.propertyPathSize(((IndexDef.PropertyDef)propertyDefs.get(0)).path()) + ((IndexValue)this.values().get(0)).naturalSize();
    }

    private int userDefinedNaturalSize(boolean includeKeyDescending) {
        Preconditions.checkState((boolean)this.index().definition().isUserDefined());
        int indexFieldValueSum = this.ancestorValue() == null ? 0 : this.ancestorValue().naturalSize();
        boolean hasKeyDescending = IndexDef.PropertyDef.KEY_DESCENDING.equals(Iterables.getLast(this.index().definition().propertyDefs(), null));
        int numIndexValues = hasKeyDescending && !includeKeyDescending ? this.values().size() - 1 : this.values().size();
        for (IndexValue indexValue : this.values().subList(0, numIndexValues)) {
            indexFieldValueSum += indexValue.naturalSize();
        }
        return 32 + EntitySize.entityRefSize(this.entityRef()) + indexFieldValueSum;
    }

    @Deprecated
    public int naturalValuesSize() {
        int resultSize = 0;
        ImmutableList<IndexValue> indexValues = this.getSingleFieldIndexValue();
        if (indexValues == null) {
            resultSize = this.ancestorValue() == null ? 0 : this.ancestorValue().naturalSize();
            indexValues = this.values();
        }
        for (IndexValue indexValue : indexValues) {
            resultSize += indexValue.naturalSize();
        }
        return resultSize;
    }

    @Deprecated
    @Nullable
    private ImmutableList<IndexValue> getSingleFieldIndexValue() {
        if (this.index().isFirestoreSingleField()) {
            return ImmutableList.of((Object)IndexEntry.dropContainsMark((IndexValue)this.values().get(1)), (Object)((IndexValue)this.values().get(3)), (Object)((IndexValue)this.values().get(4)));
        }
        return null;
    }

    private static IndexValue dropContainsMark(IndexValue indexValue) {
        int lastIndexArrayElementIndex;
        IndexValue last;
        ImmutableList<IndexValue> indexArray;
        if (indexValue.type() == IndexValue.Type.ARRAY && !(indexArray = indexValue.asArray()).isEmpty() && (last = (IndexValue)indexArray.get(lastIndexArrayElementIndex = indexArray.size() - 1)).equals(IndexValue.NULL)) {
            return IndexValue.createArray(false, (ImmutableList<IndexValue>)ImmutableList.copyOf((Collection)indexArray.subList(0, lastIndexArrayElementIndex)));
        }
        return indexValue;
    }
}

