/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.rep.AutoValue_KindIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.KindIndexGroupSubset;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import javax.annotation.Nullable;

@AutoValue
public abstract class KindIndexGroup {
    public static final KindIndexGroup EMPTY = KindIndexGroup.create(null, (ImmutableMultiset<Index>)ImmutableMultiset.of());

    public static ImmutableMultiset<Index> extractScannerWriteIndexes(ImmutableCollection<Index> indexes) {
        ImmutableMultiset.Builder scannerWriteIndexesBuilder = ImmutableMultiset.builder();
        for (Index index : indexes) {
            IndexDef indexDef = index.definition();
            if (!index.writing() || indexDef.isBuiltinSingleProperty() || indexDef.isStbti()) continue;
            scannerWriteIndexesBuilder.add((Object)index);
        }
        return scannerWriteIndexesBuilder.build();
    }

    @Nullable
    public abstract String kind();

    public abstract ImmutableMultiset<Index> allCompositeIndexes();

    public abstract ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltinIndexes();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    protected abstract ImmutableMap<IndexSubsetSpec, KindIndexGroupSubset> subsets();

    public KindIndexGroupSubset subset(IndexSubsetSpec spec) {
        return (KindIndexGroupSubset)this.subsets().get((Object)spec);
    }

    public ImmutableMultiset<Index> scannerIndexes(IndexSubsetSpec subsetSpec) {
        return this.subset(subsetSpec).compositeIndexes();
    }

    public ImmutableMultiset<Index> stbtiIndexes(IndexSubsetSpec subsetSpec) {
        return this.subset(subsetSpec).stbtiIndexes();
    }

    public ImmutableSet<DatastoreBuiltinIndex.Mode> datastoreBuiltins(IndexSubsetSpec spec) {
        return this.subset(spec).datastoreBuiltins();
    }

    @Nullable
    @Memoized
    public Long lastUpdated() {
        if (this.singleFieldIndexing().lastUpdated() == null) {
            return null;
        }
        long maxUpdateTime = this.singleFieldIndexing().lastUpdated();
        for (Index index : this.allCompositeIndexes()) {
            if (index.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, index.updateTimeMicros());
        }
        for (DatastoreBuiltinIndex builtinIndex : this.datastoreBuiltinIndexes()) {
            if (builtinIndex.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, builtinIndex.updateTimeMicros());
        }
        return maxUpdateTime;
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableMultiset<Index> compositeIndexes) {
        return KindIndexGroup.create(kind, compositeIndexes, (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), SingleFieldIndexingConfiguration.EMPTY);
    }

    public static KindIndexGroup create(@Nullable String kind, ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        ImmutableMap.Builder subspecViews = ImmutableMap.builder();
        for (IndexSubsetSpec subsetSpec : IndexSubsetSpec.values()) {
            subspecViews.put((Object)subsetSpec, (Object)KindIndexGroupSubset.precompute(kind, subsetSpec, singleFieldIndexing, datastoreBuiltins, compositeIndexes));
        }
        return new AutoValue_KindIndexGroup(kind, compositeIndexes, datastoreBuiltins, singleFieldIndexing, (ImmutableMap<IndexSubsetSpec, KindIndexGroupSubset>)subspecViews.build());
    }

    public static enum IndexSubsetSpec {
        REPORT,
        WRITE,
        READ,
        FULLY_APPLIED,
        PARTIALLY_OR_FULLY_APPLIED;

    }
}

