/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlPropertyPathToRepConverter;

public class GoogleSqlPropertyPathFromRepConverter {
    public static final GoogleSqlPropertyPathFromRepConverter NAME_INSTANCE = new GoogleSqlPropertyPathFromRepConverter(ReservedName.NAME.asString());
    private final String entityKeyPropertyName;

    private GoogleSqlPropertyPathFromRepConverter(String entityKeyPropertyName) {
        this.entityKeyPropertyName = entityKeyPropertyName;
    }

    public String convertPropertyPath(PropertyPath propertyPath) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        while (propertyPath != null) {
            this.convertPropertyPathSegment(stringBuilder, isFirst, propertyPath.segment());
            isFirst = false;
            propertyPath = propertyPath.next();
        }
        return stringBuilder.toString();
    }

    private void convertPropertyPathSegment(StringBuilder stringBuilder, boolean isFirst, PropertyPathSegment segment) {
        if (segment instanceof PropertyPathSegment.Member) {
            String propertyName;
            PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)segment;
            if (!isFirst) {
                stringBuilder.append('.');
            }
            if (GoogleSqlPropertyPathToRepConverter.UNQUOTED_PROPERTY_NAME_REGEX.matcher((CharSequence)(propertyName = this.convertPropertyName(memberSegment.name()))).matches()) {
                stringBuilder.append(propertyName);
            } else {
                this.convertPropertyNameRequiringQuoting(stringBuilder, propertyName);
            }
        } else if (segment instanceof PropertyPathSegment.Index) {
            PropertyPathSegment.Index indexSegment = (PropertyPathSegment.Index)segment;
            stringBuilder.append('[');
            stringBuilder.append(indexSegment.index());
            stringBuilder.append(']');
        } else if (segment instanceof PropertyPathSegment.AllArrayElements) {
            stringBuilder.append("[*]");
        } else {
            throw new IllegalArgumentException("Unknown PropertyPathSegment class.");
        }
    }

    private void convertPropertyNameRequiringQuoting(StringBuilder stringBuilder, String propertyName) {
        stringBuilder.append('`');
        int numChars = propertyName.length();
        for (int index = 0; index < numChars; ++index) {
            char c = propertyName.charAt(index);
            if (c == '`') {
                stringBuilder.append("\\`");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('`');
    }

    private String convertPropertyName(PropertyName propertyName) {
        if (propertyName.isKey()) {
            return this.entityKeyPropertyName;
        }
        return propertyName.string();
    }
}

