/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;

public class TildeEscapedPropertyPathFromRepConverter {
    private final String entityKeyPropertyName;

    public TildeEscapedPropertyPathFromRepConverter(String entityKeyPropertyName) {
        this.entityKeyPropertyName = entityKeyPropertyName;
    }

    public String convertPropertyPath(PropertyPath propertyPath) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        while (propertyPath != null) {
            this.convertPropertyPathSegment(stringBuilder, isFirst, propertyPath.segment());
            isFirst = false;
            propertyPath = propertyPath.next();
        }
        return stringBuilder.toString();
    }

    private void convertPropertyPathSegment(StringBuilder stringBuilder, boolean isFirst, PropertyPathSegment segment) {
        if (segment instanceof PropertyPathSegment.Member) {
            PropertyName propertyName;
            PropertyPathSegment.Member memberSegment = (PropertyPathSegment.Member)segment;
            if (!isFirst) {
                stringBuilder.append('.');
            }
            String propertyNameText = (propertyName = memberSegment.name()).isKey() ? this.entityKeyPropertyName : propertyName.string();
            this.convertPropertyName(stringBuilder, propertyNameText);
        } else if (segment instanceof PropertyPathSegment.Index) {
            PropertyPathSegment.Index indexSegment = (PropertyPathSegment.Index)segment;
            stringBuilder.append('[');
            stringBuilder.append(indexSegment.index());
            stringBuilder.append(']');
        } else if (segment instanceof PropertyPathSegment.AllArrayElements) {
            stringBuilder.append("[*]");
        } else {
            throw new IllegalArgumentException("Unknown PropertyPathSegment class.");
        }
    }

    private void convertPropertyName(StringBuilder stringBuilder, String propertyName) {
        int numChars = propertyName.length();
        for (int index = 0; index < numChars; ++index) {
            char c = propertyName.charAt(index);
            int specialIndex = "~/.*[]".indexOf(c);
            if (specialIndex < 0) {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('~');
            stringBuilder.append(Character.forDigit(specialIndex, 10));
        }
    }
}

