/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.datastore.shared;

import com.google.apphosting.api.DatastorePb;
import javax.annotation.Nullable;

public class CompiledCursorUtil {
    private CompiledCursorUtil() {
    }

    public static boolean isEmpty(DatastorePb.CompiledCursor.Position pos) {
        return !CompiledCursorUtil.isEncoded(pos) && !CompiledCursorUtil.isPlannable(pos);
    }

    public static boolean isEncoded(DatastorePb.CompiledCursor.Position pos) {
        return pos.hasStartKey();
    }

    public static boolean isPlannable(DatastorePb.CompiledCursor cursor) {
        return cursor.hasPosition() && CompiledCursorUtil.isPlannable(cursor.getPosition());
    }

    public static boolean isPlannable(DatastorePb.CompiledCursor.Position pos) {
        return pos.hasKey() || !pos.indexValues().isEmpty();
    }

    @Nullable
    public static DatastorePb.Query.Order.Direction getFirstSortDirection(DatastorePb.Query query) {
        return query.orders().isEmpty() ? null : query.getOrder(0).getDirectionEnum();
    }

    public static void upgradeCursors(DatastorePb.Query query) {
        DatastorePb.Query.Order.Direction firstSortDirection = CompiledCursorUtil.getFirstSortDirection(query);
        CompiledCursorUtil.upgradeCursor(query.getCompiledCursor(), firstSortDirection);
        CompiledCursorUtil.upgradeCursor(query.getEndCompiledCursor(), firstSortDirection);
    }

    public static void upgradeCursor(DatastorePb.CompiledCursor cursor, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        if (!CompiledCursorUtil.isPlannable(cursor)) {
            return;
        }
        if (cursor.getPosition().hasBeforeAscending()) {
            CompiledCursorUtil.setStartInclusive(cursor.getPosition(), firstSortDirection);
        } else {
            CompiledCursorUtil.setBeforeAscending(cursor.getPosition(), firstSortDirection);
        }
    }

    public static void setStartInclusive(DatastorePb.CompiledCursor.Position position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setStartInclusive(position.isBeforeAscending() ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING);
    }

    public static void setBeforeAscending(DatastorePb.CompiledCursor.Position position, @Nullable DatastorePb.Query.Order.Direction firstSortDirection) {
        position.setBeforeAscending(position.isStartInclusive() ^ firstSortDirection == DatastorePb.Query.Order.Direction.DESCENDING);
    }
}

