/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.Index;
import com.google.cloud.datastore.core.rep.IndexConfiguration;
import com.google.cloud.datastore.core.rep.KindIndexGroup;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatabaseIndexGroup {
    public static final DatabaseIndexGroup NO_INDEXES = DatabaseIndexGroup.createWithServingWorkflowState((ImmutableMultiset<Index>)ImmutableMultiset.of(), (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), SingleFieldIndexingConfiguration.EMPTY);
    public static final DatabaseIndexGroup METADATA_INDEXES = DatabaseIndexGroup.createWithServingWorkflowState((ImmutableMultiset<Index>)ImmutableMultiset.of(), (ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of((Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.ASC, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.DESC, WorkflowState.SERVING)), SingleFieldIndexingConfiguration.EMPTY);
    private static final ImmutableMultiset<DatastoreBuiltinIndex> DATASTORE_MODE_BUILTIN_INDEXES_FOR_RESERVED_KIND = ImmutableMultiset.of((Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.ASC, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.DESC, WorkflowState.SERVING));
    private static final ImmutableSet<DatastoreBuiltinIndex.Mode> ALLOWED_RESERVED_KIND_BUILTIN_MODES = ImmutableSet.of((Object)((Object)DatastoreBuiltinIndex.Mode.KIND), (Object)((Object)DatastoreBuiltinIndex.Mode.KIND_SCATTER), (Object)((Object)DatastoreBuiltinIndex.Mode.ASC), (Object)((Object)DatastoreBuiltinIndex.Mode.DESC));

    public KindIndexGroup kindIndexGroup(@Nullable String kind) {
        KindIndexGroup kindIndexGroup;
        KindIndexGroup kindIndexGroup2 = kindIndexGroup = kind == null ? null : (KindIndexGroup)this.kindToIndexGroupMap().get((Object)kind);
        if (kindIndexGroup == null) {
            return DatabaseIndexGroup.makeKindIndexGroup(kind, (ImmutableMultiset<Index>)ImmutableMultiset.of(), this.allDatastoreBuiltins(), this.singleFieldIndexing(), this.workflowStateForReservedKind());
        }
        return kindIndexGroup;
    }

    abstract ImmutableMap<String, KindIndexGroup> kindToIndexGroupMap();

    public abstract ImmutableMap<Long, Index> allCompositeIndexesById();

    public abstract ImmutableMultiset<Index> allCompositeIndexes();

    public abstract ImmutableMultiset<DatastoreBuiltinIndex> allDatastoreBuiltins();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    @Nullable
    public abstract WorkflowState workflowStateForReservedKind();

    @Memoized
    public IndexConfiguration indexConfiguration() {
        return IndexConfiguration.create(this.allDatastoreBuiltins(), this.singleFieldIndexing());
    }

    public static DatabaseIndexGroup create(ImmutableMultiset<Index> compositeIndexes, IndexConfiguration indexConfiguration, @Nullable WorkflowState workflowStateForReservedKind) {
        return new AutoValue_DatabaseIndexGroup(DatabaseIndexGroup.makeKindToIndexGroupMap(compositeIndexes, indexConfiguration.datastoreBuiltinIndexes(), indexConfiguration.singleFieldIndexing(), workflowStateForReservedKind), DatabaseIndexGroup.makeCompositeIndexMap(compositeIndexes), compositeIndexes, indexConfiguration.datastoreBuiltinIndexes(), indexConfiguration.singleFieldIndexing(), workflowStateForReservedKind);
    }

    public static DatabaseIndexGroup createWithServingWorkflowState(ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return DatabaseIndexGroup.createWithServingWorkflowState(compositeIndexes, IndexConfiguration.create(datastoreBuiltins, singleFieldIndexing));
    }

    public static DatabaseIndexGroup createWithServingWorkflowState(ImmutableMultiset<Index> compositeIndexes, IndexConfiguration indexConfiguration) {
        return DatabaseIndexGroup.create(compositeIndexes, indexConfiguration, WorkflowState.SERVING);
    }

    public DatabaseIndexGroup withKindToIndexGroupMap(ImmutableMap<String, KindIndexGroup> value) {
        return new AutoValue_DatabaseIndexGroup(value, this.allCompositeIndexesById(), this.allCompositeIndexes(), this.allDatastoreBuiltins(), this.singleFieldIndexing(), this.workflowStateForReservedKind());
    }

    private static ImmutableMap<String, KindIndexGroup> makeKindToIndexGroupMap(ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing, @Nullable WorkflowState workflowStateForReservedKind) {
        ArrayListMultimap kindToIndexMultimap = ArrayListMultimap.create();
        for (Index index : compositeIndexes) {
            kindToIndexMultimap.put((Object)index.definition().kind(), (Object)index);
        }
        ImmutableMap.Builder kindToIndexGroupMapBuilder = ImmutableMap.builder();
        for (Map.Entry entry : kindToIndexMultimap.asMap().entrySet()) {
            String kind = (String)entry.getKey();
            Collection kindIndexes = (Collection)entry.getValue();
            KindIndexGroup kindIndexGroup = DatabaseIndexGroup.makeKindIndexGroup(kind, (ImmutableMultiset<Index>)ImmutableMultiset.copyOf((Iterable)kindIndexes), datastoreBuiltins, singleFieldIndexing, workflowStateForReservedKind);
            kindToIndexGroupMapBuilder.put((Object)kind, (Object)kindIndexGroup);
        }
        return kindToIndexGroupMapBuilder.build();
    }

    private static ImmutableMap<Long, Index> makeCompositeIndexMap(ImmutableMultiset<Index> compositeIndexes) {
        HashMap<Long, Index> results = new HashMap<Long, Index>();
        for (Index index : compositeIndexes) {
            results.put(index.id(), index);
        }
        return ImmutableMap.copyOf(results);
    }

    private static KindIndexGroup makeKindIndexGroup(@Nullable String kind, ImmutableMultiset<Index> compositeIndexes, ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing, @Nullable WorkflowState reservedKindsBuiltinIndexState) {
        SingleFieldIndexingConfiguration filteredSfiConfiguration;
        SingleFieldIndexingConfiguration singleFieldIndexingConfiguration = filteredSfiConfiguration = kind == null || Names.isNameReserved(kind) ? SingleFieldIndexingConfiguration.EMPTY : singleFieldIndexing;
        if (!Names.isNameReserved(kind) || reservedKindsBuiltinIndexState == null) {
            return KindIndexGroup.create(kind, compositeIndexes, (ImmutableMultiset<DatastoreBuiltinIndex>)((ImmutableMultiset)datastoreBuiltins.stream().filter(builtin -> DatabaseIndexGroup.appliesToKind(builtin.mode(), kind)).collect(ImmutableMultiset.toImmutableMultiset())), filteredSfiConfiguration);
        }
        if (datastoreBuiltins.containsAll(DATASTORE_MODE_BUILTIN_INDEXES_FOR_RESERVED_KIND)) {
            return KindIndexGroup.create(kind, compositeIndexes, DATASTORE_MODE_BUILTIN_INDEXES_FOR_RESERVED_KIND, filteredSfiConfiguration);
        }
        return KindIndexGroup.create(kind, compositeIndexes, DatabaseIndexGroup.reservedKindsBuiltinIndexesForFirestoreNativeProjects(reservedKindsBuiltinIndexState), filteredSfiConfiguration);
    }

    private static boolean appliesToKind(DatastoreBuiltinIndex.Mode mode, @Nullable String kind) {
        if (kind == null) {
            return mode == DatastoreBuiltinIndex.Mode.PARENT;
        }
        if (Names.isNameReserved(kind)) {
            return ALLOWED_RESERVED_KIND_BUILTIN_MODES.contains((Object)mode);
        }
        return true;
    }

    private static ImmutableMultiset<DatastoreBuiltinIndex> reservedKindsBuiltinIndexesForFirestoreNativeProjects(WorkflowState state) {
        return ImmutableMultiset.of((Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND, WorkflowState.SERVING), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.KIND_SCATTER, DatabaseIndexGroup.reverse(state)), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.ASC, state), (Object)DatastoreBuiltinIndex.create(DatastoreBuiltinIndex.Mode.DESC, state));
    }

    private static WorkflowState reverse(WorkflowState state) {
        switch (state) {
            case CREATED: {
                return WorkflowState.NON_SERVING;
            }
            case ENABLING: {
                return WorkflowState.DISABLING;
            }
            case SERVING: {
                return WorkflowState.DELETED;
            }
            case NON_SERVING: {
                return WorkflowState.CREATED;
            }
            case DISABLING: {
                return WorkflowState.ENABLING;
            }
            case DELETED: {
                return WorkflowState.SERVING;
            }
        }
        throw new AssertionError();
    }
}

