/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.exception.DatastoreException;
import com.google.cloud.datastore.core.rep.CompositeIndex;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.NeedIndexException;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ServingIndex;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlPropertyPathFromRepConverter;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;

public class IndexAppEngV3FromRepConverter {
    public static final IndexAppEngV3FromRepConverter INSTANCE = new IndexAppEngV3FromRepConverter();
    private static final long BUILTIN_INDEX_ID = 0L;

    private IndexAppEngV3FromRepConverter() {
    }

    public ImmutableList<OnestoreEntity.CompositeIndex> convertIndexes(DatabaseRef database, ImmutableList<ServingIndex> indexes) {
        ImmutableList.Builder v3Indexes = ImmutableList.builder();
        for (ServingIndex index : indexes) {
            OnestoreEntity.CompositeIndex v3Index = this.convertIndex(database, index);
            v3Indexes.add((Object)v3Index);
        }
        return v3Indexes.build();
    }

    public OnestoreEntity.CompositeIndex convertIndexToProto2CompositeIndex(DatabaseRef databaseRef, CompositeIndex index) {
        return EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser()).apply(this.convertIndex(databaseRef, index));
    }

    public OnestoreEntity.CompositeIndex convertIndex(DatabaseRef database, CompositeIndex repIndex) {
        OnestoreEntity.CompositeIndex v3Index = this.convertIndexDef(database, repIndex.definition());
        v3Index.setId(repIndex.id());
        v3Index.setState(this.convertIndexState(repIndex.state()));
        return v3Index;
    }

    public OnestoreEntity.CompositeIndex convertIndex(DatabaseRef database, ServingIndex repIndex) {
        OnestoreEntity.CompositeIndex v3Index = this.convertIndexDef(database, repIndex.definition());
        v3Index.setId(repIndex.id());
        v3Index.setState(OnestoreEntity.CompositeIndex.State.READ_WRITE);
        return v3Index;
    }

    public OnestoreEntity.CompositeIndex convertIndexDef(DatabaseRef database, IndexDef indexDef) {
        OnestoreEntity.CompositeIndex v3IndexDef = new OnestoreEntity.CompositeIndex();
        AppEngV3DatabaseRefExtractor.set(v3IndexDef, database);
        boolean isFirestore = indexDef.semantics().equals((Object)Query.Semantics.FIRESTORE);
        v3IndexDef.setState(OnestoreEntity.CompositeIndex.State.READ_WRITE);
        OnestoreEntity.Index definition = v3IndexDef.getMutableDefinition();
        for (IndexDef.PropertyDef propertyDef : indexDef.propertyDefs()) {
            definition.addProperty(this.convertIndexPropertyDef(propertyDef, isFirestore));
        }
        switch (indexDef.form()) {
            case KEY_ASCENDING: {
                v3IndexDef.setId(0L);
                v3IndexDef.getMutableDefinition().setEntityType("").setAncestor(true);
                break;
            }
            case KIND_AND_KEY_ASCENDING: {
                v3IndexDef.setId(0L);
                v3IndexDef.getMutableDefinition().setEntityType(indexDef.kind()).setAncestor(false);
                break;
            }
            case KIND_AND_PARENT_ASCENDING: {
                v3IndexDef.setId(0L);
                v3IndexDef.getMutableDefinition().setEntityType(indexDef.kind()).setAncestor(false).setParent(true);
                break;
            }
            case BUILTIN_SINGLE_PROPERTY: {
                v3IndexDef.setId(0L);
                v3IndexDef.getMutableDefinition().setEntityType(indexDef.kind()).setAncestor(false);
                break;
            }
            case USER_DEFINED: {
                v3IndexDef.getMutableDefinition().setEntityType(indexDef.kind()).setAncestor(indexDef.isAncestor());
                break;
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: 
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                throw new IllegalArgumentException("Unknown index type.");
            }
        }
        if (indexDef.indexAncestor().equals((Object)IndexDef.IndexAncestor.PARENT)) {
            v3IndexDef.getMutableDefinition().setParent(true);
        }
        if (isFirestore) {
            v3IndexDef.getMutableDefinition().setVersion(OnestoreEntity.Index.Version.V2);
        }
        return v3IndexDef;
    }

    public OnestoreEntity.Index.Property convertIndexPropertyDef(IndexDef.PropertyDef propertyDef, boolean isFirestore) {
        OnestoreEntity.Index.Property v3PropertyDef = new OnestoreEntity.Index.Property();
        PropertyPath path = propertyDef.path();
        if (path.lastSegment() instanceof PropertyPathSegment.AllArrayElements) {
            Preconditions.checkArgument((boolean)isFirestore, (Object)"ARRAY_CONTAINS not allowed in Cloud Datastore.");
            path = path.dropLastPathSegment();
            v3PropertyDef.setMode(OnestoreEntity.Index.Property.Mode.ARRAY_CONTAINS);
        }
        if (isFirestore) {
            v3PropertyDef.setName(GoogleSqlPropertyPathFromRepConverter.NAME_INSTANCE.convertPropertyPath(path));
        } else {
            v3PropertyDef.setName(path.asPropertyNameWithDelimiterAmbiguity().string());
        }
        Direction direction = propertyDef.direction();
        if (direction != null) {
            switch (direction) {
                case ASCENDING: {
                    v3PropertyDef.setDirection(OnestoreEntity.Index.Property.Direction.ASCENDING);
                    break;
                }
                case DESCENDING: {
                    v3PropertyDef.setDirection(OnestoreEntity.Index.Property.Direction.DESCENDING);
                }
            }
        }
        if (propertyDef.mode() == IndexDef.PropertyDef.Mode.GEOSPATIAL) {
            v3PropertyDef.setMode(OnestoreEntity.Index.Property.Mode.GEOSPATIAL);
        }
        return v3PropertyDef;
    }

    public DatastoreException convertNeedIndexException(NeedIndexException needIndexException) {
        String message = needIndexException.getMessage();
        if (needIndexException.missingIndexes().stream().anyMatch(idx -> idx.reason().nonExistent())) {
            ArrayList<IndexDef> indexDefs = new ArrayList<IndexDef>();
            for (NeedIndexException.MissingIndex index : needIndexException.missingIndexes()) {
                if (!index.reason().nonExistent()) continue;
                indexDefs.add(index.nonExistentComposite());
            }
            message = indexDefs.size() > 1 ? String.valueOf(message).concat(" recommended indexes are:") : String.valueOf(message).concat(" recommended index is:");
            for (IndexDef indexDef : indexDefs) {
                String string = String.valueOf(message);
                String string2 = this.convertIndexDefToYaml(indexDef);
                message = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("\n").append(string2).toString();
            }
        }
        return new DatastoreException(message, DatastorePb.Error.ErrorCode.NEED_INDEX, needIndexException);
    }

    @VisibleForTesting
    String convertIndexDefToYaml(IndexDef indexDef) {
        ImmutableList<IndexDef.PropertyDef> propertyDefs;
        StringBuilder yamlBuilder = new StringBuilder();
        yamlBuilder.append(String.format("- kind: %s%n", indexDef.kind()));
        if (indexDef.isAncestor()) {
            yamlBuilder.append(String.format("  ancestor: yes%n", new Object[0]));
        }
        if (!(propertyDefs = indexDef.propertyDefs()).isEmpty()) {
            yamlBuilder.append(String.format("  properties:%n", new Object[0]));
            for (IndexDef.PropertyDef propertyDef : propertyDefs) {
                yamlBuilder.append(String.format("  - name: %s%n", propertyDef.path().asStringLossy()));
                if (propertyDef.direction() == Direction.DESCENDING) {
                    yamlBuilder.append(String.format("    direction: desc%n", new Object[0]));
                }
                if (propertyDef.mode() != IndexDef.PropertyDef.Mode.GEOSPATIAL) continue;
                yamlBuilder.append(String.format("    mode: geospatial%n", new Object[0]));
            }
        }
        return yamlBuilder.toString();
    }

    public OnestoreEntity.CompositeIndex.State convertIndexState(IndexState indexState) {
        if (indexState.error()) {
            return OnestoreEntity.CompositeIndex.State.ERROR;
        }
        switch (indexState.workflowState()) {
            case SERVING: {
                return OnestoreEntity.CompositeIndex.State.READ_WRITE;
            }
            case ENABLING: 
            case NON_SERVING: {
                return OnestoreEntity.CompositeIndex.State.WRITE_ONLY;
            }
            case DELETED: 
            case DISABLING: 
            case CREATED: {
                return OnestoreEntity.CompositeIndex.State.DELETED;
            }
        }
        throw new IllegalArgumentException("unknown index state");
    }
}

