/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.rep.AutoValue_IndexConfiguration;
import com.google.cloud.datastore.core.rep.DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingConfiguration;
import javax.annotation.Nullable;

@AutoValue
public abstract class IndexConfiguration {
    public static final IndexConfiguration EMPTY = IndexConfiguration.create((ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), SingleFieldIndexingConfiguration.EMPTY);

    public abstract ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltinIndexes();

    public abstract SingleFieldIndexingConfiguration singleFieldIndexing();

    public static IndexConfiguration create(SingleFieldIndexingConfiguration singleFieldIndexing) {
        return IndexConfiguration.create((ImmutableMultiset<DatastoreBuiltinIndex>)ImmutableMultiset.of(), singleFieldIndexing);
    }

    public static IndexConfiguration create(ImmutableMultiset<DatastoreBuiltinIndex> datastoreBuiltins, SingleFieldIndexingConfiguration singleFieldIndexing) {
        return new AutoValue_IndexConfiguration(datastoreBuiltins, singleFieldIndexing);
    }

    @Nullable
    @Memoized
    public Long lastUpdated() {
        if (this.singleFieldIndexing().lastUpdated() == null) {
            return null;
        }
        long maxUpdateTime = this.singleFieldIndexing().lastUpdated();
        for (DatastoreBuiltinIndex builtinIndex : this.datastoreBuiltinIndexes()) {
            if (builtinIndex.updateTimeMicros() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, builtinIndex.updateTimeMicros());
        }
        return maxUpdateTime;
    }

    public boolean isEqualIgnoreDatastoreBuiltinTimestamp(IndexConfiguration indexConfiguration) {
        return this.singleFieldIndexing().equals(indexConfiguration.singleFieldIndexing()) && this.isEqualIgnoreTimestamp(this.datastoreBuiltinIndexes(), indexConfiguration.datastoreBuiltinIndexes());
    }

    private boolean isEqualIgnoreTimestamp(ImmutableMultiset<DatastoreBuiltinIndex> v1Indexes, ImmutableMultiset<DatastoreBuiltinIndex> v2Indexes) {
        ImmutableMultiset v1IndexesWithoutTimestamp = (ImmutableMultiset)v1Indexes.stream().map(index -> DatastoreBuiltinIndex.create(index.mode(), index.workflowState())).collect(ImmutableMultiset.toImmutableMultiset());
        ImmutableMultiset v2IndexesWithoutTimestamp = (ImmutableMultiset)v2Indexes.stream().map(index -> DatastoreBuiltinIndex.create(index.mode(), index.workflowState())).collect(ImmutableMultiset.toImmutableMultiset());
        return v1IndexesWithoutTimestamp.equals((Object)v2IndexesWithoutTimestamp);
    }
}

