/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.BoundType;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableRangeSet;
import com.google.appengine.repackaged.com.google.common.collect.Range;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueRangeSet;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueRangeSet_OrderedIndexValue;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.IndexValueOrder;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@AutoValue
public abstract class IndexValueRangeSet {
    public static IndexValueRangeSet all(IndexValueOrder order) {
        Preconditions.checkNotNull((Object)order);
        return IndexValueRangeSet.create(order.minValue(), BoundType.CLOSED, null, BoundType.CLOSED, order);
    }

    public static IndexValueRangeSet empty(IndexValueOrder order) {
        return IndexValueRangeSet.create(null, BoundType.OPEN, null, BoundType.CLOSED, order);
    }

    public static IndexValueRangeSet of(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)indexValue);
        return IndexValueRangeSet.create(indexValue, BoundType.CLOSED, indexValue, BoundType.CLOSED, order);
    }

    public static IndexValueRangeSet of(IndexValueOrder order, IndexValue ... indexValues) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (IndexValue indexValue : indexValues) {
            builder.add(Range.closed((Comparable)OrderedIndexValue.create(indexValue, order), (Comparable)OrderedIndexValue.create(indexValue, order)));
        }
        return new AutoValue_IndexValueRangeSet((ImmutableRangeSet<OrderedIndexValue>)builder.build(), order);
    }

    public static IndexValueRangeSet notEqual(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)indexValue);
        return order.invert(indexValue);
    }

    public static IndexValueRangeSet lessThan(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue lowerBound = order.minValueOfCategory(indexValue);
        return IndexValueRangeSet.create(lowerBound, BoundType.CLOSED, indexValue, BoundType.OPEN, order);
    }

    public static IndexValueRangeSet lessThanOrEqual(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue lowerBound = order.minValueOfCategory(indexValue);
        return IndexValueRangeSet.create(lowerBound, BoundType.CLOSED, indexValue, BoundType.CLOSED, order);
    }

    public static IndexValueRangeSet greaterThan(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue endValue = order.minValueOfNextCategory(indexValue);
        BoundType endBound = endValue == null ? BoundType.CLOSED : BoundType.OPEN;
        return IndexValueRangeSet.create(indexValue, BoundType.OPEN, endValue, endBound, order);
    }

    public static IndexValueRangeSet greaterThanOrEqual(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue endValue = order.minValueOfNextCategory(indexValue);
        BoundType endBound = endValue == null ? BoundType.CLOSED : BoundType.OPEN;
        return IndexValueRangeSet.create(indexValue, BoundType.CLOSED, endValue, endBound, order);
    }

    @VisibleForTesting
    static IndexValueRangeSet create(IndexValue lowerValue, BoundType lowerBoundType, IndexValue upperValue, BoundType upperBoundType, IndexValueOrder order) {
        return new AutoValue_IndexValueRangeSet((ImmutableRangeSet<OrderedIndexValue>)ImmutableRangeSet.of((Range)Range.range((Comparable)OrderedIndexValue.create(lowerValue, order), (BoundType)lowerBoundType, (Comparable)OrderedIndexValue.create(upperValue, order), (BoundType)upperBoundType)), order);
    }

    public abstract ImmutableRangeSet<OrderedIndexValue> ranges();

    public abstract IndexValueOrder order();

    public boolean isEmpty() {
        return this.ranges().isEmpty();
    }

    public boolean isAll() {
        return this.ranges().encloses(Range.closed((Comparable)OrderedIndexValue.create(this.order().minValue(), this.order()), (Comparable)OrderedIndexValue.create(null, this.order())));
    }

    public boolean isSingleton() {
        if (this.isEmpty()) {
            return false;
        }
        Range range = this.ranges().span();
        return this.order().compare(((OrderedIndexValue)range.lowerEndpoint()).indexValue(), ((OrderedIndexValue)range.upperEndpoint()).indexValue()) == 0 && range.lowerBoundType().equals((Object)BoundType.CLOSED) && range.upperBoundType().equals((Object)BoundType.CLOSED);
    }

    public boolean contains(IndexValue indexValue) {
        return this.ranges().contains((Comparable)OrderedIndexValue.create(indexValue, this.order()));
    }

    public Optional<IndexValue> singletonValue() {
        if (!this.isSingleton()) {
            return Optional.empty();
        }
        return Optional.of(((OrderedIndexValue)((Range)this.ranges().asRanges().iterator().next()).lowerEndpoint()).indexValue());
    }

    public IndexValueRangeSet intersection(IndexValueRangeSet other) {
        Preconditions.checkArgument((other.order() == this.order() ? 1 : 0) != 0);
        return new AutoValue_IndexValueRangeSet((ImmutableRangeSet<OrderedIndexValue>)this.ranges().intersection(other.ranges()), this.order());
    }

    public IndexValueRangeSet difference(IndexValueRangeSet other) {
        Preconditions.checkArgument((other.order() == this.order() ? 1 : 0) != 0);
        return new AutoValue_IndexValueRangeSet((ImmutableRangeSet<OrderedIndexValue>)this.ranges().difference(other.ranges()), this.order());
    }

    private static String rangeString(Range<OrderedIndexValue> range) {
        IndexValue lowerValue = ((OrderedIndexValue)range.lowerEndpoint()).indexValue();
        IndexValue upperValue = ((OrderedIndexValue)range.upperEndpoint()).indexValue();
        String string = range.lowerBoundType().equals((Object)BoundType.CLOSED) ? "[" : "(";
        String string2 = lowerValue == null ? "<min value>" : lowerValue.toString();
        String string3 = upperValue == null ? "<max value>" : upperValue.toString();
        String string4 = range.upperBoundType().equals((Object)BoundType.CLOSED) ? "]" : ")";
        return new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append(" ... ").append(string3).append(string4).toString();
    }

    public final String toString() {
        if (this.isEmpty()) {
            return "{ }";
        }
        StringJoiner stringJoiner = new StringJoiner(" \u22c3 ");
        for (Range range : this.ranges().asRanges()) {
            stringJoiner.add(IndexValueRangeSet.rangeString((Range<OrderedIndexValue>)range));
        }
        Object object = String.valueOf(stringJoiner);
        return new StringBuilder(4 + String.valueOf(object).length()).append("{ ").append((String)object).append(" }").toString();
    }

    @AutoValue
    public static abstract class OrderedIndexValue
    implements Comparable<OrderedIndexValue> {
        @Nullable
        public abstract IndexValue indexValue();

        abstract IndexValueOrder order();

        public static OrderedIndexValue create(IndexValue indexValue, IndexValueOrder order) {
            return new AutoValue_IndexValueRangeSet_OrderedIndexValue(indexValue, order);
        }

        @Override
        public int compareTo(OrderedIndexValue orderedIndexValue) {
            return this.order().compare(this.indexValue(), orderedIndexValue.indexValue());
        }

        public final String toString() {
            return String.valueOf(this.indexValue());
        }
    }
}

