/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.LegacyMapValueConverterHelper;
import java.util.Map;

public class ValueToLegacyMapValueConverter {
    public boolean isLegacyValue(Value value) {
        switch (value.type()) {
            case ENTITY: 
            case LEGACY_USER: 
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                return true;
            }
        }
        Value.Meaning meaning = value.meaning();
        return meaning != Value.Meaning.NONE && meaning != Value.Meaning.OMITTED_BY_MEGASTORE_INDEX;
    }

    public Entity deepConvertEntity(Entity entity) {
        ImmutableMap<String, Value> propertyMap = entity.propertyMap();
        ImmutableMap<String, Value> convertedPropertyMap = this.deepConvertMap(propertyMap);
        if (convertedPropertyMap == propertyMap) {
            return entity;
        }
        return Entity.create(entity.ref(), convertedPropertyMap);
    }

    @VisibleForTesting
    public Value deepConvertValue(Value value) {
        value = this.shallowConvertValue(value);
        switch (value.type()) {
            case MAP: {
                ImmutableMap<String, Value> map = value.asMap();
                ImmutableMap<String, Value> convertedMap = this.deepConvertMap(map);
                if (convertedMap == map) {
                    return value;
                }
                return Value.createMap(convertedMap);
            }
            case ARRAY: {
                ImmutableList<Value> array = value.asArray();
                ImmutableList<Value> convertedArray = this.deepConvertArray(array);
                if (convertedArray == array) {
                    return value;
                }
                return Value.createArray(convertedArray);
            }
        }
        return value;
    }

    private ImmutableMap<String, Value> deepConvertMap(ImmutableMap<String, Value> map) {
        String propertyNameRequiringConversion = null;
        Value convertedValueForPropertyNameRequiringConversion = null;
        for (Map.Entry entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            Value convertedValue = this.deepConvertValue(value);
            if (convertedValue == value) continue;
            propertyNameRequiringConversion = propertyName;
            convertedValueForPropertyNameRequiringConversion = convertedValue;
            break;
        }
        if (propertyNameRequiringConversion == null) {
            return map;
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        boolean foundValueRequiringConversion = false;
        for (Map.Entry entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Value value = (Value)entry.getValue();
            if (foundValueRequiringConversion) {
                Value convertedValue = this.deepConvertValue(value);
                mapBuilder.put((Object)propertyName, (Object)convertedValue);
                continue;
            }
            if (propertyName == propertyNameRequiringConversion) {
                foundValueRequiringConversion = true;
                mapBuilder.put((Object)propertyName, (Object)convertedValueForPropertyNameRequiringConversion);
                continue;
            }
            mapBuilder.put((Object)propertyName, (Object)value);
        }
        return mapBuilder.build();
    }

    private ImmutableList<Value> deepConvertArray(ImmutableList<Value> array) {
        Value value;
        int index;
        int arraySize = array.size();
        int indexRequiringConversion = -1;
        Value convertedValueForIndexRequiringConversion = null;
        for (int index2 = 0; index2 < arraySize; ++index2) {
            Value value2 = (Value)array.get(index2);
            Value convertedValue = this.deepConvertValue(value2);
            if (convertedValue == value2) continue;
            indexRequiringConversion = index2;
            convertedValueForIndexRequiringConversion = convertedValue;
            break;
        }
        if (indexRequiringConversion < 0) {
            return array;
        }
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (index = 0; index < indexRequiringConversion; ++index) {
            value = (Value)array.get(index);
            listBuilder.add((Object)value);
        }
        listBuilder.add(convertedValueForIndexRequiringConversion);
        for (index = indexRequiringConversion + 1; index < arraySize; ++index) {
            value = (Value)array.get(index);
            Value convertedValue = this.deepConvertValue(value);
            listBuilder.add((Object)convertedValue);
        }
        return listBuilder.build();
    }

    public Value shallowConvertValue(Value value) {
        Value.Meaning meaning = value.meaning();
        boolean hasMeaning = meaning != Value.Meaning.NONE;
        Value valueWithoutMeaning = value;
        if (hasMeaning) {
            valueWithoutMeaning = value.withMeaning(Value.Meaning.NONE);
        }
        Value legacyMapValueWithoutMeaning = this.shallowConvertValueWithoutMeaning(valueWithoutMeaning);
        if (!hasMeaning || meaning == Value.Meaning.OMITTED_BY_MEGASTORE_INDEX) {
            return legacyMapValueWithoutMeaning;
        }
        return this.legacyMeaningWrapValue(legacyMapValueWithoutMeaning, meaning);
    }

    private Value shallowConvertValueWithoutMeaning(Value value) {
        switch (value.type()) {
            case ENTITY: {
                return this.shallowConvertEntity(value.asEntity());
            }
            case LEGACY_USER: {
                return this.convertLegacyUser(value.asLegacyUser());
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                return this.convertLegacyTimestampMicroseconds(value.asLegacyTimestampMicroseconds());
            }
        }
        return value;
    }

    private Value shallowConvertEntity(Entity entity) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.putAll(entity.propertyMap());
        mapBuilder.put((Object)ReservedName.TYPE.asString(), (Object)LegacyMapValueConverterHelper.LEGACY_ENTITY_TYPE_NAME_VALUE);
        mapBuilder.put((Object)ReservedName.NAME.asString(), (Object)Value.createEntityRef(entity.ref()));
        return Value.createMap((ImmutableMap<String, Value>)mapBuilder.build());
    }

    private Value convertLegacyUser(Value.LegacyUser user) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)ReservedName.TYPE.asString(), (Object)LegacyMapValueConverterHelper.LEGACY_USER_TYPE_NAME_VALUE);
        mapBuilder.put((Object)"email", (Object)Value.createString(user.email()));
        mapBuilder.put((Object)"auth_domain", (Object)Value.createString(user.authDomain()));
        mapBuilder.put((Object)"gaia_id", (Object)Value.createString(user.obfuscatedGaiaId()));
        if (user.federatedIdentity() != null) {
            mapBuilder.put((Object)"federated_identity", (Object)Value.createString(user.federatedIdentity()));
        }
        if (user.federatedProvider() != null) {
            mapBuilder.put((Object)"federated_provider", (Object)Value.createString(user.federatedProvider()));
        }
        return Value.createMap((ImmutableMap<String, Value>)mapBuilder.build());
    }

    private Value legacyMeaningWrapValue(Value value, Value.Meaning meaning) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)ReservedName.TYPE.asString(), (Object)LegacyMapValueConverterHelper.LEGACY_MEANING_WRAPPER_TYPE_NAME_VALUE);
        mapBuilder.put((Object)"value", (Object)value);
        mapBuilder.put((Object)"meaning", (Object)Value.createLong(meaning.ordinal()));
        return Value.createMap((ImmutableMap<String, Value>)mapBuilder.build());
    }

    private Value convertLegacyTimestampMicroseconds(long microseconds) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)ReservedName.TYPE.asString(), (Object)LegacyMapValueConverterHelper.LEGACY_TIMESTAMP_MICROSECONDS_TYPE_NAME_VALUE);
        mapBuilder.put((Object)"microseconds", (Object)Value.createLong(microseconds));
        return Value.createMap((ImmutableMap<String, Value>)mapBuilder.build());
    }
}

