/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.search;

import com.google.appengine.repackaged.org.apache.lucene.search.FieldDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.FieldDocSortedHitQueue;
import com.google.appengine.repackaged.org.apache.lucene.search.Filter;
import com.google.appengine.repackaged.org.apache.lucene.search.HitQueue;
import com.google.appengine.repackaged.org.apache.lucene.search.ScoreDoc;
import com.google.appengine.repackaged.org.apache.lucene.search.Searchable;
import com.google.appengine.repackaged.org.apache.lucene.search.Sort;
import com.google.appengine.repackaged.org.apache.lucene.search.TopDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.TopFieldDocs;
import com.google.appengine.repackaged.org.apache.lucene.search.Weight;
import com.google.appengine.repackaged.org.apache.lucene.util.PriorityQueue;
import java.io.IOException;

class MultiSearcherThread
extends Thread {
    private Searchable searchable;
    private Weight weight;
    private Filter filter;
    private int nDocs;
    private TopDocs docs;
    private int i;
    private PriorityQueue hq;
    private int[] starts;
    private IOException ioe;
    private Sort sort;

    public MultiSearcherThread(Searchable searchable, Weight weight, Filter filter, int nDocs, HitQueue hq, int i, int[] starts, String name) {
        super(name);
        this.searchable = searchable;
        this.weight = weight;
        this.filter = filter;
        this.nDocs = nDocs;
        this.hq = hq;
        this.i = i;
        this.starts = starts;
    }

    public MultiSearcherThread(Searchable searchable, Weight weight, Filter filter, int nDocs, FieldDocSortedHitQueue hq, Sort sort, int i, int[] starts, String name) {
        super(name);
        this.searchable = searchable;
        this.weight = weight;
        this.filter = filter;
        this.nDocs = nDocs;
        this.hq = hq;
        this.i = i;
        this.starts = starts;
        this.sort = sort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.docs = this.sort == null ? this.searchable.search(this.weight, this.filter, this.nDocs) : this.searchable.search(this.weight, this.filter, this.nDocs, this.sort);
        }
        catch (IOException ioe) {
            this.ioe = ioe;
        }
        if (this.ioe == null) {
            int j;
            if (this.sort != null) {
                TopFieldDocs docsFields = (TopFieldDocs)this.docs;
                for (j = 0; j < docsFields.fields.length; ++j) {
                    if (docsFields.fields[j].getType() != 1) continue;
                    for (int j2 = 0; j2 < this.docs.scoreDocs.length; ++j2) {
                        FieldDoc fd = (FieldDoc)this.docs.scoreDocs[j2];
                        fd.fields[j] = new Integer((Integer)fd.fields[j] + this.starts[this.i]);
                    }
                    break;
                }
                ((FieldDocSortedHitQueue)this.hq).setFields(docsFields.fields);
            }
            ScoreDoc[] scoreDocs = this.docs.scoreDocs;
            for (j = 0; j < scoreDocs.length; ++j) {
                ScoreDoc scoreDoc = scoreDocs[j];
                scoreDoc.doc += this.starts[this.i];
                PriorityQueue priorityQueue = this.hq;
                synchronized (priorityQueue) {
                    if (!this.hq.insert(scoreDoc)) {
                        break;
                    }
                    continue;
                }
            }
        }
    }

    public int hits() {
        return this.docs.totalHits;
    }

    public float getMaxScore() {
        return this.docs.getMaxScore();
    }

    public IOException getIOException() {
        return this.ioe;
    }
}

