/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.names;

import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.names.ProjectIds;

public interface ProjectIdAppIdResolver {
    public static final ProjectIdAppIdResolver IDENTITY = new ProjectIdAppIdResolver(){

        @Override
        public String toAppId(String projectId) {
            return projectId;
        }

        @Override
        public String toProjectId(String appId) {
            return appId;
        }
    };
    public static final ProjectIdResolver PROJECT_ID_RESOLVER = new ProjectIdResolver();

    public String toAppId(String var1) throws InvalidConversionException;

    public String toProjectId(String var1);

    public static class ProjectIdResolver
    implements ProjectIdAppIdResolver {
        @Override
        public String toAppId(String projectId) throws InvalidConversionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public final String toProjectId(String appId) {
            return ProjectIds.appToProjectId(appId);
        }
    }
}

