/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.ShardQueryRequest;
import javax.annotation.Nullable;

final class AutoValue_ShardQueryRequest
extends ShardQueryRequest {
    private final Query query;
    private final int maxShardCount;
    private final int remainingShardCount;
    private final int currentRequestShardCount;
    private final Cursor resumeCursor;

    private AutoValue_ShardQueryRequest(Query query, int maxShardCount, int remainingShardCount, int currentRequestShardCount, @Nullable Cursor resumeCursor) {
        this.query = query;
        this.maxShardCount = maxShardCount;
        this.remainingShardCount = remainingShardCount;
        this.currentRequestShardCount = currentRequestShardCount;
        this.resumeCursor = resumeCursor;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public int maxShardCount() {
        return this.maxShardCount;
    }

    @Override
    public int remainingShardCount() {
        return this.remainingShardCount;
    }

    @Override
    public int currentRequestShardCount() {
        return this.currentRequestShardCount;
    }

    @Override
    @Nullable
    public Cursor resumeCursor() {
        return this.resumeCursor;
    }

    public String toString() {
        String string = String.valueOf(this.query);
        int n = this.maxShardCount;
        int n2 = this.remainingShardCount;
        int n3 = this.currentRequestShardCount;
        String string2 = String.valueOf(this.resumeCursor);
        return new StringBuilder(138 + String.valueOf(string).length() + String.valueOf(string2).length()).append("ShardQueryRequest{query=").append(string).append(", maxShardCount=").append(n).append(", remainingShardCount=").append(n2).append(", currentRequestShardCount=").append(n3).append(", resumeCursor=").append(string2).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShardQueryRequest) {
            ShardQueryRequest that = (ShardQueryRequest)o;
            return this.query.equals(that.query()) && this.maxShardCount == that.maxShardCount() && this.remainingShardCount == that.remainingShardCount() && this.currentRequestShardCount == that.currentRequestShardCount() && (this.resumeCursor == null ? that.resumeCursor() == null : this.resumeCursor.equals(that.resumeCursor()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.maxShardCount;
        h$ *= 1000003;
        h$ ^= this.remainingShardCount;
        h$ *= 1000003;
        h$ ^= this.currentRequestShardCount;
        h$ *= 1000003;
        return h$ ^= this.resumeCursor == null ? 0 : this.resumeCursor.hashCode();
    }

    @Override
    public ShardQueryRequest.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ShardQueryRequest.Builder {
        private Query query;
        private Integer maxShardCount;
        private Integer remainingShardCount;
        private Integer currentRequestShardCount;
        private Cursor resumeCursor;

        Builder() {
        }

        private Builder(ShardQueryRequest source) {
            this.query = source.query();
            this.maxShardCount = source.maxShardCount();
            this.remainingShardCount = source.remainingShardCount();
            this.currentRequestShardCount = source.currentRequestShardCount();
            this.resumeCursor = source.resumeCursor();
        }

        @Override
        public ShardQueryRequest.Builder query(Query query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public ShardQueryRequest.Builder maxShardCount(int maxShardCount) {
            this.maxShardCount = maxShardCount;
            return this;
        }

        @Override
        public ShardQueryRequest.Builder remainingShardCount(int remainingShardCount) {
            this.remainingShardCount = remainingShardCount;
            return this;
        }

        @Override
        public ShardQueryRequest.Builder currentRequestShardCount(int currentRequestShardCount) {
            this.currentRequestShardCount = currentRequestShardCount;
            return this;
        }

        @Override
        public ShardQueryRequest.Builder resumeCursor(@Nullable Cursor resumeCursor) {
            this.resumeCursor = resumeCursor;
            return this;
        }

        @Override
        public ShardQueryRequest build() {
            String missing = "";
            if (this.query == null) {
                missing = String.valueOf(missing).concat(" query");
            }
            if (this.maxShardCount == null) {
                missing = String.valueOf(missing).concat(" maxShardCount");
            }
            if (this.remainingShardCount == null) {
                missing = String.valueOf(missing).concat(" remainingShardCount");
            }
            if (this.currentRequestShardCount == null) {
                missing = String.valueOf(missing).concat(" currentRequestShardCount");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ShardQueryRequest(this.query, this.maxShardCount, this.remainingShardCount, this.currentRequestShardCount, this.resumeCursor);
        }
    }
}

