/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableTable;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.CollapsedMutation;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntityTransformation;
import com.google.cloud.datastore.core.rep.EntityUpdater;
import com.google.cloud.datastore.core.rep.Mutation;
import com.google.cloud.datastore.core.rep.PropertyMask;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class MutationHelper {
    static final ImmutableTable<Mutation.Op, Mutation.Op, Mutation.Op> OPERATION_COLLAPSES;

    private static Mutation.ExistencePrecondition existenceAfter(Mutation.Op op) {
        switch (op.operation) {
            case WRITE: {
                return Mutation.ExistencePrecondition.MUST_EXIST;
            }
            case DELETE: {
                return Mutation.ExistencePrecondition.MUST_NOT_EXIST;
            }
            case VERIFY: {
                return op.existence;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static Mutation collapse(Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        Mutation.Op op1 = mutation1.op();
        Mutation.Op op2 = mutation2.op();
        OnestoreEntity.Reference key1 = mutation1.key();
        OnestoreEntity.Reference key2 = mutation2.key();
        List<Mutation> subMutations1 = mutation1.subMutations();
        List<Mutation> subMutations2 = mutation2.subMutations();
        ArrayList<Mutation> newSubMutations = new ArrayList<Mutation>();
        newSubMutations.addAll(subMutations1);
        newSubMutations.addAll(subMutations2);
        EntityTransformation entityTransformation1 = mutation1.transformation();
        EntityTransformation entityTransformation2 = mutation2.transformation();
        Long baseVersion1 = mutation1.baseVersion();
        Long baseVersion2 = mutation2.baseVersion();
        Mutation.ConflictResolutionStrategy resolutionStrategy1 = mutation1.conflictResolutionStrategy();
        Mutation.ConflictResolutionStrategy resolutionStrategy2 = mutation2.conflictResolutionStrategy();
        Preconditions.checkArgument((!V3Paths.hasIncompleteLastElement(key1) ? 1 : 0) != 0, (Object)"cannot collapse mutation with incomplete key");
        Preconditions.checkArgument((!V3Paths.hasIncompleteLastElement(key2) ? 1 : 0) != 0, (Object)"cannot collapse mutation with incomplete key");
        Preconditions.checkArgument((boolean)key1.equals(key2), (Object)"cannot collapse mutations with different keys");
        EntityTransformation newEntityTransformation = mutation2.transformation();
        if (entityTransformation1 != null) {
            if (entityTransformation2 == null) {
                newEntityTransformation = mutation1.transformation();
            } else {
                ImmutableList.Builder newTransformations = ImmutableList.builder();
                newTransformations.addAll(mutation1.transformation().propertyTransformations());
                newTransformations.addAll(mutation2.transformation().propertyTransformations());
                newEntityTransformation = EntityTransformation.create((ImmutableList<EntityTransformation.PropertyTransformation>)newTransformations.build());
            }
        }
        InvalidConversionException.checkConversion(mutation1.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        InvalidConversionException.checkConversion(mutation2.entityMetadata() == null, "Cannot collapse mutation with metadata", new Object[0]);
        Mutation.Op collapsedOp = (Mutation.Op)((Object)OPERATION_COLLAPSES.get((Object)op1, (Object)op2));
        InvalidConversionException.checkConversion(collapsedOp != null, "Cannot %s then %s an entity in the same request.", MutationHelper.opNameForErrorMessage(mutation1), MutationHelper.opNameForErrorMessage(mutation2));
        InvalidConversionException.checkConversion(baseVersion2 == null || Objects.equals(baseVersion1, baseVersion2), "Cannot collapse mutations with different base versions (%s and %s)", baseVersion1, baseVersion2);
        InvalidConversionException.checkConversion(resolutionStrategy2 == null || resolutionStrategy1 == resolutionStrategy2, "Cannot collapse mutations with different resolution strategies (%s and %s)", new Object[]{resolutionStrategy1, resolutionStrategy2});
        Mutation.Builder mutationBuilder = Mutation.builder().op(collapsedOp).key(key1).subMutationsInternal(newSubMutations).baseVersion(baseVersion1).conflictResolutionStrategy(resolutionStrategy1);
        if (collapsedOp.operation.equals((Object)Mutation.Operation.WRITE)) {
            mutationBuilder.transformation(newEntityTransformation).transformationOnly(!(!mutation1.transformationOnly() && !mutation1.isVerify() || !mutation2.transformationOnly() && !mutation2.isVerify()));
        }
        switch (op1.operation) {
            case WRITE: {
                return MutationHelper.writeThen(mutationBuilder, mutation1, mutation2);
            }
            case DELETE: {
                return MutationHelper.deleteThen(mutationBuilder, mutation2);
            }
            case VERIFY: {
                return MutationHelper.verifyThen(mutationBuilder, mutation2);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation writeThen(Mutation.Builder mutationBuilder, Mutation mutation1, Mutation mutation2) throws InvalidConversionException {
        switch (mutation2.op().operation) {
            case WRITE: {
                InvalidConversionException.checkConversion(Objects.equals(mutation1.readPropertyMask(), mutation2.readPropertyMask()), "Cannot collapse mutations with different read mask.", new Object[0]);
                return mutationBuilder.entity(mutation2.writePropertyMask().maskInto(mutation2.entity(), mutation1.entity())).writePropertyMask(mutation2.writePropertyMask().merge(mutation1.writePropertyMask())).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(mutation1.recreateEntity()).build();
            }
            case DELETE: {
                return mutationBuilder.build();
            }
            case VERIFY: {
                return mutationBuilder.entity(mutation1.entity()).writePropertyMask(mutation1.writePropertyMask()).readPropertyMask(mutation1.readPropertyMask()).recreateEntity(mutation1.recreateEntity()).build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation deleteThen(Mutation.Builder mutationBuilder, Mutation mutation2) {
        switch (mutation2.op().operation) {
            case WRITE: {
                return mutationBuilder.entity(mutation2.writePropertyMask().mask(mutation2.entity())).writePropertyMask(PropertyMask.FULL).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(true).build();
            }
            case DELETE: 
            case VERIFY: {
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static Mutation verifyThen(Mutation.Builder mutationBuilder, Mutation mutation2) {
        switch (mutation2.op().operation) {
            case WRITE: {
                return mutationBuilder.entity(mutation2.entity()).writePropertyMask(mutation2.writePropertyMask()).readPropertyMask(mutation2.readPropertyMask()).recreateEntity(mutation2.recreateEntity()).build();
            }
            case DELETE: 
            case VERIFY: {
                return mutationBuilder.build();
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static String opNameForErrorMessage(Mutation mutation) {
        return Ascii.toLowerCase((String)(mutation.op().operation.equals((Object)Mutation.Operation.WRITE) ? mutation.op().name() : mutation.op().operation.name()));
    }

    static ImmutableList<CollapsedMutation> collapseMutations(ImmutableList<Mutation> mutations) throws InvalidConversionException {
        HashMap mutationsByKey = Maps.newHashMapWithExpectedSize((int)mutations.size());
        HashMap mutationIndexes = Maps.newHashMapWithExpectedSize((int)mutations.size());
        HashMap ungroupableMutations = Maps.newHashMapWithExpectedSize((int)mutations.size());
        MutationHelper.groupMutationsByKey(mutations, mutationsByKey, mutationIndexes, ungroupableMutations);
        ImmutableList.Builder collapsedMutations = ImmutableList.builder();
        for (Map.Entry m : ungroupableMutations.entrySet()) {
            collapsedMutations.add((Object)MutationHelper.collapseSameKeyMutations((List<Mutation>)ImmutableList.of((Object)((Mutation)m.getValue())), (List<Integer>)ImmutableList.of((Object)((Integer)m.getKey()))));
        }
        for (EntityRef ref : mutationsByKey.keySet()) {
            collapsedMutations.add((Object)MutationHelper.collapseSameKeyMutations((List)mutationsByKey.get(ref), (List)mutationIndexes.get(ref)));
        }
        return collapsedMutations.build();
    }

    static void groupMutationsByKey(ImmutableList<Mutation> mutations, Map<EntityRef, List<Mutation>> mutationsByKey, Map<EntityRef, List<Integer>> mutationIndexes, Map<Integer, Mutation> ungroupableMutations) {
        for (int i = 0; i < mutations.size(); ++i) {
            Mutation mutation = (Mutation)mutations.get(i);
            EntityRef entityRef = mutation.repKey();
            if (entityRef.resourceId() == null) {
                ungroupableMutations.put(i, mutation);
                continue;
            }
            if (mutationsByKey.containsKey(entityRef)) {
                mutationsByKey.get(entityRef).add(mutation);
                mutationIndexes.get(entityRef).add(i);
                continue;
            }
            mutationsByKey.put(entityRef, new ArrayList(ImmutableList.of((Object)mutation)));
            mutationIndexes.put(entityRef, new ArrayList(ImmutableList.of((Object)i)));
        }
    }

    private static CollapsedMutation collapseSameKeyMutations(List<Mutation> mutations, List<Integer> originalIndexes) throws InvalidConversionException {
        int i;
        Mutation.Builder mutationBuilder = mutations.get(0).toBuilder();
        ImmutableList.Builder transformResults = ImmutableList.builder();
        ImmutableList.Builder transformResultIndexes = ImmutableList.builder();
        ImmutableList.Builder preTransformResultIndexes = ImmutableList.builder();
        if (mutationBuilder.transformation() != null) {
            mutationBuilder.preTransforms(mutationBuilder.transformation());
            for (i = 0; i < mutationBuilder.transformation().propertyTransformations().size(); ++i) {
                preTransformResultIndexes.add((Object)CollapsedMutation.TransformResultIndexes.create(originalIndexes.get(0), i));
            }
            mutationBuilder.transformation(null);
        }
        if (mutationBuilder.entity() != null) {
            mutationBuilder.entity(MutationHelper.unusedV3Entity(mutationBuilder.key()));
        }
        for (i = 1; i < mutations.size(); ++i) {
            MutationHelper.collapseInto(mutationBuilder, (ImmutableList.Builder<EntityTransformation.PropertyTransformationResult>)transformResults, (ImmutableList.Builder<CollapsedMutation.TransformResultIndexes>)transformResultIndexes, (ImmutableList.Builder<CollapsedMutation.TransformResultIndexes>)preTransformResultIndexes, mutations.get(i), originalIndexes.get(i));
        }
        return CollapsedMutation.create(mutationBuilder.build(), CollapsedMutation.TransformResults.create((ImmutableList<EntityTransformation.PropertyTransformationResult>)transformResults.build(), (ImmutableList<CollapsedMutation.TransformResultIndexes>)transformResultIndexes.build()), (ImmutableList<CollapsedMutation.TransformResultIndexes>)preTransformResultIndexes.build());
    }

    private static void collapseInto(Mutation.Builder mutationBuilder, ImmutableList.Builder<EntityTransformation.PropertyTransformationResult> transformResults, ImmutableList.Builder<CollapsedMutation.TransformResultIndexes> transformResultIndexes, ImmutableList.Builder<CollapsedMutation.TransformResultIndexes> preTransformResultIndexes, Mutation mutation2, int mutationIndex) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!mutation2.recreateEntity(), "Uncollapsed mutation cannot have recreate set", new Object[0]);
        if (mutationBuilder.baseVersion() != null || mutation2.baseVersion() != null) {
            throw new UnsupportedOperationException();
        }
        if (mutationBuilder.conflictResolutionStrategy() != null || mutation2.conflictResolutionStrategy() != null) {
            throw new UnsupportedOperationException();
        }
        if (mutationBuilder.readPropertyMask() != null || mutation2.readPropertyMask() != null) {
            throw new UnsupportedOperationException();
        }
        if (mutationBuilder.op().isVerify() || mutation2.isVerify()) {
            throw new UnsupportedOperationException();
        }
        if (!mutationBuilder.op().existence.equals((Object)Mutation.ExistencePrecondition.NONE) || !mutation2.op().existence.equals((Object)Mutation.ExistencePrecondition.NONE)) {
            throw new UnsupportedOperationException();
        }
        if (mutation2.isDelete()) {
            mutationBuilder.op(Mutation.Op.from(Mutation.Operation.DELETE, Mutation.ExistencePrecondition.NONE)).recreateEntity(false).repEntity(null).entity(null).writePropertyMask(null);
        } else {
            if (mutationBuilder.op().isDelete()) {
                mutationBuilder.recreateEntity(true).repEntity(mutation2.repEntity()).entity(MutationHelper.unusedV3Entity(mutationBuilder.key())).writePropertyMask(PropertyMask.FULL);
            } else {
                mutationBuilder.repEntity(mutation2.writePropertyMask().maskInto(mutation2.repEntity(), mutationBuilder.repEntity())).writePropertyMask(mutation2.writePropertyMask().merge(mutationBuilder.writePropertyMask()));
            }
            if (mutation2.transformation() != null) {
                MutationHelper.applyOrGatherTransforms(mutationBuilder, mutation2, transformResults, transformResultIndexes, preTransformResultIndexes, mutationIndex);
            }
            mutationBuilder.op(Mutation.Op.from(Mutation.Operation.WRITE, Mutation.ExistencePrecondition.NONE));
        }
    }

    private static void applyOrGatherTransforms(Mutation.Builder mutationBuilder, Mutation mutation2, ImmutableList.Builder<EntityTransformation.PropertyTransformationResult> transformResults, ImmutableList.Builder<CollapsedMutation.TransformResultIndexes> transformResultIndexes, ImmutableList.Builder<CollapsedMutation.TransformResultIndexes> preTransformResultIndexes, int mutationIndex) {
        ImmutableList.Builder preTransforms = ImmutableList.builder();
        if (mutationBuilder.preTransforms() != null) {
            preTransforms.addAll(mutationBuilder.preTransforms().propertyTransformations());
        }
        EntityUpdater entityUpdater = EntityUpdater.create(mutationBuilder.repEntity());
        for (int i = 0; i < mutation2.transformation().propertyTransformations().size(); ++i) {
            EntityTransformation.PropertyTransformation propertyTransform = (EntityTransformation.PropertyTransformation)mutation2.transformation().propertyTransformations().get(i);
            if (MutationHelper.pathInMask(mutationBuilder.writePropertyMask(), propertyTransform.propertyPath())) {
                transformResults.add((Object)EntityTransformation.PropertyTransformationResult.create(entityUpdater.apply(propertyTransform)));
                transformResultIndexes.add((Object)CollapsedMutation.TransformResultIndexes.create(mutationIndex, i));
                continue;
            }
            preTransforms.add((Object)propertyTransform);
            preTransformResultIndexes.add((Object)CollapsedMutation.TransformResultIndexes.create(mutationIndex, i));
        }
        ImmutableList finalPreTransforms = preTransforms.build();
        if (!finalPreTransforms.isEmpty()) {
            mutationBuilder.preTransforms(EntityTransformation.create((ImmutableList<EntityTransformation.PropertyTransformation>)finalPreTransforms));
        }
        mutationBuilder.repEntity(entityUpdater.toEntity());
    }

    private static boolean pathInMask(PropertyMask writeMask, PropertyPath path) {
        if (writeMask.equals(PropertyMask.FULL)) {
            return true;
        }
        PropertyName segment = ((PropertyPathSegment.Member)path.segment()).name();
        if (!writeMask.propertyNames().contains(segment)) {
            return false;
        }
        if (path.next() == null) {
            return true;
        }
        return MutationHelper.pathInMask(writeMask.nestedMask(segment), path.next());
    }

    private static OnestoreEntity.EntityProto unusedV3Entity(OnestoreEntity.Reference key) {
        return new OnestoreEntity.EntityProto().setKey(key);
    }

    static {
        ImmutableTable.Builder collapses = ImmutableTable.builder();
        for (Mutation.Op op1 : Mutation.Op.values()) {
            for (Mutation.Op op2 : Mutation.Op.values()) {
                if (!op2.existence.equals((Object)Mutation.ExistencePrecondition.NONE) && !op2.existence.equals((Object)MutationHelper.existenceAfter(op1))) continue;
                Mutation.Operation collapsedOperation = op2.operation.equals((Object)Mutation.Operation.VERIFY) ? op1.operation : op2.operation;
                collapses.put((Object)op1, (Object)op2, (Object)Mutation.Op.from(collapsedOperation, op1.existence));
            }
        }
        OPERATION_COLLAPSES = collapses.build();
    }
}

