/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.Names;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.logs.ProblemCode;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public abstract class BaseDatastoreValidator {
    protected final Config.DatastoreConfig config;
    protected final ImmutableSet<String> allowedReservedKinds;

    protected BaseDatastoreValidator(Config.DatastoreConfig config) {
        this.config = config;
        this.allowedReservedKinds = ImmutableSet.copyOf((Collection)config.getReservedKindsToAllowList());
    }

    public Config.DatastoreConfig config() {
        return this.config;
    }

    protected void validatePartitionIdDimension(ValidationConstraint constraint, String value, String dimension) throws ValidationException {
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(value, dimension);
        }
        ValidationException.validateAssertion(ProjectIds.PARTITION_ID_REGEX.matcher(value).matches(), "Illegal string \"%s\" in %s.", value, dimension);
    }

    public void validateAppId(ValidationConstraint constraint, String appId) throws ValidationException {
        ValidationException.validateAssertion(!appId.isEmpty(), "The app id is the empty string.", new Object[0]);
        this.validateAppId(constraint, appId, "app id");
    }

    protected void validateAppId(ValidationConstraint constraint, String appId, String description) throws ValidationException {
        try {
            ProjectIds.ParsedAppId parsedAppId = ProjectIds.parseAppId(appId);
            if (!constraint.allowMetadataAccess()) {
                ValidationException.validateAssertion(parsedAppId.metadata() == null, "The %s %s is reserved.", description, appId);
            }
            if (!constraint.allowReservedKey()) {
                this.validateStringNotReserved(parsedAppId.projectId(), description);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(String.format("\"%s\" is an invalid %s.", appId, description), e);
        }
    }

    public void validateProjectId(ValidationConstraint constraint, String projectId) throws ValidationException {
        ValidationException.validateAssertion(ProjectIds.isValidProjectId(projectId), "\"%s\" is an invalid project id.", projectId);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(projectId, "project id");
        }
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, "");
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName, String desc) throws ValidationException {
        this.validatePropertyName(constraint, propertyName, 0, desc);
    }

    public void validatePropertyName(ValidationConstraint constraint, String propertyName, int prefixLength, String desc) throws ValidationException {
        String string = desc = desc.isEmpty() ? "property.name" : String.valueOf(desc).concat(".property.name");
        if (prefixLength > 0) {
            String string2 = String.valueOf(desc);
            desc = string2.length() != 0 ? "flattened ".concat(string2) : new String("flattened ");
        }
        this.validateStringNotEmpty(propertyName, desc);
        this.validateLength(Utf8.encodedLength((CharSequence)propertyName) + prefixLength, this.config.getMaxIndexedValueBytes(), desc);
        boolean isKeyProperty = propertyName.equals(ReservedName.KEY.asString());
        boolean allowKeyProperty = constraint.allowReservedName(this.config, PropertyName.KEY, true, true);
        if (!(constraint.allowReservedName() || allowKeyProperty && isKeyProperty)) {
            this.validateStringNotReserved(propertyName, desc);
        }
    }

    public void validateStringNotReserved(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!Names.isNameReserved(string), "The %s \"%s\" is reserved.", desc, string);
    }

    public void validateStringNotEmpty(String string, String desc) throws ValidationException {
        ValidationException.validateAssertion(!string.isEmpty(), "The %s is the empty string.", desc);
    }

    public void validateLength(String string, int maxLength, String desc) throws ValidationException {
        if (3 * string.length() <= maxLength) {
            return;
        }
        this.validateLength(Utf8.encodedLength((CharSequence)string), maxLength, desc);
    }

    public void validateLength(int length, int maxLength, String desc) throws ValidationException {
        ValidationException.validateAssertion(length <= maxLength, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateLength(int length, int maxLength, ProblemCode problemCode, String desc) throws ValidationException {
        ValidationException.validateAssertion(length <= maxLength, problemCode, "The %s is longer than %d bytes.", desc, maxLength);
    }

    public void validateSameApp(String app1, String app2) throws ValidationException {
        Preconditions.checkNotNull((Object)app1);
        Preconditions.checkNotNull((Object)app2);
        ValidationException.validateAssertion(app1.equals(app2), "%s%s vs. %s", "mismatched app ids within request: ", app1, app2);
    }

    protected void validateGeoPoint(double lat, double lon) throws ValidationException {
        if (!(Math.abs(lat) <= 90.0)) {
            ValidationException.validateAssertion(!Double.isNaN(lat), ProblemCode.INVALID_GEO_POINT, "Geo point latitude is not a number.", new Object[0]);
            ValidationException.validateAssertion(false, ProblemCode.INVALID_GEO_POINT, "Geo point latitude outside permitted range -90.0 to 90.0.", new Object[0]);
        }
        if (!(Math.abs(lon) <= 180.0)) {
            ValidationException.validateAssertion(!Double.isNaN(lon), ProblemCode.INVALID_GEO_POINT, "Geo point longitude is not a number.", new Object[0]);
            ValidationException.validateAssertion(false, ProblemCode.INVALID_GEO_POINT, "Geo point longitude outside permitted range -180.0 to 180.0.", new Object[0]);
        }
    }

    public void validateKind(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, String kind, String desc) throws ValidationException {
        byte[] collectionBytes = ConverterHelper.convertStringToBytesIfNonUtf8(desc, kind);
        if (collectionBytes == null) {
            this.validateUtf8Kind(constraint, kind, desc);
        } else {
            this.validateNonUtf8Kind(constraint, suppressedFailures, collectionBytes, new String(collectionBytes, StandardCharsets.UTF_8), desc);
        }
    }

    protected void validateKeyPathKindWithBytes(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, byte[] kindBytes, String kindString) throws ValidationException {
        String desc = "key path element kind";
        if (Utf8.isWellFormed((byte[])kindBytes)) {
            this.validateUtf8Kind(constraint, kindString, desc);
        } else {
            this.validateNonUtf8Kind(constraint, suppressedFailures, kindBytes, kindString, desc);
        }
    }

    private void validateUtf8Kind(ValidationConstraint constraint, String kindString, String desc) throws ValidationException {
        this.validateStringNotEmpty(kindString, desc);
        this.validateLength(kindString, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedKey() && !this.allowedReservedKinds.contains((Object)kindString)) {
            this.validateStringNotReserved(kindString, desc);
        }
    }

    private void validateNonUtf8Kind(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, byte[] kindBytes, String kindString, String desc) throws ValidationException {
        ValidationException.validateAssertionIf(false, ProblemCode.KIND_NOT_UTF8, constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateKindUtf8(), suppressedFailures, "The %s is not valid UTF-8.", desc);
        this.validateLength(kindBytes.length, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedKey() && !this.allowedReservedKinds.contains((Object)kindString)) {
            this.validateStringNotReserved(kindString, desc);
        }
    }

    void validateKeyPathName(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, String nameString) throws ValidationException {
        String desc = "key path element name";
        byte[] elementBytes = ConverterHelper.convertStringToBytesIfNonUtf8(desc, nameString);
        if (elementBytes == null) {
            this.validateUtf8Name(constraint, nameString, desc);
        } else {
            this.validateNonUtf8Name(constraint, suppressedFailures, elementBytes, new String(elementBytes, StandardCharsets.UTF_8), desc);
        }
    }

    protected void validateKeyPathNameWithBytes(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, byte[] nameBytes, String nameString) throws ValidationException {
        String desc = "key path element name";
        if (Utf8.isWellFormed((byte[])nameBytes)) {
            this.validateStringNotEmpty(nameString, desc);
            this.validateUtf8Name(constraint, nameString, desc);
        } else {
            this.validateNonUtf8Name(constraint, suppressedFailures, nameBytes, nameString, desc);
        }
    }

    private void validateUtf8Name(ValidationConstraint constraint, String nameString, String desc) throws ValidationException {
        this.validateLength(nameString, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(nameString, desc);
        }
    }

    private void validateNonUtf8Name(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, byte[] nameBytes, String nameString, String desc) throws ValidationException {
        ValidationException.validateAssertionIf(false, ProblemCode.KEY_NAME_NOT_UTF8, constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateKeyNameUtf8(), suppressedFailures, "The %s is not valid UTF-8.", desc);
        this.validateLength(nameBytes.length, this.config.getMaxIndexedValueBytes(), desc);
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(nameString, desc);
        }
    }

    public void validateDatabase(ValidationConstraint constraint, String database) throws ValidationException {
        ValidationException.validateAssertion(database.length() <= 100, "The database is longer than %d bytes.", 100);
        this.validatePartitionIdDimension(constraint, database, "database");
    }

    public void validateNonDefaultNamespace(ValidationConstraint constraint, String namespace) throws ValidationException {
        ValidationException.validateAssertion(!namespace.isEmpty(), "The namespace is the empty string.", new Object[0]);
        this.validateNamespace(constraint, namespace);
    }

    public void validateNamespace(ValidationConstraint constraint, String namespace) throws ValidationException {
        if (namespace.isEmpty()) {
            return;
        }
        ValidationException.validateAssertion(namespace.length() <= 100, "The namespace is longer than %d bytes.", 100);
        this.validatePartitionIdDimension(constraint, namespace, "namespace");
    }

    public void validateUserValueObfuscatedGaiaId(Value.LegacyUser user, UserIdObfuscator obfuscator) throws ValidationException {
        try {
            if (!user.obfuscatedGaiaId().isEmpty()) {
                obfuscator.unobfuscate(user.obfuscatedGaiaId());
            }
        }
        catch (InvalidConversionException e) {
            throw new ValidationException("Invalid user id in user value.", e);
        }
    }
}

