/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.primitives.Booleans;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.V3Paths;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.core.rep.validator.BaseDatastoreValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.logs.ProblemCode;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public class IndexValueValidator
extends BaseDatastoreValidator {
    private final UserIdObfuscator obfuscator;

    public IndexValueValidator(Config.DatastoreConfig config, UserIdObfuscator obfuscator) {
        super(config);
        this.obfuscator = obfuscator;
    }

    public void validateDatastoreIndexValue(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, OnestoreEntity.PropertyValue indexValue, String propertyName) throws ValidationException {
        IndexValueValidator.validateV3PropertyValueUnion(indexValue, propertyName);
        if (indexValue.hasReferenceValue()) {
            this.validateReferenceValue(constraint, suppressedFailures, indexValue.getReferenceValue());
        } else if (indexValue.hasPointValue()) {
            if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateGeoPoint()) {
                this.validateGeoPoint(indexValue.getPointValue().getX(), indexValue.getPointValue().getY());
            }
        } else if (indexValue.hasUserValue()) {
            this.validateUserValue(indexValue.getUserValue());
        } else if (indexValue.hasStringValue()) {
            this.validateLength(indexValue.getStringValueAsBytes().length, this.config.getMaxIndexedValueBytes(), new StringBuilder(20 + String.valueOf(propertyName).length()).append("value of property \"").append(propertyName).append("\"").toString());
        }
    }

    public void validateDatastoreIndexValue(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, IndexValue indexValue, String propertyName) throws ValidationException {
        switch (indexValue.type()) {
            case ENTITY_REF: {
                this.validateIndexValueEntityRef(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), suppressedFailures, indexValue);
                break;
            }
            case GEO_POINT: {
                if (!constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateGeoPoint()) break;
                this.validateGeoPoint(indexValue.asGeoPoint().getLatitude(), indexValue.asGeoPoint().getLongitude());
                break;
            }
            case LEGACY_USER: {
                this.validateUserValueObfuscatedGaiaId(indexValue.asLegacyUser(), this.obfuscator);
                break;
            }
            case BYTES: {
                this.validateLength(indexValue.asBytes().size(), this.config.getMaxIndexedValueBytes(), new StringBuilder(20 + String.valueOf(propertyName).length()).append("value of property \"").append(propertyName).append("\"").toString());
                break;
            }
            case NULL: 
            case BOOLEAN: 
            case NUMBER: {
                break;
            }
            case ABSENT_TYPE: 
            case TIMESTAMP: 
            case STRING: 
            case ARRAY: 
            case MAP: {
                String string = String.valueOf((Object)indexValue.type());
                throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string).length()).append("Unsupported value type validating Datastore index value").append(string).toString());
            }
        }
    }

    private void validateKey(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, OnestoreEntity.PropertyValue.ReferenceValue key) throws ValidationException {
        boolean finalElementComplete;
        List path;
        int numKeyPathElements;
        this.validateAppId(constraint, key.getApp());
        if (key.hasNameSpace()) {
            this.validateNonDefaultNamespace(constraint, key.getNameSpace());
        }
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(key.getDatabaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        if (key.hasDatabaseId()) {
            this.validateDatabase(constraint, key.getDatabaseId());
        }
        ValidationException.validateAssertion((numKeyPathElements = (path = key.pathElements()).size()) != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(numKeyPathElements <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        int numIncompleteElements = 0;
        for (int pathIndex = 0; pathIndex < numKeyPathElements; ++pathIndex) {
            OnestoreEntity.PropertyValue.ReferenceValuePathElement element = (OnestoreEntity.PropertyValue.ReferenceValuePathElement)path.get(pathIndex);
            this.validateKeyPathKindWithBytes(constraint, suppressedFailures, element.getTypeAsBytes(), element.getType());
            boolean elementHasName = element.hasName();
            if (element.hasId()) {
                ValidationException.validateAssertion(!elementHasName, "Key path element has both id (%d) and name (\"%s\").", element.getId(), element.getName());
                if (pathIndex < numKeyPathElements - 1) {
                    ValidationException.validateAssertion(element.getId() != 0L, "Key path element id is invalid. Must not be zero.", new Object[0]);
                    continue;
                }
                if (element.getId() != 0L) continue;
                ++numIncompleteElements;
                continue;
            }
            if (elementHasName) {
                this.validateKeyPathNameWithBytes(constraint, suppressedFailures, element.getNameAsBytes(), element.getName());
                continue;
            }
            ++numIncompleteElements;
        }
        OnestoreEntity.PropertyValue.ReferenceValuePathElement finalElement = (OnestoreEntity.PropertyValue.ReferenceValuePathElement)path.get(numKeyPathElements - 1);
        boolean bl = finalElementComplete = finalElement.hasId() && finalElement.getId() != 0L || finalElement.hasName();
        if (!constraint.allowCompleteKey()) {
            ValidationException.validateAssertion(!finalElementComplete, "Key path element must not be complete: %s", V3Paths.toPathString(key));
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            ValidationException.validateAssertion(finalElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, "Key path element must not be incomplete: %s", V3Paths.toPathString(key));
        }
        ValidationException.validateAssertion(numIncompleteElements == (finalElementComplete ? 0 : 1), "Key path element must not be incomplete: %s", V3Paths.toPathString(key));
        String constraintPartitionId = constraint.partitionId();
        String keyPartitionId = ProjectIds.parseAppId(key.getApp()).partitionId();
        ValidationException.validateAssertionIf(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition(), suppressedFailures, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
        int keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes();
        if (keySizeLimit > 0) {
            this.validateLength(EntitySize.keyValueSize(key), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    private void validateReferenceValue(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, OnestoreEntity.PropertyValue.ReferenceValue ref) throws ValidationException {
        this.validateKey(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), suppressedFailures, ref);
    }

    private void validateUserValue(OnestoreEntity.PropertyValue.UserValue v3UserValue) throws ValidationException {
        ValidationException.validateAssertion(!v3UserValue.hasNickname(), "nickname is not supported yet", new Object[0]);
        try {
            if (v3UserValue.hasObfuscatedGaiaid()) {
                this.obfuscator.unobfuscate(v3UserValue.getObfuscatedGaiaid());
            }
        }
        catch (InvalidConversionException e) {
            throw new ValidationException("Invalid user id in user value.", e);
        }
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.email", v3UserValue.getEmailAsBytes());
        this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
        if (v3UserValue.hasFederatedIdentity()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
        }
        if (v3UserValue.hasFederatedProvider()) {
            this.validateUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
        }
    }

    private void validateIndexValueEntityRef(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, IndexValue indexRef) throws ValidationException {
        IndexValue.EntityRef ref = indexRef.asEntityRef();
        this.validateAppId(constraint, ref.databaseRef().appId());
        if (!ref.namespaceId().equals(IndexValue.EMPTY_STRING)) {
            this.validateNonDefaultNamespace(constraint, ref.namespaceId().asString());
        }
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(ref.databaseRef().databaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        this.validateDatabase(constraint, ref.databaseRef().databaseId());
        ImmutableList<IndexValue> path = ref.segments().asArray();
        int numKeyPathSegments = path.size();
        ValidationException.validateAssertion(numKeyPathSegments != 0, "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion((numKeyPathSegments + 1) / 2 <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        boolean finalElementComplete = numKeyPathSegments % 2 == 0;
        for (int pathIndex = 0; pathIndex < numKeyPathSegments; ++pathIndex) {
            IndexValue element = (IndexValue)path.get(pathIndex);
            if (pathIndex % 2 == 0) {
                this.validateKind(constraint, suppressedFailures, element.asString(), "key path element kind");
                continue;
            }
            if (element.type() == IndexValue.Type.STRING) {
                if (pathIndex < numKeyPathSegments - 1) {
                    ValidationException.validateAssertion(!element.asString().isEmpty(), "Key path element must not be incomplete: %s", IndexValueValidator.toPathString(path));
                } else if (element.asString().isEmpty()) {
                    finalElementComplete = false;
                }
                this.validateKeyPathName(constraint, suppressedFailures, element.asString());
                continue;
            }
            if (pathIndex < numKeyPathSegments - 1) {
                ValidationException.validateAssertion(element.asNumberLong() != 0L, "Key path element id is invalid. Must not be zero.", new Object[0]);
                continue;
            }
            if (element.asNumberLong() != 0L) continue;
            finalElementComplete = false;
        }
        if (!constraint.allowCompleteKey()) {
            ValidationException.validateAssertion(!finalElementComplete, "Key path element must not be complete: %s", IndexValueValidator.toPathString(path));
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            ValidationException.validateAssertion(finalElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, "Key path element must not be incomplete: %s", IndexValueValidator.toPathString(path));
        }
        String constraintPartitionId = constraint.partitionId();
        String keyPartitionId = ProjectIds.parseAppId(ref.databaseRef().appId()).partitionId();
        ValidationException.validateAssertionIf(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition(), suppressedFailures, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
        int keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes();
        if (keySizeLimit > 0) {
            this.validateLength(indexRef.naturalSize(), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    private static String toPathString(List<IndexValue> path) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < path.size(); ++i) {
            if (i % 2 == 0) {
                stringBuilder.append(path.get(i).asString());
                stringBuilder.append(": ");
                continue;
            }
            stringBuilder.append(path.get(i).type() == IndexValue.Type.STRING ? path.get(i).asString() : String.valueOf(path.get(i).asNumberLong()));
            if (i >= path.size() - 1) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private void validateUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws ValidationException {
        if (!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8()) {
            return;
        }
        ValidationException.validateAssertion(Utf8.isWellFormed((byte[])bytes), ProblemCode.USER_FIELD_VALUE_NOT_UTF8, "Non-UTF-8 bytes in user field %s.", fieldName);
    }

    private static void validateV3PropertyValueUnion(OnestoreEntity.PropertyValue value, String propertyName) throws ValidationException {
        int numValues = Booleans.countTrue((boolean[])new boolean[]{value.hasInt64Value(), value.hasStringValue(), value.hasBooleanValue(), value.hasDoubleValue(), value.hasPointValue(), value.hasUserValue(), value.hasReferenceValue()});
        ValidationException.validateAssertion(numValues <= 1, "The value \"%s\" has multiple types set.", propertyName);
    }
}

