/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log.dev;

import com.google.appengine.api.log.dev.DevLogHandler;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.DevLogService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.apphosting.api.logservice.LogServicePb;
import com.google.auto.service.AutoService;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Handler;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoService(value={LocalRpcService.class})
public class LocalLogService
extends AbstractLocalRpcService
implements DevLogService {
    private static final String DEFAULT_MODULE = "default";
    private static final ThreadLocal<Long> threadLocalResponseSize = new ThreadLocal();
    private final List<LogServicePb.RequestLog> logs = new ArrayList<LogServicePb.RequestLog>();
    private static final int MAX_NUM_LOGS = 1000;

    public String getPackage() {
        return "logservice";
    }

    public synchronized LogServicePb.LogReadResponse read(LocalRpcService.Status status, LogServicePb.LogReadRequest request) {
        int i;
        LogServicePb.LogReadResponse.Builder response = LogServicePb.LogReadResponse.newBuilder();
        Integer index = 0;
        HashSet requestedIds = null;
        if (!request.getRequestIdList().isEmpty()) {
            requestedIds = new HashSet(request.getRequestIdList());
        }
        if (request.hasOffset()) {
            index = null;
            BigInteger requestToFind = new BigInteger(request.getOffset().getRequestId().toStringUtf8(), 16);
            for (i = 0; i < this.logs.size(); ++i) {
                BigInteger thisRequestId = new BigInteger(this.logs.get(i).getRequestId().toStringUtf8(), 16);
                if (requestToFind.compareTo(thisRequestId) <= 0) continue;
                index = i;
                break;
            }
            if (index == null) {
                return response.build();
            }
        }
        int numResultsFetched = 0;
        for (i = index.intValue(); i < this.logs.size(); ++i) {
            LogServicePb.RequestLog thisLog = null;
            int j = 0;
            for (LogServicePb.RequestLog requestLog : this.logs) {
                if (i == j) {
                    thisLog = requestLog;
                    break;
                }
                ++j;
            }
            if (requestedIds != null && !requestedIds.contains(thisLog.getRequestId()) || request.hasStartTime() && request.getStartTime() > thisLog.getEndTime() || request.hasEndTime() && request.getEndTime() <= thisLog.getEndTime() || !request.getIncludeIncomplete() && !thisLog.getFinished() || !request.getVersionIdList().isEmpty() && !request.getVersionIdList().contains((Object)thisLog.getVersionId()) && thisLog.hasVersionId()) continue;
            if (!request.getModuleVersionList().isEmpty() && (thisLog.hasModuleId() || thisLog.hasVersionId())) {
                boolean moduleVersionMatch = false;
                for (LogServicePb.LogModuleVersion moduleVersion : request.getModuleVersionList()) {
                    if (!thisLog.getModuleId().equals(moduleVersion.getModuleId()) || !thisLog.getVersionId().equals(moduleVersion.getVersionId())) continue;
                    moduleVersionMatch = true;
                }
                if (!moduleVersionMatch) continue;
            }
            if (request.hasMinimumLogLevel()) {
                boolean logLevelMatched = false;
                for (LogServicePb.LogLine line : thisLog.getLineList()) {
                    if (line.getLevel() < request.getMinimumLogLevel()) continue;
                    logLevelMatched = true;
                    break;
                }
                if (!logLevelMatched) continue;
            }
            LogServicePb.RequestLog.Builder logCopy = (LogServicePb.RequestLog.Builder)thisLog.toBuilder().clone();
            this.fillRequiredFields(logCopy);
            if (!request.getIncludeAppLogs()) {
                logCopy.clearLine();
            }
            response.addLog(logCopy.build());
            if ((long)(++numResultsFetched) < request.getCount()) continue;
            if (i + 1 >= this.logs.size()) break;
            ByteString byteString = this.logs.get(i).getRequestId();
            LogServicePb.LogOffset offset = LogServicePb.LogOffset.newBuilder().setRequestId(byteString).build();
            response.setOffset(offset);
            break;
        }
        return response.build();
    }

    private void fillRequiredFields(LogServicePb.RequestLog.Builder logBuilder) {
        if (!logBuilder.hasAppId()) {
            logBuilder.setAppId("");
        }
        if (!logBuilder.hasVersionId()) {
            logBuilder.setVersionId("");
        }
        if (!logBuilder.hasIp()) {
            logBuilder.setIp("");
        }
        if (!logBuilder.hasStartTime()) {
            logBuilder.setStartTime(0L);
        }
        if (!logBuilder.hasEndTime()) {
            logBuilder.setEndTime(0L);
        }
        if (!logBuilder.hasLatency()) {
            logBuilder.setLatency(0L);
        }
        if (!logBuilder.hasMcycles()) {
            logBuilder.setMcycles(0L);
        }
        if (!logBuilder.hasMethod()) {
            logBuilder.setMethod("");
        }
        if (!logBuilder.hasResource()) {
            logBuilder.setResource("");
        }
        if (!logBuilder.hasHttpVersion()) {
            logBuilder.setHttpVersion("");
        }
        if (!logBuilder.hasResponseSize()) {
            logBuilder.setResponseSize(0L);
        }
        if (!logBuilder.hasUrlMapEntry()) {
            logBuilder.setUrlMapEntry("");
        }
        if (!logBuilder.hasCombined()) {
            logBuilder.setCombined("");
        }
        if (!logBuilder.hasStatus()) {
            logBuilder.setStatus(0);
        }
    }

    public synchronized void registerResponseSize(long responseSize) {
        threadLocalResponseSize.set(responseSize);
    }

    @VisibleForTesting
    public synchronized Long getResponseSize() {
        return threadLocalResponseSize.get() == null ? 0L : threadLocalResponseSize.get();
    }

    public synchronized void clearResponseSize() {
        threadLocalResponseSize.remove();
    }

    public void addRequestInfo(String appId, String versionId, String requestId, @Nullable String ip, @Nullable String nickname, long startTimeUsec, long endTimeUsec, String method, String resource, String httpVersion, @Nullable String userAgent, boolean complete, @Nullable Integer status, @Nullable String referrer) {
        this.addRequestInfo(appId, DEFAULT_MODULE, versionId, requestId, ip, nickname, startTimeUsec, endTimeUsec, method, resource, httpVersion, userAgent, complete, status, referrer);
    }

    public synchronized void addRequestInfo(String appId, String moduleId, String versionId, String requestId, @Nullable String ip, @Nullable String nickname, long startTimeUsec, long endTimeUsec, String method, String resource, String httpVersion, @Nullable String userAgent, boolean complete, @Nullable Integer status, @Nullable String referrer) {
        LogServicePb.RequestLog existingOrNewLog = this.findLogInLogMapOrAddNewLog(requestId);
        int index = this.logs.indexOf(existingOrNewLog);
        LogServicePb.RequestLog.Builder log = existingOrNewLog.toBuilder().setAppId(appId);
        String majorVersionId = (String)Splitter.on((char)'.').splitToList((CharSequence)versionId).get(0);
        if (moduleId.equals(DEFAULT_MODULE)) {
            log.setModuleId(moduleId);
        }
        log.setVersionId(majorVersionId).setStartTime(startTimeUsec).setEndTime(endTimeUsec);
        if (ip != null) {
            log.setIp(ip);
        }
        if (nickname != null) {
            log.setNickname(nickname);
        }
        log.setLatency(endTimeUsec - startTimeUsec).setMcycles(0L).setMethod(method).setResource(resource).setHttpVersion(httpVersion);
        Long responseSize = this.getResponseSize();
        log.setResponseSize(responseSize.longValue()).setStatus(status.intValue());
        if (referrer != null) {
            log.setReferrer(referrer);
        }
        log.setCombined(this.formatCombinedLog(ip, nickname, endTimeUsec, method, resource, httpVersion, status, responseSize, referrer, userAgent));
        if (userAgent != null) {
            log.setUserAgent(userAgent);
        }
        log.setUrlMapEntry("").setFinished(complete);
        this.logs.set(index, log.build());
    }

    public synchronized void addAppLogLine(String requestId, long time, int level, String message) {
        if (message == null) {
            return;
        }
        LogServicePb.LogLine line = LogServicePb.LogLine.newBuilder().setTime(time).setLevel(level).setLogMessage(message).build();
        int index = this.logs.indexOf(this.findLogInLogMapOrAddNewLog(requestId));
        LogServicePb.RequestLog log = this.findLogInLogMapOrAddNewLog(requestId).toBuilder().addLine(line).buildPartial();
        this.logs.set(index, log);
    }

    private synchronized LogServicePb.RequestLog findLogInLogMapOrAddNewLog(String requestId) {
        if (requestId == null) {
            requestId = "null";
        }
        for (int i = 0; i < this.logs.size(); ++i) {
            LogServicePb.RequestLog possibleLog = this.logs.get(i);
            if (!possibleLog.getRequestId().toStringUtf8().equals(requestId)) continue;
            return possibleLog;
        }
        LogServicePb.RequestLog.Builder log = LogServicePb.RequestLog.newBuilder().setRequestId(ByteString.copyFromUtf8((String)requestId)).setFinished(false);
        LogServicePb.LogOffset offset = LogServicePb.LogOffset.newBuilder().setRequestId(ByteString.copyFromUtf8((String)requestId)).build();
        LogServicePb.RequestLog built = log.setOffset(offset).buildPartial();
        this.logs.add(0, built);
        if (this.logs.size() > 1000) {
            this.logs.remove(this.logs.size() - 1);
        }
        return built;
    }

    private String formatCombinedLog(@Nullable String ip, @Nullable String nickname, long endTimeUsec, String method, String resource, @Nullable String httpVersion, @Nullable Integer status, @Nullable Long responseSize, @Nullable String referrer, @Nullable String userAgent) {
        String result = String.format("%1$s - %2$s [%3$s] \"%4$s %5$s %6$s\" %7$s %8$s %9$s %10$s", this.formatOptionalString(ip), this.formatOptionalString(nickname), this.formatTime(endTimeUsec), method, resource, httpVersion, this.formatOptionalInteger(status), this.formatResponseSize(responseSize), this.formatOptionalQuotedString(referrer), this.formatOptionalQuotedString(userAgent));
        return result;
    }

    private String formatTime(long timeUsec) {
        SimpleDateFormat format = new SimpleDateFormat("d/MMM/yyyy:HH:mm:ss Z", Locale.ENGLISH);
        TimeZone zone = TimeZone.getTimeZone("UTC");
        format.setTimeZone(zone);
        return format.format(new Date(timeUsec / 1000L));
    }

    private String formatOptionalQuotedString(String value) {
        if (value == null || value.length() == 0) {
            return "-";
        }
        return new StringBuilder(2 + String.valueOf(value).length()).append("\"").append(value).append("\"").toString();
    }

    private String formatOptionalString(String value) {
        if (value == null || value.length() == 0) {
            return "-";
        }
        return value;
    }

    private String formatOptionalInteger(Integer value) {
        if (value == null) {
            return "-";
        }
        return value.toString();
    }

    private String formatResponseSize(long responseSize) {
        return Long.toString(responseSize);
    }

    public Handler getLogHandler() {
        return new DevLogHandler(this);
    }

    public synchronized void clear() {
        this.logs.clear();
    }
}

