/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail.dev;

import com.google.appengine.api.mail.MailService;
import com.google.appengine.api.mail.MailServicePb;
import com.google.appengine.api.mail.MailStubServicePb;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.proto2api.ApiBasePb;
import com.google.auto.service.AutoService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@AutoService(value={LocalRpcService.class})
public final class LocalMailService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "mail";
    public static final String LOG_MAIL_BODY_PROPERTY = "mail.log_mail_body";
    static final boolean DEFAULT_LOG_MAIL_BODY = false;
    public static final String LOG_MAIL_LEVEL_PROPERTY = "mail.log_mail_level";
    static final Level DEFAULT_LOG_MAIL_LEVEL = Level.INFO;
    boolean logMailBody = false;
    Level logMailLevel = DEFAULT_LOG_MAIL_LEVEL;
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    static final Set<String> blacklist = new HashSet<String>();
    private List<MailServicePb.MailMessage> sentMessages = Collections.synchronizedList(new ArrayList());

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        String logMailBodyStr = properties.get(LOG_MAIL_BODY_PROPERTY);
        this.logMailBody = logMailBodyStr != null ? Boolean.parseBoolean(logMailBodyStr) : false;
        String logLevelStr = properties.get(LOG_MAIL_LEVEL_PROPERTY);
        this.logMailLevel = logLevelStr != null ? Level.parse(logLevelStr) : DEFAULT_LOG_MAIL_LEVEL;
    }

    public void start() {
    }

    public void stop() {
        this.clearSentMessages();
    }

    public ApiBasePb.VoidProto send(LocalRpcService.Status status, MailServicePb.MailMessage msg) {
        this.logMailMessage("send", msg);
        this.checkAttachments(msg);
        this.sentMessages.add(msg);
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    public ApiBasePb.VoidProto sendToAdmins(LocalRpcService.Status status, MailServicePb.MailMessage msg) {
        this.logMailMessage("sendToAdmins", msg);
        this.checkAttachments(msg);
        this.sentMessages.add(msg);
        return ApiBasePb.VoidProto.getDefaultInstance();
    }

    private void checkAttachments(MailServicePb.MailMessage msg) {
        for (MailServicePb.MailAttachment attachment : msg.getAttachmentList()) {
            this.checkAttachementFileName(attachment.getFileName());
        }
    }

    private void checkAttachementFileName(String fileName) {
        String invalidTypeMsg = "Invalid attachment type";
        if ((fileName = fileName.toLowerCase().trim()).startsWith(".")) {
            throw new ApiProxy.ApplicationException(MailServicePb.MailServiceError.ErrorCode.INVALID_ATTACHMENT_TYPE.getNumber(), "Invalid attachment type");
        }
        int extensionStart = fileName.lastIndexOf(46);
        if (extensionStart == -1) {
            throw new ApiProxy.ApplicationException(MailServicePb.MailServiceError.ErrorCode.INVALID_ATTACHMENT_TYPE.getNumber(), "Invalid attachment type");
        }
        String extension = fileName.substring(extensionStart + 1);
        if (blacklist.contains(extension)) {
            throw new ApiProxy.ApplicationException(MailServicePb.MailServiceError.ErrorCode.INVALID_ATTACHMENT_TYPE.getNumber(), "Invalid attachment type");
        }
    }

    private void log(String logMsg) {
        this.logger.log(this.logMailLevel, logMsg);
    }

    void logMailMessage(String method, MailServicePb.MailMessage msg) {
        this.log(String.format("%s.%s", MailService.class.getSimpleName(), method));
        this.log(String.format("  From: %s", msg.getSender()));
        for (String to : msg.getToList()) {
            this.log(String.format("  To: %s", to));
        }
        for (String cc : msg.getCcList()) {
            this.log(String.format("  Cc: %s", cc));
        }
        for (String bcc : msg.getBccList()) {
            this.log(String.format("  Bcc: %s", bcc));
        }
        if (msg.hasReplyTo()) {
            this.log(String.format("  Reply-to: %s", msg.getReplyTo()));
        }
        this.log(String.format("  Subject: %s", msg.getSubject()));
        if (msg.hasTextBody()) {
            this.log("  Body:");
            this.log("    Content-type: text/plain");
            this.log(String.format("    Data length: %d", msg.getTextBody().length()));
            if (this.logMailBody) {
                this.log(String.format("-----\n%s\n-----", msg.getTextBody()));
            }
        }
        if (msg.hasAmpHtmlBody()) {
            this.log("  Body:");
            this.log("    Content-type: text/x-amp-html");
            this.log(String.format("    Data length: %d", msg.getAmpHtmlBody().length()));
            if (this.logMailBody) {
                this.log(String.format("-----\n%s\n-----", msg.getAmpHtmlBody()));
            }
        }
        if (msg.hasHtmlBody()) {
            this.log("  Body:");
            this.log("    Content-type: text/html");
            this.log(String.format("    Data length: %d", msg.getHtmlBody().length()));
            if (this.logMailBody) {
                this.log(String.format("-----\n%s\n-----", msg.getHtmlBody()));
            }
        }
        for (MailServicePb.MailAttachment attachment : msg.getAttachmentList()) {
            this.log("  Attachment:");
            this.log(String.format("    File name: %s", attachment.getFileName()));
            this.log(String.format("    Data length: %d", attachment.getData().size()));
        }
    }

    public List<MailServicePb.MailMessage> getSentMessages() {
        return this.getSentMessagesInternal();
    }

    private List<MailServicePb.MailMessage> getSentMessagesInternal() {
        return new ArrayList<MailServicePb.MailMessage>(this.sentMessages);
    }

    public void clearSentMessages() {
        this.clearSentMessagesInternal();
    }

    private void clearSentMessagesInternal() {
        this.sentMessages.clear();
    }

    MailStubServicePb.GetLogMailBodyResponse getLogMailBody() {
        return MailStubServicePb.GetLogMailBodyResponse.newBuilder().setLogMailBody(this.logMailBody).build();
    }

    Level getLogMailLevel() {
        return this.logMailLevel;
    }

    public Integer getMaxApiRequestSize() {
        return 0x2000000;
    }

    static {
        Collections.addAll(blacklist, "ade", "adp", "bat", "chm", "cmd", "com", "cpl", "exe", "hta", "ins", "isp", "jse", "lib", "mde", "msc", "msp", "mst", "pif", "scr", "sct", "shb", "sys", "vb", "vbe", "vbs", "vxd", "wsc", "wsf", "wsh");
    }
}

