/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultiset;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.Timestamps;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.cloud.datastore.admininternal.FinalizeIndexingRequest;
import com.google.cloud.datastore.admininternal.InitializeIndexingRequest;
import com.google.cloud.datastore.admininternal.InitializeIndexingViaUpdateIndexRequest;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.CompositeIndex;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Direction;
import com.google.cloud.datastore.core.rep.IndexConfiguration;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexFinalizationRequest;
import com.google.cloud.datastore.core.rep.IndexInitializationRequest;
import com.google.cloud.datastore.core.rep.IndexState;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.Query;
import com.google.cloud.datastore.core.rep.WorkflowState;
import com.google.cloud.datastore.core.rep.converter.EquivalentMessageConverter;
import com.google.cloud.datastore.core.rep.converter.GoogleSqlPropertyPathToRepConverter;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import javax.annotation.Nullable;

public class IndexAppEngV3ToRepConverter {
    public static final IndexAppEngV3ToRepConverter INSTANCE = new IndexAppEngV3ToRepConverter();
    static final String ERROR_COLLECTION_ID_IS_REQUIRED = "collection id is required";
    static final String ERROR_MIN_INITIALIZE_TIME_IS_REQUIRED = "min initialize time is required";

    private IndexAppEngV3ToRepConverter() {
    }

    @Nullable
    public static Direction convertV3IndexDirectionToRep(OnestoreEntity.Index.Property.Direction direction) {
        switch (direction) {
            case ASCENDING: {
                return Direction.ASCENDING;
            }
            case DESCENDING: {
                return Direction.DESCENDING;
            }
            case DIRECTION_UNSPECIFIED: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    public DatabaseIndexGroup convertDatabaseIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3Indexes, IndexConfiguration indexConfiguration) throws InvalidConversionException {
        ImmutableList<CompositeIndex> indexes = this.convertIndexes(database, v3Indexes);
        return DatabaseIndexGroup.create((ImmutableMultiset<CompositeIndex>)ImmutableMultiset.copyOf(indexes), indexConfiguration);
    }

    public ImmutableList<CompositeIndex> convertIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        return this.internalConvertIndexes(database, v3CompositeIndexes);
    }

    public ImmutableList<CompositeIndex> convertIndexes(List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        return this.internalConvertIndexes(null, v3CompositeIndexes);
    }

    private ImmutableList<CompositeIndex> internalConvertIndexes(@Nullable DatabaseRef database, List<OnestoreEntity.CompositeIndex> v3CompositeIndexes) throws InvalidConversionException {
        ImmutableList.Builder compositeIndexesBuilder = ImmutableList.builder();
        for (OnestoreEntity.CompositeIndex v3CompositeIndex : v3CompositeIndexes) {
            CompositeIndex index = this.internalConvertIndex(database, v3CompositeIndex);
            compositeIndexesBuilder.add((Object)index);
        }
        return compositeIndexesBuilder.build();
    }

    public CompositeIndex convertIndexFromProto2CompositeIndex(OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.convertIndex((OnestoreEntity.CompositeIndex)EquivalentMessageConverter.create(OnestoreEntity.CompositeIndex.parser()).apply(v3CompositeIndex));
    }

    public CompositeIndex convertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(database, v3CompositeIndex);
    }

    public CompositeIndex convertIndex(OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(null, v3CompositeIndex);
    }

    private CompositeIndex internalConvertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex) throws InvalidConversionException {
        return this.internalConvertIndex(database, v3CompositeIndex, null);
    }

    private CompositeIndex internalConvertIndex(@Nullable DatabaseRef database, OnestoreEntity.CompositeIndex v3CompositeIndex, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        DatabaseRef actualDatabase = (DatabaseRef)AppEngV3DatabaseRefExtractor.INSTANCE.extractValidated((MessageLite)v3CompositeIndex);
        InvalidConversionException.checkConversion(database == null || actualDatabase.equals(database), "the composite index specifies the wrong database: %s, %s", actualDatabase, database);
        InvalidConversionException.checkConversion(v3CompositeIndex.getStateEnum() != null, "a composite index must specify a state");
        CompositeIndex.Builder indexBuilder = CompositeIndex.builder().definition(this.convertIndexDef(v3CompositeIndex.getDefinition(), defaultPropertyMode)).id(v3CompositeIndex.getId()).indexState(this.convertIndexState(v3CompositeIndex.getStateEnum()));
        return indexBuilder.build();
    }

    public IndexDef convertCreateIndexRequest(OnestoreEntity.CompositeIndex v3IndexDef) throws InvalidConversionException {
        return this.convertIndexDef(v3IndexDef.getDefinition(), null);
    }

    public IndexDef convertIndexDefFromProto2IndexDef(OnestoreEntity.Index v3IndexDef, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        return this.convertIndexDef((OnestoreEntity.Index)EquivalentMessageConverter.create(OnestoreEntity.Index.parser()).apply(v3IndexDef), defaultPropertyMode);
    }

    private IndexDef convertIndexDef(OnestoreEntity.Index v3IndexDef, @Nullable IndexDef.PropertyDef.Mode defaultPropertyMode) throws InvalidConversionException {
        Query.Semantics version = Query.Semantics.DATASTORE;
        if (v3IndexDef.getVersionEnum().equals((Object)OnestoreEntity.Index.Version.V2)) {
            version = Query.Semantics.FIRESTORE;
        }
        if (defaultPropertyMode == null) {
            defaultPropertyMode = this.computeDefaultPropertyMode(v3IndexDef);
        }
        ImmutableList.Builder propertiesBuilder = ImmutableList.builder();
        for (OnestoreEntity.Index.Property v3PropertyDef : v3IndexDef.propertys()) {
            propertiesBuilder.add((Object)this.convertIndexPropertyDef(defaultPropertyMode, v3PropertyDef, version.equals((Object)Query.Semantics.FIRESTORE)));
        }
        ImmutableList properties = propertiesBuilder.build();
        String kind = v3IndexDef.getEntityType();
        if (kind.isEmpty()) {
            kind = null;
        }
        IndexDef.IndexAncestor indexAncestor = IndexDef.IndexAncestor.NONE;
        if (v3IndexDef.isAncestor()) {
            indexAncestor = IndexDef.IndexAncestor.ANCESTOR;
        } else if (v3IndexDef.isParent()) {
            indexAncestor = IndexDef.IndexAncestor.PARENT;
        }
        return IndexDef.create(version, kind, indexAncestor, (ImmutableList<IndexDef.PropertyDef>)properties);
    }

    private IndexDef.PropertyDef.Mode computeDefaultPropertyMode(OnestoreEntity.Index v3IndexDef) throws InvalidConversionException {
        for (OnestoreEntity.Index.Property v3PropertyDef : v3IndexDef.propertys()) {
            if (v3PropertyDef.getModeEnum() != OnestoreEntity.Index.Property.Mode.GEOSPATIAL) continue;
            return IndexDef.PropertyDef.Mode.EQUALITY;
        }
        return IndexDef.PropertyDef.Mode.ORDERED;
    }

    private IndexDef.PropertyDef convertIndexPropertyDef(IndexDef.PropertyDef.Mode defaultPropertyMode, OnestoreEntity.Index.Property v3PropertyDef, boolean isFirestore) throws InvalidConversionException {
        PropertyPath path;
        IndexDef.PropertyDef.Mode propertyMode;
        switch (v3PropertyDef.getModeEnum()) {
            case MODE_UNSPECIFIED: {
                propertyMode = defaultPropertyMode;
                break;
            }
            case GEOSPATIAL: {
                propertyMode = IndexDef.PropertyDef.Mode.GEOSPATIAL;
                break;
            }
            case ARRAY_CONTAINS: {
                InvalidConversionException.checkConversion(isFirestore, "ARRAY_CONTAINS is not allowed in Cloud Datastore.");
                propertyMode = IndexDef.PropertyDef.Mode.ORDERED;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Direction direction = IndexAppEngV3ToRepConverter.convertV3IndexDirectionToRep(v3PropertyDef.getDirectionEnum());
        if (direction == null && propertyMode == IndexDef.PropertyDef.Mode.ORDERED) {
            direction = Direction.ASCENDING;
        }
        InvalidConversionException.checkConversion(propertyMode == IndexDef.PropertyDef.Mode.ORDERED != (direction == null), "direction required");
        InvalidConversionException.checkConversion(Utf8.isWellFormed((byte[])v3PropertyDef.getNameAsBytes()), "non-Utf-8 property path");
        PropertyPath propertyPath = path = isFirestore ? GoogleSqlPropertyPathToRepConverter.NAME_INSTANCE.convertPropertyPath(v3PropertyDef.getName()) : PropertyPath.createFromAmbiguousPathString(v3PropertyDef.getName());
        if (isFirestore && OnestoreEntity.Index.Property.Mode.ARRAY_CONTAINS.equals((Object)v3PropertyDef.getModeEnum())) {
            path = PropertyPath.create(path, PropertyPathSegment.AllArrayElements.create());
        }
        return IndexDef.PropertyDef.create(path, propertyMode, direction);
    }

    public IndexState convertIndexState(OnestoreEntity.CompositeIndex.State v3IndexState) throws InvalidConversionException {
        switch (v3IndexState) {
            case WRITE_ONLY: {
                return IndexState.of(WorkflowState.ENABLING);
            }
            case READ_WRITE: {
                return IndexState.of(WorkflowState.SERVING);
            }
            case DELETED: {
                return IndexState.of(WorkflowState.DISABLING);
            }
            case ERROR: {
                return IndexState.create(WorkflowState.DISABLING, true);
            }
        }
        throw new InvalidConversionException("unknown v3 composite index state");
    }

    public IndexInitializationRequest convertInitializeIndexingRequest(InitializeIndexingViaUpdateIndexRequest envelope) throws InvalidConversionException {
        InitializeIndexingRequest request = envelope.getInitializeIndexingRequest();
        InvalidConversionException.checkConversion(!request.getCollectionId().isEmpty(), ERROR_COLLECTION_ID_IS_REQUIRED);
        InvalidConversionException.checkConversion(request.hasMinInitializeTime() || envelope.hasMinInitializeTime(), ERROR_MIN_INITIALIZE_TIME_IS_REQUIRED);
        Timestamp initializeTime = envelope.getMinInitializeTime();
        if (request.hasMinInitializeTime()) {
            initializeTime = request.getMinInitializeTime();
        }
        try {
            return IndexInitializationRequest.create(request.getCollectionId(), Timestamps.toMicros((Timestamp)initializeTime));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConversionException(e);
        }
    }

    public IndexFinalizationRequest convertFinalizeIndexingRequest(FinalizeIndexingRequest request) throws InvalidConversionException {
        try {
            return IndexFinalizationRequest.builder().kind(request.getCollectionId()).isError(request.getError()).minStartTimeMicros(Timestamps.toMicros((Timestamp)request.getMinStartTime())).indexes((ImmutableList<CompositeIndex>)ImmutableList.of()).build();
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConversionException(e);
        }
    }
}

