/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.Backup;
import com.google.cloud.datastore.core.rep.BackupRef;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import java.time.Instant;
import javax.annotation.Nullable;

final class AutoValue_Backup
extends Backup {
    private final BackupRef ref;
    private final DatabaseRef databaseRef;
    private final Instant createTime;
    private final Instant expireTime;
    private final Backup.State state;
    private final Backup.Stats stats;
    private final String metadataBlobPath;
    private final String etag;

    private AutoValue_Backup(BackupRef ref, DatabaseRef databaseRef, Instant createTime, Instant expireTime, Backup.State state, @Nullable Backup.Stats stats, @Nullable String metadataBlobPath, String etag) {
        this.ref = ref;
        this.databaseRef = databaseRef;
        this.createTime = createTime;
        this.expireTime = expireTime;
        this.state = state;
        this.stats = stats;
        this.metadataBlobPath = metadataBlobPath;
        this.etag = etag;
    }

    @Override
    public BackupRef ref() {
        return this.ref;
    }

    @Override
    public DatabaseRef databaseRef() {
        return this.databaseRef;
    }

    @Override
    public Instant createTime() {
        return this.createTime;
    }

    @Override
    public Instant expireTime() {
        return this.expireTime;
    }

    @Override
    public Backup.State state() {
        return this.state;
    }

    @Override
    @Nullable
    public Backup.Stats stats() {
        return this.stats;
    }

    @Override
    @Nullable
    public String metadataBlobPath() {
        return this.metadataBlobPath;
    }

    @Override
    public String etag() {
        return this.etag;
    }

    public String toString() {
        String string = String.valueOf(this.ref);
        String string2 = String.valueOf(this.databaseRef);
        String string3 = String.valueOf(this.createTime);
        String string4 = String.valueOf(this.expireTime);
        String string5 = String.valueOf((Object)this.state);
        String string6 = String.valueOf(this.stats);
        String string7 = this.metadataBlobPath;
        String string8 = this.etag;
        return new StringBuilder(94 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Backup{ref=").append(string).append(", databaseRef=").append(string2).append(", createTime=").append(string3).append(", expireTime=").append(string4).append(", state=").append(string5).append(", stats=").append(string6).append(", metadataBlobPath=").append(string7).append(", etag=").append(string8).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Backup) {
            Backup that = (Backup)o;
            return this.ref.equals(that.ref()) && this.databaseRef.equals(that.databaseRef()) && this.createTime.equals(that.createTime()) && this.expireTime.equals(that.expireTime()) && this.state.equals((Object)that.state()) && (this.stats == null ? that.stats() == null : this.stats.equals(that.stats())) && (this.metadataBlobPath == null ? that.metadataBlobPath() == null : this.metadataBlobPath.equals(that.metadataBlobPath())) && this.etag.equals(that.etag());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.ref.hashCode();
        h$ *= 1000003;
        h$ ^= this.databaseRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.createTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.expireTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.state.hashCode();
        h$ *= 1000003;
        h$ ^= this.stats == null ? 0 : this.stats.hashCode();
        h$ *= 1000003;
        h$ ^= this.metadataBlobPath == null ? 0 : this.metadataBlobPath.hashCode();
        h$ *= 1000003;
        return h$ ^= this.etag.hashCode();
    }

    static final class Builder
    extends Backup.Builder {
        private BackupRef ref;
        private DatabaseRef databaseRef;
        private Instant createTime;
        private Instant expireTime;
        private Backup.State state;
        private Backup.Stats stats;
        private String metadataBlobPath;
        private String etag;

        Builder() {
        }

        @Override
        public Backup.Builder ref(BackupRef ref) {
            if (ref == null) {
                throw new NullPointerException("Null ref");
            }
            this.ref = ref;
            return this;
        }

        @Override
        public Backup.Builder databaseRef(DatabaseRef databaseRef) {
            if (databaseRef == null) {
                throw new NullPointerException("Null databaseRef");
            }
            this.databaseRef = databaseRef;
            return this;
        }

        @Override
        public Backup.Builder createTime(Instant createTime) {
            if (createTime == null) {
                throw new NullPointerException("Null createTime");
            }
            this.createTime = createTime;
            return this;
        }

        @Override
        public Backup.Builder expireTime(Instant expireTime) {
            if (expireTime == null) {
                throw new NullPointerException("Null expireTime");
            }
            this.expireTime = expireTime;
            return this;
        }

        @Override
        public Backup.Builder state(Backup.State state) {
            if (state == null) {
                throw new NullPointerException("Null state");
            }
            this.state = state;
            return this;
        }

        @Override
        public Backup.Builder stats(@Nullable Backup.Stats stats) {
            this.stats = stats;
            return this;
        }

        @Override
        public Backup.Builder metadataBlobPath(@Nullable String metadataBlobPath) {
            this.metadataBlobPath = metadataBlobPath;
            return this;
        }

        @Override
        public Backup.Builder etag(String etag) {
            if (etag == null) {
                throw new NullPointerException("Null etag");
            }
            this.etag = etag;
            return this;
        }

        @Override
        public Backup build() {
            String missing = "";
            if (this.ref == null) {
                missing = String.valueOf(missing).concat(" ref");
            }
            if (this.databaseRef == null) {
                missing = String.valueOf(missing).concat(" databaseRef");
            }
            if (this.createTime == null) {
                missing = String.valueOf(missing).concat(" createTime");
            }
            if (this.expireTime == null) {
                missing = String.valueOf(missing).concat(" expireTime");
            }
            if (this.state == null) {
                missing = String.valueOf(missing).concat(" state");
            }
            if (this.etag == null) {
                missing = String.valueOf(missing).concat(" etag");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_Backup(this.ref, this.databaseRef, this.createTime, this.expireTime, this.state, this.stats, this.metadataBlobPath, this.etag);
        }
    }
}

