/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.BackupBlob;
import com.google.cloud.datastore.core.rep.BackupBlobRef;
import com.google.cloud.datastore.core.rep.EntityRef;

final class AutoValue_BackupBlob
extends BackupBlob {
    private final BackupBlobRef ref;
    private final String blobPath;
    private final EntityRef startKey;
    private final EntityRef endKey;

    private AutoValue_BackupBlob(BackupBlobRef ref, String blobPath, EntityRef startKey, EntityRef endKey) {
        this.ref = ref;
        this.blobPath = blobPath;
        this.startKey = startKey;
        this.endKey = endKey;
    }

    @Override
    public BackupBlobRef ref() {
        return this.ref;
    }

    @Override
    public String blobPath() {
        return this.blobPath;
    }

    @Override
    public EntityRef startKey() {
        return this.startKey;
    }

    @Override
    public EntityRef endKey() {
        return this.endKey;
    }

    public String toString() {
        String string = String.valueOf(this.ref);
        String string2 = this.blobPath;
        String string3 = String.valueOf(this.startKey);
        String string4 = String.valueOf(this.endKey);
        return new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append("BackupBlob{ref=").append(string).append(", blobPath=").append(string2).append(", startKey=").append(string3).append(", endKey=").append(string4).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackupBlob) {
            BackupBlob that = (BackupBlob)o;
            return this.ref.equals(that.ref()) && this.blobPath.equals(that.blobPath()) && this.startKey.equals(that.startKey()) && this.endKey.equals(that.endKey());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.ref.hashCode();
        h$ *= 1000003;
        h$ ^= this.blobPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.startKey.hashCode();
        h$ *= 1000003;
        return h$ ^= this.endKey.hashCode();
    }

    static final class Builder
    extends BackupBlob.Builder {
        private BackupBlobRef ref;
        private String blobPath;
        private EntityRef startKey;
        private EntityRef endKey;

        Builder() {
        }

        @Override
        public BackupBlob.Builder ref(BackupBlobRef ref) {
            if (ref == null) {
                throw new NullPointerException("Null ref");
            }
            this.ref = ref;
            return this;
        }

        @Override
        public BackupBlob.Builder blobPath(String blobPath) {
            if (blobPath == null) {
                throw new NullPointerException("Null blobPath");
            }
            this.blobPath = blobPath;
            return this;
        }

        @Override
        public BackupBlob.Builder startKey(EntityRef startKey) {
            if (startKey == null) {
                throw new NullPointerException("Null startKey");
            }
            this.startKey = startKey;
            return this;
        }

        @Override
        public BackupBlob.Builder endKey(EntityRef endKey) {
            if (endKey == null) {
                throw new NullPointerException("Null endKey");
            }
            this.endKey = endKey;
            return this;
        }

        @Override
        public BackupBlob build() {
            String missing = "";
            if (this.ref == null) {
                missing = String.valueOf(missing).concat(" ref");
            }
            if (this.blobPath == null) {
                missing = String.valueOf(missing).concat(" blobPath");
            }
            if (this.startKey == null) {
                missing = String.valueOf(missing).concat(" startKey");
            }
            if (this.endKey == null) {
                missing = String.valueOf(missing).concat(" endKey");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_BackupBlob(this.ref, this.blobPath, this.startKey, this.endKey);
        }
    }
}

