/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.BackupSchedule;
import com.google.cloud.datastore.core.rep.BackupScheduleRef;
import java.time.Duration;
import java.time.Instant;

final class AutoValue_BackupSchedule
extends BackupSchedule {
    private final BackupScheduleRef ref;
    private final String description;
    private final Instant createTime;
    private final Duration duration;
    private final BackupSchedule.Frequency frequency;

    private AutoValue_BackupSchedule(BackupScheduleRef ref, String description, Instant createTime, Duration duration, BackupSchedule.Frequency frequency) {
        this.ref = ref;
        this.description = description;
        this.createTime = createTime;
        this.duration = duration;
        this.frequency = frequency;
    }

    @Override
    public BackupScheduleRef ref() {
        return this.ref;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Instant createTime() {
        return this.createTime;
    }

    @Override
    public Duration duration() {
        return this.duration;
    }

    @Override
    public BackupSchedule.Frequency frequency() {
        return this.frequency;
    }

    public String toString() {
        String string = String.valueOf(this.ref);
        String string2 = this.description;
        String string3 = String.valueOf(this.createTime);
        String string4 = String.valueOf(this.duration);
        String string5 = String.valueOf(this.frequency);
        return new StringBuilder(70 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("BackupSchedule{ref=").append(string).append(", description=").append(string2).append(", createTime=").append(string3).append(", duration=").append(string4).append(", frequency=").append(string5).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BackupSchedule) {
            BackupSchedule that = (BackupSchedule)o;
            return this.ref.equals(that.ref()) && this.description.equals(that.description()) && this.createTime.equals(that.createTime()) && this.duration.equals(that.duration()) && this.frequency.equals(that.frequency());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.ref.hashCode();
        h$ *= 1000003;
        h$ ^= this.description.hashCode();
        h$ *= 1000003;
        h$ ^= this.createTime.hashCode();
        h$ *= 1000003;
        h$ ^= this.duration.hashCode();
        h$ *= 1000003;
        return h$ ^= this.frequency.hashCode();
    }

    static final class Builder
    extends BackupSchedule.Builder {
        private BackupScheduleRef ref;
        private String description;
        private Instant createTime;
        private Duration duration;
        private BackupSchedule.Frequency frequency;

        Builder() {
        }

        @Override
        public BackupSchedule.Builder ref(BackupScheduleRef ref) {
            if (ref == null) {
                throw new NullPointerException("Null ref");
            }
            this.ref = ref;
            return this;
        }

        @Override
        public BackupSchedule.Builder description(String description) {
            if (description == null) {
                throw new NullPointerException("Null description");
            }
            this.description = description;
            return this;
        }

        @Override
        public BackupSchedule.Builder createTime(Instant createTime) {
            if (createTime == null) {
                throw new NullPointerException("Null createTime");
            }
            this.createTime = createTime;
            return this;
        }

        @Override
        public BackupSchedule.Builder duration(Duration duration) {
            if (duration == null) {
                throw new NullPointerException("Null duration");
            }
            this.duration = duration;
            return this;
        }

        @Override
        public BackupSchedule.Builder frequency(BackupSchedule.Frequency frequency) {
            if (frequency == null) {
                throw new NullPointerException("Null frequency");
            }
            this.frequency = frequency;
            return this;
        }

        @Override
        public BackupSchedule build() {
            String missing = "";
            if (this.ref == null) {
                missing = String.valueOf(missing).concat(" ref");
            }
            if (this.description == null) {
                missing = String.valueOf(missing).concat(" description");
            }
            if (this.createTime == null) {
                missing = String.valueOf(missing).concat(" createTime");
            }
            if (this.duration == null) {
                missing = String.valueOf(missing).concat(" duration");
            }
            if (this.frequency == null) {
                missing = String.valueOf(missing).concat(" frequency");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_BackupSchedule(this.ref, this.description, this.createTime, this.duration, this.frequency);
        }
    }
}

