/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseIndexesWithValidityWindow;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;

@AutoValue
public abstract class DatabaseIndexesWithValidityWindow {
    public abstract DatabaseIndexGroup databaseIndexGroup();

    public abstract Long readTimeInMicros();

    public abstract Long expirationInMicros();

    public static DatabaseIndexesWithValidityWindow create(DatabaseIndexGroup databaseIndexGroup, Long readTimeInMicros, Long expirationInMicros) {
        return new AutoValue_DatabaseIndexesWithValidityWindow(databaseIndexGroup, readTimeInMicros, expirationInMicros);
    }

    public static DatabaseIndexesWithValidityWindow of(DatabaseIndexGroup databaseIndexGroup) {
        return DatabaseIndexesWithValidityWindow.create(databaseIndexGroup, 0L, Long.MAX_VALUE);
    }

    public boolean isValidForTimestamp(long timeInMicros) {
        return this.readTimeInMicros() <= timeInMicros && timeInMicros <= this.expirationInMicros();
    }
}

