/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;

public final class EntitySize {
    private static final int SIZE_INT64 = 8;
    private static final int SIZE_BOOLEAN = 1;
    private static final int SIZE_DOUBLE = 8;
    private static final int SIZE_TIMESTAMP_NANOS = 8;
    private static final int SIZE_POINT = 16;
    private static final int SIZE_NULL = 1;
    private static final int SIZE_KEY_ID = 8;
    private static final int BASE_SIZE_KEY = 16;
    private static final int BASE_SIZE_ENTITY = 32;
    public static final int BASE_SIZE_INDEX_ENTRY = 32;
    public static final String PROPERTY_NAME_EMAIL = "email";
    public static final String PROPERTY_NAME_AUTH_DOMAIN = "auth_domain";
    public static final String PROPERTY_NAME_FEDERATED_IDENTITY = "federated_identity";
    public static final String PROPERTY_NAME_FEDERATED_PROVIDER = "federated_provider";

    public static int entitySize(OnestoreEntity.EntityProto entity) {
        int size = EntitySize.keySize(entity.getKey());
        for (OnestoreEntity.Property property : entity.propertys()) {
            size += EntitySize.propertySize(property);
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            size += EntitySize.propertySize(property);
        }
        return size + 32;
    }

    public static int entitySize(Entity entity) {
        return 32 + EntitySize.entityRefSize(entity.ref()) + EntitySize.optionalMapSize(entity.propertyMap());
    }

    public static int keySize(OnestoreEntity.Reference key) {
        return EntitySize.baseKeySize(key) + EntitySize.pathSize(key.getPath());
    }

    public static int keyValueSize(OnestoreEntity.PropertyValue.ReferenceValue key) {
        return EntitySize.baseKeyValueSize(key) + EntitySize.pathSize(key.pathElements());
    }

    private static int baseKeySize(OnestoreEntity.Reference key) {
        return 16 + EntitySize.optionalStringSize(key.getNameSpaceAsBytes());
    }

    private static int baseKeyValueSize(OnestoreEntity.PropertyValue.ReferenceValue key) {
        return 16 + EntitySize.optionalStringSize(key.getNameSpaceAsBytes());
    }

    private static int pathSize(List<OnestoreEntity.PropertyValue.ReferenceValuePathElement> path) {
        int size = 0;
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : path) {
            size += EntitySize.stringSize(element.getTypeAsBytes());
            if (element.hasName()) {
                size += EntitySize.stringSize(element.getNameAsBytes());
                continue;
            }
            size += 8;
        }
        return size;
    }

    private static int pathSize(OnestoreEntity.Path path) {
        int size = 0;
        for (OnestoreEntity.Path.Element element : path.elements()) {
            size += EntitySize.stringSize(element.getTypeAsBytes());
            if (element.hasName()) {
                size += EntitySize.stringSize(element.getNameAsBytes());
                continue;
            }
            size += 8;
        }
        return size;
    }

    private static int pathSize(EntityRef ref) {
        int size = 0;
        for (EntityRef.PathElement element : ref.pathElements()) {
            size += EntitySize.stringSize(element.collectionId());
            if (element.resourceId() == null) {
                size += 8;
                continue;
            }
            switch (element.resourceId().typeOf()) {
                case STRING: {
                    size += EntitySize.stringSize(element.resourceId().string());
                    break;
                }
                case NUMBER: {
                    size += 8;
                }
            }
        }
        return size;
    }

    public static int propertySize(OnestoreEntity.Property property) {
        if (EntitySize.excludeProperty(PropertyName.create(property.getName()))) {
            return 0;
        }
        return EntitySize.actualPropertySize(property);
    }

    public static int actualPropertySize(OnestoreEntity.Property property) {
        return EntitySize.stringSize(property.getNameAsBytes()) + EntitySize.propertyValueSize(property.getValue(), property.getMeaningEnum());
    }

    public static int propertyValueSize(OnestoreEntity.PropertyValue value, OnestoreEntity.Property.Meaning meaning) {
        if (value.hasInt64Value()) {
            return 8;
        }
        if (value.hasStringValue()) {
            switch (meaning) {
                case BLOB: {
                    return value.getStringValueAsBytes().length;
                }
                case ENTITY_PROTO: {
                    OnestoreEntity.EntityProto embedded = new OnestoreEntity.EntityProto();
                    if (embedded.parseFrom(value.getStringValueAsBytes())) {
                        return EntitySize.entitySize(embedded) + embedded.getUnknownFields().getSerializedSize();
                    }
                    return value.getStringValueAsBytes().length;
                }
            }
            return EntitySize.stringSize(value.getStringValueAsBytes());
        }
        if (value.hasBooleanValue()) {
            return 1;
        }
        if (value.hasDoubleValue()) {
            return 8;
        }
        if (value.hasPointValue()) {
            return 16;
        }
        if (value.hasUserValue()) {
            OnestoreEntity.PropertyValue.UserValue userValue = value.getUserValue();
            int size = EntitySize.stringSize(PROPERTY_NAME_EMAIL) + EntitySize.stringSize(userValue.getEmailAsBytes()) + EntitySize.stringSize(PROPERTY_NAME_AUTH_DOMAIN) + EntitySize.stringSize(userValue.getAuthDomainAsBytes());
            if (userValue.hasFederatedIdentity()) {
                size += EntitySize.stringSize(PROPERTY_NAME_FEDERATED_IDENTITY) + EntitySize.stringSize(userValue.getFederatedIdentityAsBytes());
            }
            if (userValue.hasFederatedProvider()) {
                size += EntitySize.stringSize(PROPERTY_NAME_FEDERATED_PROVIDER) + EntitySize.stringSize(userValue.getFederatedProviderAsBytes());
            }
            return size;
        }
        if (value.hasReferenceValue()) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = value.getReferenceValue();
            int size = 16 + EntitySize.optionalStringSize(refValue.getNameSpaceAsBytes());
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                size += EntitySize.stringSize(element.getTypeAsBytes());
                if (element.hasName()) {
                    size += EntitySize.stringSize(element.getNameAsBytes());
                    continue;
                }
                size += 8;
            }
            return size;
        }
        return 1;
    }

    public static int stringSize(String s) {
        return Utf8.encodedLength((CharSequence)s) + 1;
    }

    private static int stringSize(byte[] utf8Bytes) {
        return utf8Bytes.length + 1;
    }

    private static int optionalStringSize(String s) {
        return s.isEmpty() ? 0 : EntitySize.stringSize(s);
    }

    private static int optionalStringSize(byte[] utf8Bytes) {
        return utf8Bytes.length == 0 ? 0 : EntitySize.stringSize(utf8Bytes);
    }

    public static int propertyPathSize(PropertyPath propertyPath) {
        int sum = 0;
        while (propertyPath != null && !(propertyPath.segment() instanceof PropertyPathSegment.AllArrayElements)) {
            sum += EntitySize.stringSize(propertyPath.memberName());
            propertyPath = propertyPath.next();
        }
        return sum;
    }

    private static int optionalMapSize(Map<String, Value> map) {
        int size = 0;
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            if (EntitySize.excludeProperty(PropertyName.create(entry.getKey()))) continue;
            size += EntitySize.stringSize(entry.getKey()) + EntitySize.valueSize(entry.getValue());
        }
        return size;
    }

    private static int mapSize(Map<String, Value> map) {
        if (map.isEmpty()) {
            return 1;
        }
        return EntitySize.optionalMapSize(map);
    }

    private static int arraySize(List<Value> array) {
        if (array.isEmpty()) {
            return 1;
        }
        int size = 0;
        for (Value value : array) {
            size += EntitySize.valueSize(value);
        }
        return size;
    }

    public static int partitionRefSize(PartitionRef ref) {
        return 16 + EntitySize.optionalStringSize(ref.namespace());
    }

    public static int entityRefSize(EntityRef ref) {
        return EntitySize.partitionRefSize(ref.partitionRef()) + EntitySize.pathSize(ref);
    }

    public static int valueSize(Value value) {
        int size = value.unknownFieldSet() == null ? 0 : value.unknownFieldSet().getSerializedSize();
        switch (value.type()) {
            case NULL: {
                ++size;
                break;
            }
            case BOOLEAN: {
                ++size;
                break;
            }
            case DOUBLE: {
                size += 8;
                break;
            }
            case TIMESTAMP: {
                size += 8;
                break;
            }
            case STRING: {
                size += EntitySize.stringSize(value.asString());
                break;
            }
            case BYTES: {
                size += value.asBytes().size();
                break;
            }
            case GEO_POINT: {
                size += 16;
                break;
            }
            case RESOURCE_REF: {
                size += EntitySize.resourceRefSize(value.asResourceRef());
                break;
            }
            case ENTITY_REF: {
                size += EntitySize.resourceRefSize(value.asEntityRef());
                break;
            }
            case LONG: 
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                size += 8;
                break;
            }
            case LEGACY_USER: {
                size += EntitySize.legacyUserSize(value.asLegacyUser());
                break;
            }
            case ENTITY: {
                size += EntitySize.entitySize(value.asEntity());
                break;
            }
            case ARRAY: {
                size += EntitySize.arraySize(value.asArray());
                break;
            }
            case MAP: {
                size += EntitySize.mapSize(value.asMap());
                break;
            }
            default: {
                String string = String.valueOf((Object)value.type());
                throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("unknown value type ").append(string).toString());
            }
        }
        return size;
    }

    private static int resourceRefSize(ResourceRef ref) {
        if (ref instanceof EntityRef) {
            return EntitySize.entityRefSize((EntityRef)ref);
        }
        if (ref instanceof PartitionRef) {
            return EntitySize.entityRefSize(EntityRef.createEmpty((PartitionRef)ref));
        }
        if (ref instanceof DatabaseRef) {
            return 16;
        }
        if (ref instanceof OtherServiceResourceRef) {
            OtherServiceResourceRef otherRef = (OtherServiceResourceRef)ref;
            int size = EntitySize.stringSize(otherRef.service());
            for (String id : otherRef.ids()) {
                size += EntitySize.stringSize(id);
            }
            return size;
        }
        String string = String.valueOf(ref);
        throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string).length()).append("Cannot calculate size of ResourceRef ").append(string).toString());
    }

    public static int legacyUserSize(Value.LegacyUser user) {
        int size = EntitySize.stringSize(PROPERTY_NAME_EMAIL) + EntitySize.stringSize(user.email()) + EntitySize.stringSize(PROPERTY_NAME_AUTH_DOMAIN) + EntitySize.stringSize(user.authDomain());
        if (user.federatedIdentity() != null) {
            size += EntitySize.stringSize(PROPERTY_NAME_FEDERATED_IDENTITY) + EntitySize.stringSize(user.federatedIdentity());
        }
        if (user.federatedProvider() != null) {
            size += EntitySize.stringSize(PROPERTY_NAME_FEDERATED_PROVIDER) + EntitySize.stringSize(user.federatedProvider());
        }
        return size;
    }

    private static boolean excludeProperty(PropertyName propertyName) {
        return propertyName.special().isConfigDependent();
    }
}

