/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.CompositeIndex;

public enum WorkflowState {
    CREATED,
    ENABLING,
    SERVING,
    NON_SERVING,
    DISABLING,
    DELETED;


    public boolean up() {
        return this == CREATED || this == ENABLING || this == SERVING;
    }

    public boolean write() {
        return this == ENABLING || this == SERVING || this == NON_SERVING;
    }

    public boolean initializing() {
        return this == CREATED || this == NON_SERVING;
    }

    public boolean finalizing() {
        return this == ENABLING || this == DISABLING;
    }

    public boolean terminal() {
        return this == SERVING || this == DELETED;
    }

    @Deprecated
    public boolean adjacent(WorkflowState other) {
        return this.write() == other.write() || !this.terminal() && !other.terminal();
    }

    @Deprecated
    public CompositeIndex.State toIndexStateLossy() {
        switch (this) {
            case ENABLING: 
            case NON_SERVING: {
                return CompositeIndex.State.ENABLING;
            }
            case SERVING: {
                return CompositeIndex.State.ENABLED;
            }
            case DISABLING: 
            case CREATED: {
                return CompositeIndex.State.DELETING;
            }
            case DELETED: {
                return CompositeIndex.State.DISABLED;
            }
        }
        throw new AssertionError();
    }
}

