/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.protobuf.Duration;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.util.JavaTimeConversions;
import com.google.appengine.repackaged.com.google.type.DayOfWeek;
import com.google.appengine.repackaged.com.google.type.TimeOfDay;
import com.google.cloud.datastore.core.rep.BackupSchedule;
import com.google.cloud.datastore.core.rep.converter.BackupScheduleRefConverter;
import com.google.cloud.datastore.core.rep.proto.BackupSchedule;
import java.time.Instant;
import java.time.LocalTime;

public final class BackupScheduleConverter {
    private BackupScheduleConverter() {
    }

    private static BackupSchedule.Frequency toProto(BackupSchedule.Frequency frequency) {
        switch (frequency.typeOf()) {
            case DAILY: {
                BackupSchedule.Frequency.Daily daily = BackupSchedule.Frequency.Daily.newBuilder().setTime(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toProtoTimeOfDay((LocalTime)frequency.daily().utcTime())).build();
                return BackupSchedule.Frequency.newBuilder().setDaily(daily).build();
            }
            case WEEKLY: {
                BackupSchedule.Frequency.Weekly weekly = BackupSchedule.Frequency.Weekly.newBuilder().setTime(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toProtoTimeOfDay((LocalTime)frequency.weekly().utcTime())).setDay(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toProtoDayOfWeek((java.time.DayOfWeek)frequency.weekly().dayOfWeek())).build();
                return BackupSchedule.Frequency.newBuilder().setWeekly(weekly).build();
            }
            case MONTHLY: {
                BackupSchedule.Frequency.Monthly monthly = BackupSchedule.Frequency.Monthly.newBuilder().setTime(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toProtoTimeOfDay((LocalTime)frequency.monthly().utcTime())).setDay(frequency.monthly().day()).build();
                return BackupSchedule.Frequency.newBuilder().setMonthly(monthly).build();
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    public static com.google.cloud.datastore.core.rep.proto.BackupSchedule toProto(BackupSchedule backupSchedule) {
        return com.google.cloud.datastore.core.rep.proto.BackupSchedule.newBuilder().setRef(BackupScheduleRefConverter.toProto(backupSchedule.ref())).setDescription(backupSchedule.description()).setCreateTime(JavaTimeConversions.toProtoTimestamp((Instant)backupSchedule.createTime())).setDuration(JavaTimeConversions.toProtoDuration((java.time.Duration)backupSchedule.duration())).setFrequency(BackupScheduleConverter.toProto(backupSchedule.frequency())).build();
    }

    public static BackupSchedule.Frequency toRep(BackupSchedule.Frequency proto) {
        switch (proto.getFrequencyTypeCase()) {
            case DAILY: {
                return BackupSchedule.Frequency.ofDaily(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toJavaLocalTime((TimeOfDay)proto.getDaily().getTime()));
            }
            case WEEKLY: {
                return BackupSchedule.Frequency.ofWeekly(com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toJavaDayOfWeek((DayOfWeek)proto.getWeekly().getDay()), com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toJavaLocalTime((TimeOfDay)proto.getWeekly().getTime()));
            }
            case MONTHLY: {
                return BackupSchedule.Frequency.ofMonthly(proto.getMonthly().getDay(), com.google.appengine.repackaged.com.google.type.util.JavaTimeConversions.toJavaLocalTime((TimeOfDay)proto.getMonthly().getTime()));
            }
            case FREQUENCYTYPE_NOT_SET: {
                throw new IllegalStateException("Unset frequency type.");
            }
        }
        throw new AssertionError((Object)"Unreachable codes.");
    }

    public static BackupSchedule toRep(com.google.cloud.datastore.core.rep.proto.BackupSchedule proto) {
        return BackupSchedule.builder().ref(BackupScheduleRefConverter.toRep(proto.getRef())).description(proto.getDescription()).createTime(JavaTimeConversions.toJavaInstant((Timestamp)proto.getCreateTime())).duration(JavaTimeConversions.toJavaDuration((Duration)proto.getDuration())).frequency(BackupScheduleConverter.toRep(proto.getFrequency())).build();
    }
}

