/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.names.ProjectIds;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.EntitySize;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.validator.BaseDatastoreValidator;
import com.google.cloud.datastore.core.rep.validator.DatabaseRefValidator;
import com.google.cloud.datastore.core.rep.validator.ValidationConstraint;
import com.google.cloud.datastore.core.rep.validator.ValidationUtils;
import com.google.cloud.datastore.logs.ProblemCode;
import java.util.HashSet;
import java.util.Map;

public class EntityValidator
extends BaseDatastoreValidator {
    private static final ValidationUtils VALIDATION_UTILS = ValidationUtils.INSTANCE;

    public EntityValidator(Config.DatastoreConfig config) {
        super(config);
    }

    public void validateEntity(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, int maxDepthOverride, Entity entity) throws ValidationException {
        int maxDepth = maxDepthOverride != 0 ? maxDepthOverride : (this.config.getUseMaxArrayAndEntityValueDepth() ? this.config.getMaxArrayAndEntityValueDepth() : this.config.getMaxEntityValueDepth());
        this.validateEntity(constraint, suppressedFailures, maxDepth, entity, 0, 0);
    }

    private void validateEntity(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, int maxDepth, Entity entity, int prefixLength, int depth) throws ValidationException {
        EntityRef key = entity.ref();
        this.validateKey(constraint, suppressedFailures, key);
        constraint = constraint.withPartitionId(key.partitionRef().databaseRef().partitionId());
        this.validatePropertyMap(constraint, suppressedFailures, (Map<String, Value>)entity.propertyMap(), prefixLength, depth, maxDepth);
    }

    private void validatePropertyMap(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, Map<String, Value> properties, int prefixLength, int depth, int maxDepth) throws ValidationException {
        int indexedProperties = 0;
        for (Map.Entry<String, Value> property : properties.entrySet()) {
            this.validatePropertyName(constraint, property.getKey(), prefixLength, "");
            if (property.getValue().type() == Value.Type.ARRAY) {
                if (this.config.getUseMaxArrayAndEntityValueDepth() && !property.getValue().asArray().isEmpty()) {
                    ValidationException.validateAssertion(depth + 1 <= maxDepth, "At most %s nested array/entity values are supported.", maxDepth);
                }
                for (Value value : property.getValue().asArray()) {
                    if (value.isDatastoreIndexed()) {
                        ValidationException.validateAssertion(constraint.allowUnindexableValue() || EntityValidator.isIndexablePropertyMeaning(value.meaning()), "Property \"%s\" has a value meaning %s that cannot be indexed.", new Object[]{property.getKey(), value.meaning()});
                        ++indexedProperties;
                    }
                    this.validatePropertyValue(constraint, suppressedFailures, property.getKey(), value, prefixLength, this.config.getUseMaxArrayAndEntityValueDepth() ? depth + 1 : depth, maxDepth);
                }
                continue;
            }
            if (property.getValue().isDatastoreIndexed()) {
                ValidationException.validateAssertion(constraint.allowUnindexableValue() || EntityValidator.isIndexablePropertyMeaning(property.getValue().meaning()), "Property \"%s\" has a value meaning %s that cannot be indexed.", new Object[]{property.getKey(), property.getValue().meaning()});
                ++indexedProperties;
            }
            this.validatePropertyValue(constraint, suppressedFailures, property.getKey(), property.getValue(), prefixLength, depth, maxDepth);
        }
        ValidationException.validateAssertion(indexedProperties <= this.config.getMaxIndexedProperties(), "Too many indexed properties", new Object[0]);
    }

    private void validatePropertyValue(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, String name, Value value, int prefixLength, int depth, int maxDepth) throws ValidationException {
        switch (value.type()) {
            case ENTITY_REF: {
                this.validateKey(constraint.withContext(ValidationConstraint.Context.IN_KEY_VALUE), suppressedFailures, value.asEntityRef());
                break;
            }
            case GEO_POINT: {
                if (value.meaning().equals((Object)Value.Meaning.GEO_POINT_WITHOUT_APP_ENG_V3_MEANING)) {
                    if (!DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, constraint.configOverrides()).getEnableAppEngV3ValidatorValidateValueMeaningMatchesType()) {
                        if (DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, constraint.configOverrides()).getEnableValidateGeoPointSameMeaning()) {
                            suppressedFailures.add(ProblemCode.GEO_POINT_HAS_UNEXPECTED_MEANING);
                        }
                    } else {
                        ValidationException.validateAssertionIf(false, ProblemCode.GEO_POINT_HAS_UNEXPECTED_MEANING, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, constraint.configOverrides()).getEnableValidateGeoPointSameMeaning(), suppressedFailures, "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
                    }
                }
                try {
                    this.validateGeoPoint(value.asGeoPoint().getLatitude(), value.asGeoPoint().getLongitude());
                }
                catch (ValidationException e) {
                    if (constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateGeoPoint()) {
                        throw e;
                    }
                    suppressedFailures.add(ProblemCode.INVALID_GEO_POINT);
                }
                break;
            }
            case ENTITY: 
            case MAP: {
                this.validateEntityOrMapValue(constraint, suppressedFailures, name, value, prefixLength + name.length() + 1, depth + 1, maxDepth);
                break;
            }
            case STRING: 
            case BYTES: {
                this.validateStringOrBytesLength(name, value, suppressedFailures);
                break;
            }
            case ARRAY: {
                if (value.equals(Value.EMPTY_ARRAY)) {
                    throw new ValidationException("An empty list must have only one property", ProblemCode.PROPERTY_WITH_INVALID_MULTIPLE_FIELD);
                }
                throw new ValidationException("Invalid array inside an array.");
            }
        }
        if (!constraint.allowIndexOnlyMeaning()) {
            ValidationException.validateAssertion(value.meaning() != Value.Meaning.OMITTED_BY_MEGASTORE_INDEX, "Projection property cannot be used.", new Object[0]);
        }
    }

    private void validateEntityOrMapValue(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, String name, Value value, int newPrefixLength, int newDepth, int maxDepth) throws ValidationException {
        if (!value.isDatastoreIndexed()) {
            constraint = constraint.withContext(ValidationConstraint.Context.IN_UNINDEXED_VALUE);
        }
        try {
            ValidationException.validateAssertion(newDepth <= maxDepth, ProblemCode.VALUE_NESTED_TOO_DEEPLY, this.config.getUseMaxArrayAndEntityValueDepth() ? "At most %s nested array/entity values are supported." : "At most %s nested entity values are supported.", maxDepth);
            if (value.type().equals((Object)Value.Type.ENTITY)) {
                this.validateEntity(constraint.withContext(ValidationConstraint.Context.IN_ENTITY_VALUE), suppressedFailures, maxDepth, value.asEntity(), newPrefixLength, newDepth);
            } else {
                this.validatePropertyMap(constraint, suppressedFailures, (Map<String, Value>)value.asMap(), newPrefixLength, newDepth, maxDepth);
            }
        }
        catch (ValidationException exception) {
            if (value.isDatastoreIndexed()) {
                throw exception;
            }
            if (!DatastoreCustomizableConfigUtils.getEnableAppEngV3ValidateUnindexedValueEntityProto(this.config, constraint.configOverrides())) {
                suppressedFailures.add(ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE);
            }
            throw new ValidationException(new StringBuilder(44 + String.valueOf(name).length()).append("Property ").append(name).append(" contains an invalid nested entity.").toString(), ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE, exception);
        }
    }

    private void validateStringOrBytesLength(String name, Value value, SuppressedValidationFailures suppressedFailures) throws ValidationException {
        int maxLength;
        String desc = new StringBuilder(20 + String.valueOf(name).length()).append("value of property \"").append(name).append("\"").toString();
        if (value.meaning() == Value.Meaning.INVALID_ENTITY_PROTO_BYTES) {
            suppressedFailures.add(ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE);
        }
        if (value.meaning() == Value.Meaning.ATOM_LINK) {
            maxLength = this.config.getMaxAtomLinkBytes();
            desc = "Url value";
        } else {
            maxLength = value.isDatastoreIndexed() ? this.config.getMaxIndexedValueBytes() : this.config.getMaxRawPropertyBytes();
        }
        if (value.type().equals((Object)Value.Type.STRING)) {
            this.validateLength(value.asString(), maxLength, desc);
        } else {
            this.validateLength(value.asBytes().size(), maxLength, desc);
        }
    }

    private static boolean isIndexablePropertyMeaning(Value.Meaning meaning) {
        return meaning != Value.Meaning.TEXT;
    }

    public void validateKey(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, EntityRef entityRef) throws ValidationException {
        int keySizeLimit;
        boolean lastElementComplete;
        this.validatePartitionRef(constraint, suppressedFailures, entityRef.partitionRef());
        EntityRef.Path path = entityRef.path();
        ValidationException.validateAssertion(!path.isEmpty(), "Key path is empty.", new Object[0]);
        ValidationException.validateAssertion(path.size() <= 100, "Key path is too long. Cannot exceed %d elements.", 100);
        for (int i = 0; i < path.size(); ++i) {
            EntityRef.PathElement element = (EntityRef.PathElement)path.elements().get(i);
            this.validateKind(constraint, suppressedFailures, element.collectionId(), "key path element kind");
            EntityRef.ResourceId resourceId = element.resourceId();
            if (resourceId != null) {
                if (!resourceId.typeOfString()) continue;
                this.validateKeyPathName(constraint, suppressedFailures, resourceId.string());
                continue;
            }
            ValidationException.validateAssertion(i == path.size() - 1, "Key path element must not be incomplete: %s", VALIDATION_UTILS.toPathString(path));
        }
        boolean bl = lastElementComplete = entityRef.lastPathElement().resourceId() != null;
        if (!constraint.allowCompleteKey()) {
            ValidationException.validateAssertion(!lastElementComplete, "Key path element must not be complete: %s", VALIDATION_UTILS.toPathString(path));
        }
        if (!constraint.allowIncompleteKey(this.config.getAllowIncompleteKeyPathsInQueryFilters())) {
            ValidationException.validateAssertion(lastElementComplete, ProblemCode.INCOMPLETE_KEY_PATHS_IN_QUERY_FILTERS, "Key path element must not be incomplete: %s", VALIDATION_UTILS.toPathString(path));
        }
        if ((keySizeLimit = constraint.getCustomizableConfig(this.config).getMaxEntityKeySizeBytes()) > 0) {
            this.validateLength(EntitySize.entityRefSize(entityRef), keySizeLimit, ProblemCode.KEY_SIZE_OVER_LIMIT, "entity key");
        }
    }

    void validatePartitionRef(ValidationConstraint constraint, SuppressedValidationFailures suppressedFailures, PartitionRef partitionRef) throws ValidationException {
        this.validateDatabaseRef(constraint, partitionRef.databaseRef());
        this.validateNamespace(constraint, partitionRef.namespace());
        String constraintPartitionId = constraint.partitionId();
        String keyPartitionId = partitionRef.databaseRef().partitionId();
        ValidationException.validateAssertionIf(constraintPartitionId == null || constraintPartitionId.equals(keyPartitionId), ProblemCode.CROSS_PARTITION_ENTITY_REF, constraint.getCustomizableConfig(this.config).getEnableAppEngV3ValidateEntityRefIntraPartition(), suppressedFailures, "Entity key's app id's partition id '%s' does not match containing entity's '%s'.", keyPartitionId, constraintPartitionId);
    }

    void validateDatabaseRef(ValidationConstraint constraint, DatabaseRef databaseRef) throws ValidationException {
        ValidationException.validateAssertion(!databaseRef.rawProjectId().isEmpty(), "The app id is the empty string.", new Object[0]);
        ValidationException.validateAssertion(ProjectIds.isValidProjectId(databaseRef.rawProjectId()), "\"%s\" is an invalid app id.", databaseRef.rawProjectId());
        if (!this.config.getAllowDatabases()) {
            ValidationException.validateAssertion(databaseRef.databaseId().isEmpty(), ProblemCode.NO_DB_SUPPORT, "Database support is not enabled.", new Object[0]);
        }
        if (!databaseRef.databaseId().isEmpty()) {
            this.validateDatabase(constraint, databaseRef.databaseId());
        }
        if (!constraint.allowMetadataAccess()) {
            ValidationException.validateAssertion(!databaseRef.isMetadata(), "The project id %s is reserved.", databaseRef.projectId());
        }
        if (!constraint.allowReservedKey()) {
            this.validateStringNotReserved(databaseRef.projectId(), "app id");
        }
    }

    public void validateKeyInPartition(EntityRef value, PartitionRef expectedPartition, String desc) throws ValidationException {
        PartitionRef partitionRef = value.partitionRef();
        DatabaseRef dbName = partitionRef.databaseRef();
        DatabaseRefValidator.INSTANCE.validateDatabaseRefMatch(dbName, expectedPartition.databaseRef());
        String expectedNamespace = expectedPartition.namespace();
        ValidationException.validateAssertion(expectedNamespace.isEmpty() && partitionRef.namespace().isEmpty() || "__all__".equals(expectedNamespace) || partitionRef.namespace().equals(expectedNamespace), "The query namespace is '%s' but %s namespace is '%s'.", expectedNamespace, desc, partitionRef.namespace());
    }

    public void validateNoNameCollisionRelaxed(Entity entity) throws ValidationException {
        this.validateNoNameCollisionRelaxed(entity.propertyMap());
    }

    private void validateNoNameCollisionRelaxed(ImmutableMap<String, Value> propertyMap) throws ValidationException {
        HashSet<String> nestedNames = new HashSet<String>();
        HashSet<String> namePrefixes = new HashSet<String>();
        for (Map.Entry property : propertyMap.entrySet()) {
            int index;
            String name = (String)property.getKey();
            Value value = (Value)property.getValue();
            if (!value.isDatastoreIndexed()) continue;
            if (value.type() == Value.Type.MAP || value.type() == Value.Type.ENTITY) {
                nestedNames.add(name);
                ValidationException.validateAssertion(!namePrefixes.contains(name), ProblemCode.INDEXED_PROPERTY_NAME_COLLISION, "Entity has a nested entity property named '%s' as well as a property prefixed with '%s.', this results in name collision.", name, name);
            }
            String prefix = name;
            while ((index = prefix.lastIndexOf(46)) > 0) {
                ValidationException.validateAssertion(!nestedNames.contains(prefix = prefix.substring(0, index)), ProblemCode.INDEXED_PROPERTY_NAME_COLLISION, "Entity has a nested entity property named '%s' as well as a property prefixed with '%s.', this results in name collision.", prefix, prefix);
                if (namePrefixes.add(prefix)) continue;
            }
            if (value.type() == Value.Type.MAP) {
                this.validateNoNameCollisionRelaxed(value.asMap());
                continue;
            }
            if (value.type() != Value.Type.ENTITY) continue;
            this.validateNoNameCollisionRelaxed(value.asEntity().propertyMap());
        }
    }
}

