/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.errorprone.annotations.FormatMethod;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.type.LatLng;
import com.google.apphosting.datastore.shared.Config;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefToRepConverter;
import com.google.cloud.datastore.core.config.DatastoreCustomizableConfigUtils;
import com.google.cloud.datastore.core.config.proto1api.DatastoreCustomizableConfigPb;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.exception.SuppressedValidationFailures;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.ReservedName;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.cloud.datastore.core.rep.converter.UserIdObfuscator;
import com.google.cloud.datastore.logs.ProblemCode;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class AppEngV3EntityToRepConverter {
    private final Config.DatastoreConfig config;
    private final UserIdObfuscator userIdObfuscator;
    private final AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter;

    public AppEngV3EntityToRepConverter(Config.DatastoreConfig config, UserIdObfuscator userIdObfuscator, AppEngV3ResourceRefToRepConverter appEngV3ResourceRefToRepConverter) {
        this.config = (Config.DatastoreConfig)Preconditions.checkNotNull((Object)config);
        this.userIdObfuscator = (UserIdObfuscator)Preconditions.checkNotNull((Object)userIdObfuscator);
        this.appEngV3ResourceRefToRepConverter = (AppEngV3ResourceRefToRepConverter)Preconditions.checkNotNull((Object)appEngV3ResourceRefToRepConverter);
    }

    public Entity convertEntityUnchecked(OnestoreEntity.EntityProto v3Entity, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) {
        try {
            return this.convertEntity(v3Entity, suppressedFailures, configOverrides);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Entity convertEntity(OnestoreEntity.EntityProto v3Entity, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        OnestoreEntity.Reference v3EntityRef = v3Entity.getKey();
        EntityRef ref = this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3EntityRef, suppressedFailures, configOverrides);
        this.checkEntityFields(v3Entity);
        this.checkForUnknownFields((ProtocolMessage)v3Entity, "OnestoreEntity.EntityProto contains unknown fields.", new Object[0]);
        ImmutableMap<String, Value> propertyMap = this.convertEntityPropertiesToMap(v3Entity.propertys(), v3Entity.rawPropertys(), suppressedFailures, configOverrides);
        return Entity.create(ref, propertyMap);
    }

    private boolean entityDoesV3GroupMatchKey(OnestoreEntity.EntityProto v3Entity) {
        if (v3Entity.getEntityGroup().elements().isEmpty()) {
            return true;
        }
        List v3GroupPathElements = v3Entity.getEntityGroup().elements();
        List v3KeyPathElements = v3Entity.getKey().getPath().elements();
        if (v3KeyPathElements.isEmpty()) {
            return false;
        }
        return ((OnestoreEntity.Path.Element)v3GroupPathElements.get(0)).equals((OnestoreEntity.Path.Element)v3KeyPathElements.get(0));
    }

    private ImmutableMap<String, Value> convertEntityPropertiesToMap(List<OnestoreEntity.Property> properties, List<OnestoreEntity.Property> rawProperties, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        ArrayListMultimap propertyMultimap = ArrayListMultimap.create();
        for (OnestoreEntity.Property indexedPropertyV3 : properties) {
            this.addV3Property(true, indexedPropertyV3, (ListMultimap<String, Value>)propertyMultimap, suppressedFailures, configOverrides);
        }
        for (OnestoreEntity.Property unindexedPropertyV3 : rawProperties) {
            this.addV3Property(false, unindexedPropertyV3, (ListMultimap<String, Value>)propertyMultimap, suppressedFailures, configOverrides);
        }
        ImmutableMap.Builder propertyMapBuilder = ImmutableMap.builder();
        for (String propertyName : propertyMultimap.keySet()) {
            List valueList = propertyMultimap.get((Object)propertyName);
            Value value = valueList.size() > 1 ? this.finishConvertArrayValue(valueList) : (Value)valueList.get(0);
            propertyMapBuilder.put((Object)propertyName, (Object)value);
        }
        return propertyMapBuilder.build();
    }

    private Value finishConvertArrayValue(List<Value> valueList) {
        ImmutableList.Builder valueListBuilder = ImmutableList.builder();
        for (Value value : valueList) {
            if (value == null) continue;
            valueListBuilder.add((Object)value);
        }
        return Value.createArray((ImmutableList<Value>)valueListBuilder.build());
    }

    private void addV3Property(boolean isIndexed, OnestoreEntity.Property v3Property, ListMultimap<String, Value> propertyMultimap, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        String name = ConverterHelper.convertUtf8("Property name", "", v3Property.getNameAsBytes());
        InvalidConversionException.checkConversion(!v3Property.hasStashed(), "Property \"%s\" has field stashed", name);
        InvalidConversionException.checkConversion(!v3Property.hasComputed(), "Property \"%s\" has field computed", name);
        Value value = this.convertValueForProperty(name, v3Property.getValue(), isIndexed, v3Property.getMeaningEnum(), v3Property.getMeaningUri(), suppressedFailures, configOverrides);
        value = value.withDatastoreIndexing(isIndexed || value.equals(Value.EMPTY_ARRAY) ? Value.DatastoreIndexing.INCLUDE : Value.DatastoreIndexing.EXCLUDE);
        if (propertyMultimap.containsKey((Object)name)) {
            if (this.config.getEnableAppEngV3ConverterValidateMultipleTrue()) {
                InvalidConversionException.checkConversion(v3Property.isMultiple() && propertyMultimap.containsEntry((Object)name, null), ProblemCode.PROPERTY_WITH_INVALID_MULTIPLE_FIELD, "One of several properties \"%s\" set field multiple false.", name);
            }
        } else if (v3Property.isMultiple()) {
            InvalidConversionException.checkConversion(!value.equals(Value.EMPTY_ARRAY), "Empty lists cannot be multiple");
            propertyMultimap.put((Object)name, null);
        }
        propertyMultimap.put((Object)name, (Object)value);
    }

    @VisibleForTesting
    public Value convertValueForProperty(String propertyName, OnestoreEntity.PropertyValue v3Value, boolean isIndexed, OnestoreEntity.Property.Meaning v3Meaning, String v3UriMeaning, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        boolean isScatterPropertyValue = propertyName.equals(ReservedName.SCATTER.asString());
        return this.auxConvertValue(false, isScatterPropertyValue, v3Value, isIndexed, v3Meaning, v3UriMeaning, true, suppressedFailures, configOverrides);
    }

    public Value convertValueForQueryCondition(OnestoreEntity.PropertyValue v3Value, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        this.checkForUnknownFields((ProtocolMessage)v3Value, "OnestoreEntity.PropertyValue contains unknown fields.", new Object[0]);
        return this.auxConvertValue(true, false, v3Value, false, OnestoreEntity.Property.Meaning.NO_MEANING, "", false, suppressedFailures, configOverrides);
    }

    private Value auxConvertValue(boolean acceptInvalidUtf8StringBytes, boolean isScatterPropertyValue, OnestoreEntity.PropertyValue v3Value, boolean isIndexed, OnestoreEntity.Property.Meaning v3Meaning, String v3UriMeaning, boolean preserveMeaning, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Value value;
        int v3MeaningNum;
        Value.Meaning meaning;
        int numSetValueFields = this.countSetValueFields(v3Value);
        InvalidConversionException.checkConversion(numSetValueFields <= 1, ProblemCode.PROPERTY_VALUE_WITH_MULTIPLE_TYPES_SET, "OnestoreEntity.PropertyValue sets more than one value field.", new Object[0]);
        boolean meaningMatchesType = AppEngV3EntityToRepConverter.doesV3ValueMatchMeaning(v3Value, v3Meaning, numSetValueFields);
        InvalidConversionException.checkConversionIf(meaningMatchesType, ProblemCode.PROPERTY_VALUE_MEANING_DOES_NOT_MATCH_TYPE, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidatorValidateValueMeaningMatchesType() || v3Meaning == OnestoreEntity.Property.Meaning.BLOB || v3Meaning == OnestoreEntity.Property.Meaning.TEXT || v3Meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO, null, "OnestoreEntity.PropertyValue meaning does not match value fields.", new Object[0]);
        if (!meaningMatchesType) {
            preserveMeaning = false;
        }
        InvalidConversionException.checkConversion((meaning = Value.Meaning.createFromOrdinal(v3MeaningNum = v3Meaning.getValue())) != null, "Unknown meaning %s.", v3Meaning);
        if (!v3UriMeaning.isEmpty()) {
            this.checkV3ValueUriMeaning(v3Value, v3UriMeaning, v3Meaning);
            meaning = Value.Meaning.URI_MEANING_ZLIB;
        }
        if (v3Value.hasBooleanValue()) {
            value = Value.createBoolean(v3Value.isBooleanValue());
        } else if (v3Value.hasInt64Value()) {
            if (v3Meaning == OnestoreEntity.Property.Meaning.GD_WHEN) {
                meaning = Value.Meaning.NONE;
                value = this.convertMicroseconds(v3Value.getInt64Value());
            } else {
                value = Value.createLong(v3Value.getInt64Value());
            }
        } else if (v3Value.hasDoubleValue()) {
            value = Value.createDouble(v3Value.getDoubleValue());
        } else if (v3Value.hasReferenceValue()) {
            value = Value.createEntityRef(this.appEngV3ResourceRefToRepConverter.convertEntityRefForValue(v3Value.getReferenceValue(), suppressedFailures, configOverrides));
        } else if (v3Value.hasStringValue()) {
            if (v3Meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                OnestoreEntity.EntityProto v3Entity = null;
                try {
                    v3Entity = (OnestoreEntity.EntityProto)OnestoreEntity.EntityProto.parser().parsePartialFrom(v3Value.getStringValueAsBytes());
                }
                catch (InvalidProtocolBufferException exception) {
                    InvalidConversionException.checkConversion(!isIndexed, ProblemCode.PROTO_SERIALIZATION_FAILURE, "String value with meaning ENTITY_PROTO is not a serialized EntityProto.", new Object[0]);
                    InvalidConversionException.checkConversionIf(false, ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE, DatastoreCustomizableConfigUtils.getEnableAppEngV3ValidateUnindexedValueEntityProto(this.config, configOverrides), suppressedFailures, "Property contains an invalid nested entity.", new Object[0]);
                }
                if (v3Entity == null) {
                    value = Value.createBytes(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
                } else {
                    try {
                        value = this.convertMapOrEntity(v3Entity, suppressedFailures, configOverrides);
                        meaning = Value.Meaning.NONE;
                    }
                    catch (InvalidConversionException e) {
                        if (isIndexed) {
                            throw e;
                        }
                        InvalidConversionException.checkConversionIf(false, ProblemCode.INVALID_UNINDEXED_PROPERTY_VALUE, DatastoreCustomizableConfigUtils.getEnableAppEngV3ValidateUnindexedValueEntityProto(this.config, configOverrides), suppressedFailures, "Property contains an invalid nested entity.", new Object[0]);
                        value = Value.createBytes(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
                    }
                }
            } else if (v3Meaning == OnestoreEntity.Property.Meaning.BLOB || v3Meaning == OnestoreEntity.Property.Meaning.BYTESTRING) {
                InvalidConversionException.checkConversion(!isIndexed || v3Meaning != OnestoreEntity.Property.Meaning.BLOB, ProblemCode.UNINDEXABLE_MEANING, "A property with meaning BLOB cannot be indexed.", new Object[0]);
                value = Value.createBytes(ByteString.copyFrom((byte[])v3Value.getStringValueAsBytes()));
                if ((isIndexed || v3Meaning == OnestoreEntity.Property.Meaning.BLOB) && meaning != Value.Meaning.URI_MEANING_ZLIB) {
                    meaning = Value.Meaning.NONE;
                }
            } else {
                byte[] stringBytes = v3Value.getStringValueAsBytes();
                if (Utf8.isWellFormed((byte[])stringBytes)) {
                    value = Value.createString(v3Value.getStringValue());
                } else {
                    InvalidConversionException.checkConversionIf(acceptInvalidUtf8StringBytes || v3Meaning == OnestoreEntity.Property.Meaning.NO_MEANING || v3Meaning == OnestoreEntity.Property.Meaning.INDEX_VALUE || v3Meaning == OnestoreEntity.Property.Meaning.TEXT || isScatterPropertyValue && meaning == Value.Meaning.NONE, ProblemCode.PROPERTY_VALUE_STRING_WITH_MEANING_NOT_UTF8, DatastoreCustomizableConfigUtils.getCustomizableConfig(this.config, configOverrides).getEnableAppEngV3ValidateValueStringUtf8WithMeaning(), suppressedFailures, "Ordinary OnestoreEntity.PropertyValue.string_value is not UTF-8.", new Object[0]);
                    value = Value.createBytes(ByteString.copyFrom((byte[])stringBytes));
                    switch (v3Meaning) {
                        case NO_MEANING: {
                            meaning = Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_NONE;
                            break;
                        }
                        case TEXT: {
                            meaning = Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT;
                            break;
                        }
                        case INDEX_VALUE: {
                            break;
                        }
                        default: {
                            meaning = Value.Meaning.NONE;
                        }
                    }
                }
            }
        } else if (v3Value.hasPointValue()) {
            if (v3Meaning == OnestoreEntity.Property.Meaning.GEORSS_POINT) {
                meaning = Value.Meaning.NONE;
            } else if (v3Meaning == OnestoreEntity.Property.Meaning.NO_MEANING) {
                meaning = Value.Meaning.GEO_POINT_WITHOUT_APP_ENG_V3_MEANING;
            }
            OnestoreEntity.PropertyValue.PointValue v3GeoPoint = v3Value.getPointValue();
            LatLng geoPoint = LatLng.newBuilder().setLatitude(v3GeoPoint.getX()).setLongitude(v3GeoPoint.getY()).build();
            value = Value.createGeoPoint(geoPoint);
        } else if (v3Value.hasUserValue()) {
            value = this.convertUserValue(v3Value.getUserValue());
        } else if (v3Meaning == OnestoreEntity.Property.Meaning.EMPTY_LIST) {
            meaning = Value.Meaning.NONE;
            value = Value.EMPTY_ARRAY;
        } else {
            value = Value.NULL;
        }
        if (meaning != Value.Meaning.NONE && preserveMeaning) {
            value = value.withMeaning(meaning);
        }
        return value;
    }

    private int countSetValueFields(OnestoreEntity.PropertyValue v3Value) {
        int numSetValueFields = 0;
        if (v3Value.hasBooleanValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasInt64Value()) {
            ++numSetValueFields;
        }
        if (v3Value.hasDoubleValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasReferenceValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasStringValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasPointValue()) {
            ++numSetValueFields;
        }
        if (v3Value.hasUserValue()) {
            ++numSetValueFields;
        }
        return numSetValueFields;
    }

    private static boolean doesV3ValueMatchMeaning(OnestoreEntity.PropertyValue v3Value, OnestoreEntity.Property.Meaning v3Meaning, int numSetValueFields) {
        boolean predicate = true;
        switch (v3Meaning) {
            case NO_MEANING: 
            case INDEX_VALUE: {
                break;
            }
            case EMPTY_LIST: {
                predicate = numSetValueFields == 0;
                break;
            }
            case TEXT: 
            case BLOB: 
            case BYTESTRING: 
            case ATOM_CATEGORY: 
            case ATOM_LINK: 
            case ATOM_TITLE: 
            case ATOM_CONTENT: 
            case ATOM_SUMMARY: 
            case ATOM_AUTHOR: 
            case GD_EMAIL: 
            case GD_IM: 
            case GD_PHONENUMBER: 
            case GD_POSTALADDRESS: 
            case BLOBKEY: 
            case ENTITY_PROTO: {
                predicate = v3Value.hasStringValue();
                break;
            }
            case GD_WHEN: 
            case GD_RATING: {
                predicate = v3Value.hasInt64Value();
                break;
            }
            case GEORSS_POINT: {
                predicate = v3Value.hasPointValue();
            }
        }
        return predicate;
    }

    private void checkV3ValueUriMeaning(OnestoreEntity.PropertyValue v3Value, String v3UriMeaning, OnestoreEntity.Property.Meaning v3Meaning) throws InvalidConversionException {
        InvalidConversionException.checkConversion(v3UriMeaning.equals("ZLIB"), ProblemCode.PROPERTY_WITH_UNKNOWN_MEANING_URI, "OnestoreEntity.PropertyValue has unknown meaning_uri \"%s\".", v3UriMeaning);
        InvalidConversionException.checkConversion(v3Value.hasStringValue(), ProblemCode.PROPERTY_VALUE_MEANING_DOES_NOT_MATCH_TYPE, "OnestoreEntity.PropertyValue with meaning_uri does not set stringValue.", new Object[0]);
        InvalidConversionException.checkConversion(v3Meaning == OnestoreEntity.Property.Meaning.BLOB, ProblemCode.PROPERTY_VALUE_MEANING_DOES_NOT_MATCH_TYPE, "OnestoreEntity.PropertyValue with meaning_uri has meaning other than BLOB.", new Object[0]);
    }

    private Value convertMicroseconds(long microseconds) {
        try {
            Timestamp timestamp = ConverterHelper.microsecondsToTimestamp(microseconds);
            return Value.createTimestamp(timestamp);
        }
        catch (InvalidConversionException exception) {
            return Value.createLegacyTimestampMicroseconds(microseconds);
        }
    }

    private Value convertMapOrEntity(OnestoreEntity.EntityProto v3Entity, @Nullable SuppressedValidationFailures suppressedFailures, @Nullable DatastoreCustomizableConfigPb.DatastoreCustomizableConfig configOverrides) throws InvalidConversionException {
        Value value;
        UnknownFieldSet v3UnknownFieldSet = v3Entity.getUnknownFields();
        this.checkForUnknownFields((ProtocolMessage)v3Entity, "Unknown fields in an entity.", new Object[0]);
        ImmutableMap<String, Value> map = this.convertEntityPropertiesToMap(v3Entity.propertys(), v3Entity.rawPropertys(), suppressedFailures, configOverrides);
        if (v3Entity.hasKey()) {
            OnestoreEntity.Reference v3EntityRef = v3Entity.getKey();
            if (v3EntityRef.getApp().isEmpty()) {
                if (this.config.getEnableAppEngV3ValidatorValidateKeyWithoutAppIsEmpty()) {
                    InvalidConversionException.checkConversion(!v3EntityRef.hasDatabaseId() && !v3EntityRef.hasNameSpace() && v3EntityRef.getPath().elements().isEmpty(), ProblemCode.NON_EMPTY_ENTITY_REF_WITHOUT_APP, "OnestoreEntity.Reference does not set app.", new Object[0]);
                }
                value = Value.createMap(map, v3UnknownFieldSet);
            } else {
                EntityRef entityRef = this.appEngV3ResourceRefToRepConverter.convertEntityRef(v3EntityRef, suppressedFailures, configOverrides);
                Entity entity = Entity.create(entityRef, map);
                value = Value.createEntity(entity, v3Entity.getUnknownFields());
            }
        } else {
            value = Value.createMap(map, v3UnknownFieldSet);
        }
        this.checkEntityFields(v3Entity);
        return value;
    }

    private Value convertUserValue(OnestoreEntity.PropertyValue.UserValue v3UserValue) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!v3UserValue.hasNickname(), "nickname is not supported yet");
        String email = v3UserValue.getEmail();
        this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.email", v3UserValue.getEmailAsBytes());
        String authDomain = v3UserValue.getAuthDomain();
        this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.authDomain", v3UserValue.getAuthDomainAsBytes());
        String federatedIdentity = null;
        if (v3UserValue.hasFederatedIdentity()) {
            this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedIdentity", v3UserValue.getFederatedIdentityAsBytes());
            federatedIdentity = v3UserValue.getFederatedIdentity();
        }
        String federatedProvider = null;
        if (v3UserValue.hasFederatedProvider()) {
            this.checkUserFieldBytesAreValidUtf8("OnestoreEntity.PropertyValue.UserValue.federatedProvider", v3UserValue.getFederatedProviderAsBytes());
            federatedProvider = v3UserValue.getFederatedProvider();
        }
        String obfuscatedGaiaId = "";
        if (v3UserValue.getGaiaid() != 0L) {
            obfuscatedGaiaId = this.userIdObfuscator.obfuscate(v3UserValue.getGaiaid());
        } else if (v3UserValue.hasObfuscatedGaiaid()) {
            this.userIdObfuscator.checkValidObfuscatedId(v3UserValue.getObfuscatedGaiaid());
            obfuscatedGaiaId = v3UserValue.getObfuscatedGaiaid();
        }
        return Value.createLegacyUser(Value.LegacyUser.create(email, authDomain, obfuscatedGaiaId, federatedIdentity, federatedProvider));
    }

    private void checkEntityFields(OnestoreEntity.EntityProto v3Entity) throws InvalidConversionException {
        InvalidConversionException.checkConversion(this.entityDoesV3GroupMatchKey(v3Entity), ProblemCode.ENTITY_GROUP_DOES_NOT_MATCH_KEY, "OnestoreEntity.EntityProto entity_group does not match key.", new Object[0]);
        InvalidConversionException.checkConversion(!v3Entity.getOwner().hasNickname(), ProblemCode.OWNER_CONTAINS_NICKNAME, "nickname is not supported yet", new Object[0]);
        if (v3Entity.getOwner().hasObfuscatedGaiaid()) {
            this.userIdObfuscator.checkValidObfuscatedId(v3Entity.getOwner().getObfuscatedGaiaid());
        }
    }

    private void checkUserFieldBytesAreValidUtf8(String fieldName, byte[] bytes) throws InvalidConversionException {
        InvalidConversionException.checkConversion(!this.config.getEnableAppEngV3ValidateUserFieldValuesUtf8() || Utf8.isWellFormed((byte[])bytes), "Non-UTF-8 bytes in user field %s.", fieldName);
    }

    @FormatMethod
    private <T extends ProtocolMessage<T>> void checkForUnknownFields(ProtocolMessage<T> proto, String message, Object ... messageArgs) throws InvalidConversionException {
        if (!this.config.getEnableAppEngV3ValidateEntityNoUnknownFields()) {
            return;
        }
        this.validateNoUnknownFieldsRecursive(proto, message, messageArgs);
    }

    @FormatMethod
    <T extends ProtocolMessage<T>> void validateNoUnknownFieldsRecursive(ProtocolMessage<T> proto, String message, Object ... messageArgs) throws InvalidConversionException {
        if (proto == null) {
            return;
        }
        InvalidConversionException.checkConversion(proto.getUnknownFields().asMap().isEmpty(), ProblemCode.ENTITY_WITH_UNKNOWN_FIELDS, message, messageArgs);
        for (Map.Entry entry : proto.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)entry.getKey();
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) continue;
            Object fieldValue = entry.getValue();
            if (fieldDescriptor.isRepeated()) {
                List nestedMessages = (List)fieldValue;
                for (ProtocolMessage nestedMessage : nestedMessages) {
                    this.validateNoUnknownFieldsRecursive(nestedMessage, "Unknown fields in a nested Onestore %s", nestedMessage.getClass().getSimpleName());
                }
                continue;
            }
            ProtocolMessage nestedMessage = (ProtocolMessage)fieldValue;
            this.validateNoUnknownFieldsRecursive(nestedMessage, "Unknown fields in a nested Onestore %s", nestedMessage.getClass().getSimpleName());
        }
    }
}

