/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3.converter;

import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3EntityFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3QueryFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.AppEngV3ResourceRefFromRepConverter;
import com.google.cloud.datastore.core.appengv3.converter.IndexAppEngV3FromRepConverter;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.BufferedWriteResult;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.LookupResults;
import com.google.cloud.datastore.core.rep.MutationResult;
import com.google.cloud.datastore.core.rep.PrepareQueryResult;
import com.google.cloud.datastore.core.rep.QueryResults;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.ServingIndex;
import com.google.cloud.datastore.core.rep.WriteResult;
import com.google.cloud.datastore.core.rep.WriteStats;
import com.google.storage.onestore.v3.OnestoreEntity;

public class AppEngV3FromRepConverter {
    public static final AppEngV3FromRepConverter INSTANCE = new AppEngV3FromRepConverter();

    private AppEngV3FromRepConverter() {
    }

    public DatastorePb.GetResponse toV3GetResponse(LookupResults lookupResults) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        response.setInOrder(lookupResults.inOrder());
        for (ReadResult readResult : lookupResults.results()) {
            if (readResult.missingEntityReason() == ReadResult.MissingEntityReason.DEFERRED) {
                response.addDeferred(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRefUnchecked(readResult.entityRef()));
                continue;
            }
            DatastorePb.GetResponse.Entity entity = response.addEntity();
            if (readResult.exists()) {
                if (readResult.sideChannelEntityProto() != null) {
                    entity.setEntity(readResult.sideChannelEntityProto());
                } else {
                    entity.setEntity(AppEngV3EntityFromRepConverter.INSTANCE.convertEntityUnchecked(readResult.repEntity()));
                }
            } else {
                entity.setKey(AppEngV3ResourceRefFromRepConverter.INSTANCE.convertEntityRefUnchecked(readResult.entityRef()));
            }
            if (readResult.updateVersion() == -1L) continue;
            entity.setVersion(readResult.updateVersion());
        }
        return response;
    }

    public DatastorePb.CommitResponse toV3CommitResponse(WriteResult writeResult) {
        DatastorePb.CommitResponse res = new DatastorePb.CommitResponse().setCost(this.toV3Cost(writeResult.stats(), true));
        for (MutationResult result : writeResult.collapsedMutationResults()) {
            res.addVersion().setRootEntityKey(result.key()).setVersion(result.updateVersion());
        }
        return res;
    }

    public DatastorePb.PutResponse toV3PutResponse(WriteResult writeResult) {
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        for (MutationResult result : writeResult.mutationResults()) {
            response.mutableKeys().add(result.key());
            response.addVersion(result.updateVersion());
        }
        response.setCost(this.toV3Cost(writeResult.stats(), false));
        return response;
    }

    public DatastorePb.PutResponse toV3PutResponse(BufferedWriteResult result) {
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        response.mutableKeys().addAll(result.keys());
        return response;
    }

    public DatastorePb.DeleteResponse toV3DeleteResponse(WriteResult writeResult) {
        DatastorePb.DeleteResponse response = new DatastorePb.DeleteResponse();
        response.setCost(this.toV3Cost(writeResult.stats(), false));
        for (MutationResult result : writeResult.mutationResults()) {
            response.addVersion(result.updateVersion());
        }
        return response;
    }

    public DatastorePb.Cost toV3Cost(WriteStats stats, boolean includeCommitCost) {
        DatastorePb.Cost cost = new DatastorePb.Cost();
        cost.setIndexWrites(stats.indexWrites());
        cost.setIndexWriteBytes(stats.indexWriteBytes());
        cost.setEntityWrites(stats.entityWrites());
        cost.setEntityWriteBytes(stats.entityWriteBytes());
        if (includeCommitCost) {
            DatastorePb.Cost.CommitCost commitCost = cost.getMutableCommitCost();
            commitCost.setRequestedEntityPuts(stats.requestedPuts());
            commitCost.setRequestedEntityDeletes(stats.requestedDeletes());
        }
        cost.setApproximateStorageDelta((int)stats.approximateStorageDelta());
        cost.setIdSequenceUpdates(stats.idSequenceUpdates());
        return cost;
    }

    private DatastorePb.CompiledQuery correctCompiledQuery(DatastorePb.Query original, DatastorePb.CompiledQuery compiledQuery) {
        compiledQuery = ((DatastorePb.CompiledQuery)compiledQuery.clone()).clearLimit();
        compiledQuery.setKeysOnly(original.isKeysOnly());
        if (original.hasOffset()) {
            compiledQuery.setOffset(original.getOffset());
        }
        if (original.hasLimit()) {
            compiledQuery.setLimit(original.getLimit());
        }
        return compiledQuery;
    }

    public DatastorePb.QueryResult toV3NextResult(DatastorePb.NextRequest original, QueryResults internalResult) throws InvalidConversionException {
        DatastorePb.QueryResult result = this.toV3QueryResultBatch(internalResult);
        if (result.isMoreResults()) {
            result.setCursor(original.getCursor());
        }
        return result;
    }

    private DatastorePb.QueryResult toV3QueryResultBatch(QueryResults internalResult) throws InvalidConversionException {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        result.setSkippedResults(internalResult.skippedResults());
        if (internalResult.skippedCursor() != null) {
            result.setSkippedResultsCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(internalResult.skippedCursor(), internalResult.query().firstSortDirection()));
        }
        for (ReadResult readResult : internalResult.readResults()) {
            OnestoreEntity.EntityProto entity = readResult.sideChannelEntityProto() != null ? readResult.sideChannelEntityProto() : AppEngV3EntityFromRepConverter.INSTANCE.convertEntityUnchecked(readResult.repEntity());
            if (internalResult.query().hasOnlyKeys() || internalResult.query().isIndexOnly()) {
                entity.setEntityGroup(new OnestoreEntity.Path());
            }
            result.addResult(entity);
            if (readResult.updateVersion() != -1L) {
                result.addVersion(readResult.updateVersion());
            }
            if (readResult.cursor() == null) continue;
            result.addResultCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(readResult.cursor(), internalResult.query().firstSortDirection()));
        }
        if (internalResult.endCursor() != null) {
            result.setCompiledCursor(AppEngV3QueryFromRepConverter.INSTANCE.convertCursor(internalResult.endCursor(), internalResult.query().firstSortDirection()));
        }
        result.setMoreResults(internalResult.moreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        result.setKeysOnly(internalResult.query().hasOnlyKeys());
        result.setIndexOnly(internalResult.query().isIndexOnly());
        result.setSmallOps(internalResult.query().isSmallOps());
        return result;
    }

    public DatastorePb.QueryResult toV3RunQueryResult(DatabaseRef databaseRef, DatastorePb.Query original, PrepareQueryResult prepareQueryResult, QueryResults queryResults) throws InvalidConversionException {
        DatastorePb.QueryResult result = this.toV3QueryResultBatch(queryResults);
        if (queryResults.query().compiledQuery() != null) {
            result.setCompiledQuery(this.correctCompiledQuery(original, queryResults.query().compiledQuery()));
        }
        for (ServingIndex index : prepareQueryResult.indexes()) {
            result.addIndex(IndexAppEngV3FromRepConverter.INSTANCE.convertIndex(databaseRef, index));
        }
        if (result.isMoreResults()) {
            AppEngV3DatabaseRefExtractor.set(result.getMutableCursor(), databaseRef).setCursor(prepareQueryResult.handle());
        }
        return result;
    }
}

