/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_DatabaseIndexesWithValidityWindow;
import com.google.cloud.datastore.core.rep.DatabaseIndexGroup;
import java.time.Instant;

@AutoValue
public abstract class DatabaseIndexesWithValidityWindow {
    public abstract DatabaseIndexGroup databaseIndexGroup();

    public abstract Instant readTime();

    public abstract Instant expiration();

    public static DatabaseIndexesWithValidityWindow create(DatabaseIndexGroup databaseIndexGroup, Instant readTime, Instant expiration) {
        return new AutoValue_DatabaseIndexesWithValidityWindow(databaseIndexGroup, readTime, expiration);
    }

    public static DatabaseIndexesWithValidityWindow of(DatabaseIndexGroup databaseIndexGroup) {
        return DatabaseIndexesWithValidityWindow.create(databaseIndexGroup, Instant.EPOCH, Instant.MAX);
    }

    public boolean isValidForTimestamp(Instant timestamp) {
        if (timestamp.isBefore(this.readTime())) {
            return false;
        }
        return !timestamp.isAfter(this.expiration());
    }
}

