/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_DatastoreBuiltinIndex;
import com.google.cloud.datastore.core.rep.WorkflowState;
import java.time.Instant;
import javax.annotation.Nullable;

@AutoValue
public abstract class DatastoreBuiltinIndex {
    public abstract Mode mode();

    public abstract WorkflowState workflowState();

    @Nullable
    public abstract Instant updateTime();

    public static DatastoreBuiltinIndex create(Mode mode, WorkflowState workflowState) {
        return DatastoreBuiltinIndex.create(mode, workflowState, null);
    }

    public static DatastoreBuiltinIndex create(Mode mode, WorkflowState workflowState, @Nullable Instant updateTime) {
        return new AutoValue_DatastoreBuiltinIndex(mode, workflowState, updateTime);
    }

    public static DatastoreBuiltinIndex serving(Mode mode) {
        return DatastoreBuiltinIndex.create(mode, WorkflowState.SERVING);
    }

    public static DatastoreBuiltinIndex serving(Mode mode, Instant updateTime) {
        return DatastoreBuiltinIndex.create(mode, WorkflowState.SERVING, updateTime);
    }

    public static DatastoreBuiltinIndex enabling(Mode mode) {
        return DatastoreBuiltinIndex.create(mode, WorkflowState.ENABLING);
    }

    public static enum Mode {
        KIND(-1L),
        KIND_SCATTER(-8L),
        ASC(-2L),
        DESC(-3L),
        KIND_PARENT(-15L),
        NAMESPACE_SCATTER(-16L),
        DATABASE_SCATTER(-17L),
        KIND_ACROSS_NAMESPACE_SCATTER(-18L),
        SCATTER_ASC(-19L);

        public final long appliedIndexId;
        private static final ImmutableMap<Long, Mode> APPLIED_INDEX_ID_TO_MODE;

        private Mode(long appliedIndexId) {
            this.appliedIndexId = appliedIndexId;
        }

        @Nullable
        public static Mode fromAppliedIndexId(long appliedIndexId) {
            return (Mode)((Object)APPLIED_INDEX_ID_TO_MODE.get((Object)appliedIndexId));
        }

        static {
            ImmutableMap.Builder appliedIndexIdToMapBuilder = ImmutableMap.builder();
            for (Mode mode : Mode.values()) {
                appliedIndexIdToMapBuilder.put((Object)mode.appliedIndexId, (Object)mode);
            }
            APPLIED_INDEX_ID_TO_MODE = appliedIndexIdToMapBuilder.build();
        }
    }
}

