/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexState;
import com.google.cloud.datastore.core.rep.CompositeIndex;
import com.google.cloud.datastore.core.rep.WorkflowState;

@AutoValue
public abstract class IndexState {
    public abstract WorkflowState workflowState();

    public abstract boolean error();

    public static IndexState of(WorkflowState workflowState) {
        return IndexState.create(workflowState, false);
    }

    public static IndexState createError(WorkflowState workflowState) {
        return IndexState.create(workflowState, true);
    }

    public static IndexState create(WorkflowState workflowState, boolean error) {
        Preconditions.checkArgument((!error || workflowState.finalizing() ? 1 : 0) != 0, (Object)"indexes must not have errors unless they are in a finalizing state");
        return new AutoValue_IndexState(workflowState, error);
    }

    @Deprecated
    public CompositeIndex.State toLegacyState() {
        if (this.error()) {
            return CompositeIndex.State.ERROR;
        }
        switch (this.workflowState()) {
            case CREATED: {
                return CompositeIndex.State.CREATED;
            }
            case ENABLING: {
                return CompositeIndex.State.ENABLING;
            }
            case SERVING: {
                return CompositeIndex.State.ENABLED;
            }
            case NON_SERVING: {
                return CompositeIndex.State.NON_SERVING;
            }
            case DISABLING: {
                return CompositeIndex.State.DELETING;
            }
            case DELETED: {
                return CompositeIndex.State.DISABLED;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid or unknown index state: %s", new Object[]{this.workflowState()}));
    }
}

