/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.cloud.datastore.core.rep.ExternalDatabaseRef;

public final class ExternalDatabaseRefConverter {
    private ExternalDatabaseRefConverter() {
    }

    public static com.google.cloud.datastore.core.rep.proto.ExternalDatabaseRef toProto(ExternalDatabaseRef databaseRef) {
        switch (databaseRef.project().type()) {
            case ID: {
                return com.google.cloud.datastore.core.rep.proto.ExternalDatabaseRef.newBuilder().setProjectId(databaseRef.project().id()).setDatabaseId(databaseRef.databaseId()).build();
            }
            case NUMBER: {
                return com.google.cloud.datastore.core.rep.proto.ExternalDatabaseRef.newBuilder().setProjectNumber(databaseRef.project().number()).setDatabaseId(databaseRef.databaseId()).build();
            }
        }
        throw new AssertionError((Object)"unreachable.");
    }

    public static ExternalDatabaseRef toRep(com.google.cloud.datastore.core.rep.proto.ExternalDatabaseRef databaseRef) {
        switch (databaseRef.getProjectCase()) {
            case PROJECT_ID: {
                return ExternalDatabaseRef.create(databaseRef.getProjectId(), databaseRef.getDatabaseId());
            }
            case PROJECT_NUMBER: {
                return ExternalDatabaseRef.create(databaseRef.getProjectNumber(), databaseRef.getDatabaseId());
            }
            case PROJECT_NOT_SET: {
                throw new IllegalArgumentException("Project case type not specified.");
            }
        }
        throw new AssertionError((Object)"unreachable.");
    }
}

