/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.cloud.datastore.admininternal.ExternalIndexResource;
import com.google.cloud.datastore.core.exception.InvalidConversionException;

public class IndexResourceConverterHelper {
    public static final String INVALID_INDEX_RESOURCE_ID = "Invalid index resource id";

    public static long indexResourceIdToIndexId(String stringIndexId) throws InvalidConversionException {
        ExternalIndexResource indexResource;
        try {
            indexResource = ExternalIndexResource.parseFrom((byte[])BaseEncoding.base64Url().decode((CharSequence)stringIndexId), (ExtensionRegistryLite)ExtensionRegistry.getGeneratedRegistry());
        }
        catch (InvalidProtocolBufferException | IllegalArgumentException e) {
            throw new InvalidConversionException(IndexResourceConverterHelper.getInvalidIndexResourceIdError(stringIndexId), e);
        }
        InvalidConversionException.checkConversion(indexResource.getIndexId() > 0L, IndexResourceConverterHelper.getInvalidIndexResourceIdError(stringIndexId));
        return indexResource.getIndexId();
    }

    public static String indexIdToIndexResourceId(long indexId) {
        ExternalIndexResource indexResource = ExternalIndexResource.newBuilder().setIndexId(indexId).build();
        return BaseEncoding.base64Url().omitPadding().encode(indexResource.toByteArray());
    }

    public static String getInvalidIndexResourceIdError(String stringIndexId) {
        return String.format("%s \"%s\".", INVALID_INDEX_RESOURCE_ID, stringIndexId);
    }
}

