/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.proto.IndexValue;

public class IndexValueToRepConverter {
    public static final IndexValueToRepConverter INSTANCE = new IndexValueToRepConverter();

    private IndexValueToRepConverter() {
    }

    public IndexValue.EntityRef convertEntityRefRelDatabase(DatabaseRef databaseRef, com.google.cloud.datastore.core.rep.proto.IndexValue apiEntityRefIndexValue) throws InvalidConversionException {
        InvalidConversionException.checkConversion(apiEntityRefIndexValue.getValueTypeCase() == IndexValue.ValueTypeCase.RESOURCE_NAME_VALUE, "Expected document resource name.");
        return this.convertIndexValueEntityRef(false, databaseRef, apiEntityRefIndexValue.getResourceNameValue());
    }

    public IndexValue convertIndexValue(DatabaseRef contextDatabaseRef, com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValue) throws InvalidConversionException {
        switch (apiIndexValue.getValueTypeCase()) {
            case NULL_VALUE: {
                return IndexValue.NULL;
            }
            case BOOLEAN_VALUE: {
                return IndexValue.createBoolean(apiIndexValue.getBooleanValue());
            }
            case NAN_VALUE: {
                return IndexValue.NAN;
            }
            case NUMBER_VALUE: {
                IndexValue.NumberValue apiNumberIndexValue = apiIndexValue.getNumberValue();
                switch (apiNumberIndexValue.getNumberTypeCase()) {
                    case LONG_VALUE: {
                        return IndexValue.createNumberLong(apiNumberIndexValue.getLongValue());
                    }
                    case DOUBLE_VALUE: {
                        return IndexValue.createNumberDouble(apiNumberIndexValue.getDoubleValue());
                    }
                }
                throw new InvalidConversionException("Unknown com.google.cloud.datastore.core.rep.proto.IndexValue.NumberValue.number_type.");
            }
            case TIMESTAMP_VALUE: {
                return IndexValue.createTimestamp(apiIndexValue.getTimestampValue());
            }
            case STRING_VALUE: {
                return this.convertStringIndexValue(apiIndexValue.getStringValue());
            }
            case BYTES_VALUE: {
                IndexValue.BytesValue apiBytesIndexValue = apiIndexValue.getBytesValue();
                return IndexValue.createBytes(apiBytesIndexValue.getTruncated(), apiBytesIndexValue.getValue());
            }
            case RESOURCE_NAME_VALUE: {
                return IndexValue.createEntityRef(this.convertIndexValueEntityRef(true, contextDatabaseRef, apiIndexValue.getResourceNameValue()));
            }
            case GEO_POINT_VALUE: {
                return IndexValue.createGeoPoint(apiIndexValue.getGeoPointValue());
            }
            case MAP_VALUE: {
                return this.convertMapIndexValue(contextDatabaseRef, apiIndexValue.getMapValue());
            }
            case ARRAY_VALUE: {
                return this.convertArrayIndexValue(contextDatabaseRef, apiIndexValue.getArrayValue());
            }
        }
        throw new InvalidConversionException("Unknown com.google.cloud.datastore.core.rep.proto.IndexValue.value_type.");
    }

    private IndexValue.EntityRef convertIndexValueEntityRef(boolean useApiDatabase, DatabaseRef databaseRef, IndexValue.ResourceName apiResourceName) throws InvalidConversionException {
        switch (apiResourceName.getResourceTypeCase()) {
            case DOCUMENT_RESOURCE_NAME: {
                IndexValue segments;
                boolean apiHasSegments;
                IndexValue.DocumentResourceName apiDocumentName = apiResourceName.getDocumentResourceName();
                if (useApiDatabase) {
                    IndexValue.StringValue apiProjectId = apiDocumentName.getProjectId();
                    InvalidConversionException.checkConversion(!apiProjectId.getTruncated(), "Truncated com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.project_id.");
                    String projectId = apiProjectId.getValue();
                    IndexValue.StringValue apiDatabaseId = apiDocumentName.getDatabaseId();
                    InvalidConversionException.checkConversion(!apiDatabaseId.getTruncated(), "Truncated com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.database_id.");
                    String databaseId = apiDatabaseId.getValue();
                    databaseRef = DatabaseRef.createForProject(databaseRef.partitionId(), projectId, databaseId);
                } else {
                    InvalidConversionException.checkConversion(!apiDocumentName.hasProjectId(), "Unexpected com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.project_id.");
                    InvalidConversionException.checkConversion(!apiDocumentName.hasDatabaseId(), "Unexpected com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.database_id.");
                }
                IndexValue namespaceId = apiDocumentName.hasNamespaceId() ? this.convertStringIndexValue(apiDocumentName.getNamespaceId()) : IndexValue.ABSENT;
                boolean bl = apiHasSegments = apiDocumentName.getSegmentsCount() != 0;
                if (namespaceId.isShallowTruncated()) {
                    InvalidConversionException.checkConversion(!apiHasSegments, "Unexpected com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.segments.");
                    InvalidConversionException.checkConversion(!apiDocumentName.getTruncated(), "Unexpected com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.truncated.");
                    segments = IndexValue.ABSENT;
                } else if (!apiHasSegments) {
                    segments = apiDocumentName.getTruncated() ? IndexValue.ABSENT : IndexValue.EMPTY_ARRAY;
                } else {
                    ImmutableList.Builder segmentsBuilder = ImmutableList.builder();
                    for (IndexValue.DocumentResourceName.Segment apiSegment : apiDocumentName.getSegmentsList()) {
                        IndexValue segment;
                        switch (apiSegment.getIdTypeCase()) {
                            case INTEGER_ID: {
                                segment = IndexValue.createNumberLong(apiSegment.getIntegerId());
                                break;
                            }
                            case STRING_ID: {
                                segment = this.convertStringIndexValue(apiSegment.getStringId());
                                break;
                            }
                            default: {
                                throw new InvalidConversionException("Unknown com.google.cloud.datastore.core.rep.proto.IndexValue.DocumentResourceName.id_type.");
                            }
                        }
                        segmentsBuilder.add((Object)segment);
                    }
                    segments = IndexValue.createArray(apiDocumentName.getTruncated(), (ImmutableList<IndexValue>)segmentsBuilder.build());
                }
                return IndexValue.EntityRef.create(databaseRef, namespaceId, segments);
            }
        }
        throw new InvalidConversionException("Unknown com.google.cloud.datastore.core.rep.proto.IndexValue.ResourceName.resource_type.");
    }

    private IndexValue convertArrayIndexValue(DatabaseRef contextDatabaseRef, IndexValue.ArrayValue apiArrayIndexValue) throws InvalidConversionException {
        ImmutableList.Builder elementsBuilder = ImmutableList.builder();
        for (com.google.cloud.datastore.core.rep.proto.IndexValue apiElement : apiArrayIndexValue.getValuesList()) {
            elementsBuilder.add((Object)this.convertIndexValue(contextDatabaseRef, apiElement));
        }
        return IndexValue.createArray(apiArrayIndexValue.getTruncated(), (ImmutableList<IndexValue>)elementsBuilder.build());
    }

    private IndexValue convertMapIndexValue(DatabaseRef contextDatabaseRef, IndexValue.MapValue apiMapIndexValue) throws InvalidConversionException {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (IndexValue.MapValue.MapEntry apiMapEntry : apiMapIndexValue.getEntriesList()) {
            InvalidConversionException.checkConversion(apiMapEntry.hasKey(), "Expected com.google.cloud.datastore.core.rep.proto.IndexValue.MapValue.MapEntry.");
            IndexValue keyIndexValue = this.convertStringIndexValue(apiMapEntry.getKey());
            IndexValue valueIndexValue = apiMapEntry.hasValue() ? this.convertIndexValue(contextDatabaseRef, apiMapEntry.getValue()) : IndexValue.ABSENT;
            mapBuilder.put((Object)keyIndexValue, (Object)valueIndexValue);
        }
        return IndexValue.createMap(apiMapIndexValue.getTruncated(), (ImmutableMap<IndexValue, IndexValue>)mapBuilder.build());
    }

    private IndexValue convertStringIndexValue(IndexValue.StringValue apiStringIndexValue) {
        return IndexValue.createString(apiStringIndexValue.getTruncated(), apiStringIndexValue.getValue());
    }
}

