/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.size;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexEntry;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.ServingIndex;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.size.NaturalSizer;
import java.util.Map;

public final class BillingSizer {
    private static final int KEY_SUFFIX_SIZE = NaturalSizer.stringSize("__key__");

    private BillingSizer() {
    }

    public static int entitySize(Entity entity) {
        int base = BillingSizer.entitySize(entity.ref(), entity.propertyMap());
        for (Map.Entry property : entity.propertyMap().entrySet()) {
            base += BillingSizer.flattenedTopLevelPropertySize((String)property.getKey(), (Value)property.getValue());
        }
        return base;
    }

    private static int flattenedTopLevelPropertySize(String name, Value value) {
        switch (value.type()) {
            case ENTITY: 
            case MAP: {
                return BillingSizer.flattenedPropertySize(NaturalSizer.stringSize(name), value);
            }
            case ARRAY: {
                int size = 0;
                for (Value subValue : value.asArray()) {
                    size += BillingSizer.flattenedTopLevelPropertySize(name, subValue);
                }
                return size;
            }
        }
        return 0;
    }

    private static int flattenedPropertySize(int pathPrefixSize, Value value) {
        if (!value.isDatastoreIndexed()) {
            return 0;
        }
        switch (value.type()) {
            case ARRAY: {
                int arraySize = 0;
                for (Value subValue : value.asArray()) {
                    arraySize += BillingSizer.flattenedPropertySize(pathPrefixSize, subValue);
                }
                return arraySize;
            }
            case ENTITY: {
                int entitySize = 0;
                if (!value.asEntity().ref().path().isEmpty()) {
                    entitySize += pathPrefixSize + KEY_SUFFIX_SIZE + NaturalSizer.entityRefSize(value.asEntity().ref());
                }
                for (Map.Entry property : value.asEntity().propertyMap().entrySet()) {
                    entitySize += BillingSizer.flattenedPropertySize(pathPrefixSize + NaturalSizer.stringSize((String)property.getKey()), (Value)property.getValue());
                }
                return entitySize;
            }
            case MAP: {
                int mapSize = 0;
                for (Map.Entry property : value.asMap().entrySet()) {
                    mapSize += BillingSizer.flattenedPropertySize(pathPrefixSize + NaturalSizer.stringSize((String)property.getKey()), (Value)property.getValue());
                }
                return mapSize;
            }
            case NULL: 
            case BYTES: 
            case ENTITY_REF: 
            case GEO_REGION: 
            case GEO_POINT: 
            case TIMESTAMP: 
            case LEGACY_USER: 
            case RESOURCE_REF: 
            case LEGACY_TIMESTAMP_MICROSECONDS: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return BillingSizer.propertySize(pathPrefixSize, value);
            }
        }
        throw new AssertionError((Object)"unexpected value type");
    }

    private static int entitySize(EntityRef ref, ImmutableMap<String, Value> properties) {
        return 32 + NaturalSizer.entityRefSize(ref) + BillingSizer.propertiesSize(properties);
    }

    private static int propertiesSize(ImmutableMap<String, Value> properties) {
        int size = 0;
        for (Map.Entry property : properties.entrySet()) {
            String name = (String)property.getKey();
            Value value = (Value)property.getValue();
            if (BillingSizer.ignoredForBilling(PropertyName.create(name))) continue;
            size += BillingSizer.propertySize(NaturalSizer.stringSize(name), value);
        }
        return size;
    }

    private static int propertySize(int nameSize, Value value) {
        switch (value.type()) {
            case ENTITY: {
                return nameSize + BillingSizer.entitySize(value.asEntity().ref(), value.asEntity().propertyMap());
            }
            case MAP: {
                return nameSize + BillingSizer.entitySize(EntityRef.EMPTY, value.asMap());
            }
            case ARRAY: {
                if (!value.asArray().isEmpty()) {
                    int size = 0;
                    for (Value subValue : value.asArray()) {
                        size += BillingSizer.propertySize(nameSize, subValue);
                    }
                    return size;
                }
                return nameSize + NaturalSizer.valueSize(value);
            }
            case BYTES: {
                if (value.isDatastoreIndexed() || value.meaning().equals((Object)Value.Meaning.NON_UTF8_BLOB_WITH_APP_ENG_V3_MEANING_TEXT)) {
                    return nameSize + NaturalSizer.stringSize(value.asBytes());
                }
                return nameSize + NaturalSizer.valueSize(value);
            }
            case NULL: 
            case ENTITY_REF: 
            case GEO_REGION: 
            case GEO_POINT: 
            case TIMESTAMP: 
            case LEGACY_USER: 
            case RESOURCE_REF: 
            case LEGACY_TIMESTAMP_MICROSECONDS: 
            case LONG: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return nameSize + NaturalSizer.valueSize(value);
            }
        }
        throw new AssertionError((Object)"unexpected value type");
    }

    public static int indexEntrySize(IndexEntry indexEntry) {
        if (BillingSizer.ignoredForBilling(indexEntry.index())) {
            return 0;
        }
        return NaturalSizer.indexEntrySize(indexEntry);
    }

    private static boolean ignoredForBilling(ServingIndex index) {
        if (index.definition().isKeyAscending() || index.definition().isKindAndParentAscending() || index.definition().isKindlessScatter()) {
            return true;
        }
        return index.definition().containsOnlyScatterProperty() && (index.isAcrossNamespace() || index.definition().isBuiltinSingleProperty());
    }

    private static boolean ignoredForBilling(PropertyName propertyName) {
        return propertyName.special().isConfigDependent();
    }
}

