/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.size;

import com.google.cloud.datastore.core.rep.IndexEntry;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.ServingIndex;
import com.google.cloud.datastore.core.rep.size.NaturalSizer;

public final class LimitSizer {
    private LimitSizer() {
    }

    public static int indexEntrySize(IndexEntry indexEntry) {
        return LimitSizer.indexEntryKeySize(indexEntry);
    }

    public static int indexEntryKeySize(IndexEntry indexEntry) {
        if (LimitSizer.ignoredForLimits(indexEntry.index())) {
            return 0;
        }
        int size = NaturalSizer.indexEntryKeySize(indexEntry);
        if (indexEntry.index().definition().isBuiltinFirestoreCollectionGroupSingleProperty() || indexEntry.index().definition().isBuiltinFirestoreCollectionSingleProperty()) {
            size += NaturalSizer.stringSize(indexEntry.entityRef().collectionId()) + NaturalSizer.stringSize(indexEntry.entityRef().partitionRef().namespace());
            if (indexEntry.index().definition().propertyDefs().size() == 2) {
                size += NaturalSizer.entityRefSize(indexEntry.entityRef());
            }
        }
        return size;
    }

    @Deprecated
    public static int formattedIndexEntryKeySize(IndexEntry indexEntry) {
        int resultSize = indexEntry.ancestorValue() == null ? 0 : indexEntry.ancestorValue().naturalSize();
        for (IndexValue indexValue : indexEntry.values()) {
            resultSize += indexValue.naturalSize();
        }
        return resultSize;
    }

    private static boolean ignoredForLimits(ServingIndex index) {
        if (index.definition().isKeyAscending() || index.definition().isKindAndKeyAscending() || index.definition().isKindAndParentAscending() || index.definition().isKindlessScatter()) {
            return true;
        }
        return index.definition().containsOnlyScatterProperty() && (index.definition().isBuiltinSingleProperty() || index.isAcrossNamespace());
    }
}

