/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.size;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Utf8;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.Entity;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexDef;
import com.google.cloud.datastore.core.rep.IndexEntry;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.OtherServiceResourceRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.PropertyName;
import com.google.cloud.datastore.core.rep.PropertyPath;
import com.google.cloud.datastore.core.rep.PropertyPathSegment;
import com.google.cloud.datastore.core.rep.ReadResult;
import com.google.cloud.datastore.core.rep.ResourceRef;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.ConverterHelper;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;
import java.util.Map;

public final class NaturalSizer {
    private static final int SIZE_INT64 = 8;
    private static final int SIZE_BOOLEAN = 1;
    private static final int SIZE_DOUBLE = 8;
    private static final int SIZE_TIMESTAMP_NANOS = 8;
    private static final int SIZE_POINT = 16;
    private static final int SIZE_NULL = 1;
    static final int SIZE_KEY_ID = 8;
    private static final int BASE_SIZE_KEY = 16;
    static final int BASE_SIZE_ENTITY = 32;
    public static final int BASE_SIZE_INDEX_ENTRY = 32;
    public static final String PROPERTY_NAME_EMAIL = "email";
    public static final String PROPERTY_NAME_AUTH_DOMAIN = "auth_domain";
    public static final String PROPERTY_NAME_FEDERATED_IDENTITY = "federated_identity";
    public static final String PROPERTY_NAME_FEDERATED_PROVIDER = "federated_provider";

    private NaturalSizer() {
    }

    public static int readResultSize(ReadResult readResult) {
        Preconditions.checkArgument((boolean)readResult.exists());
        return readResult.repEntity() != null ? NaturalSizer.entitySize(readResult.repEntity()) : NaturalSizer.entitySize(readResult.sideChannelEntityProto());
    }

    public static int entitySize(OnestoreEntity.EntityProto entity) {
        int size = NaturalSizer.keySize(entity.getKey());
        for (OnestoreEntity.Property property : entity.propertys()) {
            size += NaturalSizer.propertySize(property);
        }
        for (OnestoreEntity.Property property : entity.rawPropertys()) {
            size += NaturalSizer.propertySize(property);
        }
        return size + 32;
    }

    public static int entitySize(Entity entity) {
        return 32 + NaturalSizer.entityRefSize(entity.ref()) + NaturalSizer.optionalMapSize(entity.propertyMap());
    }

    public static int keySize(OnestoreEntity.Reference key) {
        return NaturalSizer.baseKeySize(key) + NaturalSizer.pathSize(key.getPath());
    }

    public static int keyValueSize(OnestoreEntity.PropertyValue.ReferenceValue key) {
        return NaturalSizer.baseKeyValueSize(key) + NaturalSizer.pathSize(key.pathElements());
    }

    private static int baseKeySize(OnestoreEntity.Reference key) {
        return 16 + NaturalSizer.optionalStringSize(key.getNameSpaceAsBytes());
    }

    private static int baseKeyValueSize(OnestoreEntity.PropertyValue.ReferenceValue key) {
        return 16 + NaturalSizer.optionalStringSize(key.getNameSpaceAsBytes());
    }

    private static int pathSize(List<OnestoreEntity.PropertyValue.ReferenceValuePathElement> path) {
        int size = 0;
        for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : path) {
            size += NaturalSizer.stringSize(element.getTypeAsBytes());
            if (element.hasName()) {
                size += NaturalSizer.stringSize(element.getNameAsBytes());
                continue;
            }
            size += 8;
        }
        return size;
    }

    private static int pathSize(OnestoreEntity.Path path) {
        int size = 0;
        for (OnestoreEntity.Path.Element element : path.elements()) {
            size += NaturalSizer.stringSize(element.getTypeAsBytes());
            if (element.hasName()) {
                size += NaturalSizer.stringSize(element.getNameAsBytes());
                continue;
            }
            size += 8;
        }
        return size;
    }

    private static int pathSize(EntityRef ref) {
        int size = 0;
        for (EntityRef.PathElement element : ref.pathElements()) {
            size += NaturalSizer.escapedIdSize(element.collectionId());
            if (element.resourceId() == null) {
                size += 8;
                continue;
            }
            switch (element.resourceId().typeOf()) {
                case STRING: {
                    size += NaturalSizer.escapedIdSize(element.resourceId().string());
                    break;
                }
                case NUMBER: {
                    size += 8;
                }
            }
        }
        return size;
    }

    private static int escapedIdSize(String id) {
        try {
            byte[] bytes = ConverterHelper.convertStringToBytesIfNonUtf8("", id);
            if (bytes != null) {
                return NaturalSizer.stringSize(bytes);
            }
            return NaturalSizer.stringSize(id);
        }
        catch (InvalidConversionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int propertySize(OnestoreEntity.Property property) {
        if (NaturalSizer.excludeProperty(PropertyName.create(property.getName()))) {
            return 0;
        }
        return NaturalSizer.actualPropertySize(property);
    }

    public static int actualPropertySize(OnestoreEntity.Property property) {
        return NaturalSizer.stringSize(property.getNameAsBytes()) + NaturalSizer.propertyValueSize(property.getValue(), property.getMeaningEnum());
    }

    public static int propertyValueSize(OnestoreEntity.PropertyValue value, OnestoreEntity.Property.Meaning meaning) {
        if (value.hasInt64Value()) {
            return 8;
        }
        if (value.hasStringValue()) {
            switch (meaning) {
                case BLOB: {
                    return value.getStringValueAsBytes().length;
                }
                case ENTITY_PROTO: {
                    OnestoreEntity.EntityProto embedded = new OnestoreEntity.EntityProto();
                    if (embedded.parseFrom(value.getStringValueAsBytes())) {
                        return NaturalSizer.entitySize(embedded) + embedded.getUnknownFields().getSerializedSize();
                    }
                    return value.getStringValueAsBytes().length;
                }
            }
            return NaturalSizer.stringSize(value.getStringValueAsBytes());
        }
        if (value.hasBooleanValue()) {
            return 1;
        }
        if (value.hasDoubleValue()) {
            return 8;
        }
        if (value.hasPointValue()) {
            return 16;
        }
        if (value.hasUserValue()) {
            OnestoreEntity.PropertyValue.UserValue userValue = value.getUserValue();
            int size = NaturalSizer.stringSize(PROPERTY_NAME_EMAIL) + NaturalSizer.stringSize(userValue.getEmailAsBytes()) + NaturalSizer.stringSize(PROPERTY_NAME_AUTH_DOMAIN) + NaturalSizer.stringSize(userValue.getAuthDomainAsBytes());
            if (userValue.hasFederatedIdentity()) {
                size += NaturalSizer.stringSize(PROPERTY_NAME_FEDERATED_IDENTITY) + NaturalSizer.stringSize(userValue.getFederatedIdentityAsBytes());
            }
            if (userValue.hasFederatedProvider()) {
                size += NaturalSizer.stringSize(PROPERTY_NAME_FEDERATED_PROVIDER) + NaturalSizer.stringSize(userValue.getFederatedProviderAsBytes());
            }
            return size;
        }
        if (value.hasReferenceValue()) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = value.getReferenceValue();
            int size = 16 + NaturalSizer.optionalStringSize(refValue.getNameSpaceAsBytes());
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                size += NaturalSizer.stringSize(element.getTypeAsBytes());
                if (element.hasName()) {
                    size += NaturalSizer.stringSize(element.getNameAsBytes());
                    continue;
                }
                size += 8;
            }
            return size;
        }
        return 1;
    }

    public static int stringSize(String s) {
        return Utf8.encodedLength((CharSequence)s) + 1;
    }

    static int stringSize(byte[] utf8Bytes) {
        return utf8Bytes.length + 1;
    }

    static int stringSize(ByteString utf8Bytes) {
        return utf8Bytes.size() + 1;
    }

    private static int optionalStringSize(String s) {
        return s.isEmpty() ? 0 : NaturalSizer.stringSize(s);
    }

    private static int optionalStringSize(byte[] utf8Bytes) {
        return utf8Bytes.length == 0 ? 0 : NaturalSizer.stringSize(utf8Bytes);
    }

    public static int propertyPathSize(PropertyPath propertyPath) {
        int sum = 0;
        while (propertyPath != null && !(propertyPath.segment() instanceof PropertyPathSegment.AllArrayElements)) {
            sum += NaturalSizer.stringSize(propertyPath.memberName());
            propertyPath = propertyPath.next();
        }
        return sum;
    }

    private static int optionalMapSize(Map<String, Value> map) {
        int size = 0;
        for (Map.Entry<String, Value> entry : map.entrySet()) {
            if (NaturalSizer.excludeProperty(PropertyName.create(entry.getKey()))) continue;
            size += NaturalSizer.stringSize(entry.getKey()) + NaturalSizer.valueSize(entry.getValue());
        }
        return size;
    }

    private static int mapSize(Map<String, Value> map) {
        if (map.isEmpty()) {
            return 1;
        }
        return NaturalSizer.optionalMapSize(map);
    }

    private static int arraySize(List<Value> array) {
        if (array.isEmpty()) {
            return 1;
        }
        int size = 0;
        for (Value value : array) {
            size += NaturalSizer.valueSize(value);
        }
        return size;
    }

    static int partitionRefSize(PartitionRef ref) {
        return 16 + NaturalSizer.optionalStringSize(ref.namespace());
    }

    public static int entityRefSize(EntityRef ref) {
        return NaturalSizer.partitionRefSize(ref.partitionRef()) + NaturalSizer.pathSize(ref);
    }

    public static int valueSize(Value value) {
        int size = value.unknownFieldSet() == null ? 0 : value.unknownFieldSet().getSerializedSize();
        switch (value.type()) {
            case NULL: {
                ++size;
                break;
            }
            case BOOLEAN: {
                ++size;
                break;
            }
            case DOUBLE: {
                size += 8;
                break;
            }
            case TIMESTAMP: {
                size += 8;
                break;
            }
            case STRING: {
                size += NaturalSizer.stringSize(value.asString());
                break;
            }
            case BYTES: {
                size += value.asBytes().size();
                break;
            }
            case GEO_POINT: {
                size += 16;
                break;
            }
            case RESOURCE_REF: {
                size += NaturalSizer.resourceRefSize(value.asResourceRef());
                break;
            }
            case ENTITY_REF: {
                size += NaturalSizer.resourceRefSize(value.asEntityRef());
                break;
            }
            case LONG: 
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                size += 8;
                break;
            }
            case LEGACY_USER: {
                size += NaturalSizer.legacyUserSize(value.asLegacyUser());
                break;
            }
            case ENTITY: {
                size += NaturalSizer.entitySize(value.asEntity());
                break;
            }
            case ARRAY: {
                size += NaturalSizer.arraySize(value.asArray());
                break;
            }
            case MAP: {
                size += NaturalSizer.mapSize(value.asMap());
                break;
            }
            default: {
                String string = String.valueOf((Object)value.type());
                throw new IllegalArgumentException(new StringBuilder(19 + String.valueOf(string).length()).append("unknown value type ").append(string).toString());
            }
        }
        return size;
    }

    private static int resourceRefSize(ResourceRef ref) {
        if (ref instanceof EntityRef) {
            return NaturalSizer.entityRefSize((EntityRef)ref);
        }
        if (ref instanceof PartitionRef) {
            return NaturalSizer.entityRefSize(EntityRef.createEmpty((PartitionRef)ref));
        }
        if (ref instanceof DatabaseRef) {
            return 16;
        }
        if (ref instanceof OtherServiceResourceRef) {
            OtherServiceResourceRef otherRef = (OtherServiceResourceRef)ref;
            int size = NaturalSizer.stringSize(otherRef.service());
            for (String id : otherRef.ids()) {
                size += NaturalSizer.stringSize(id);
            }
            return size;
        }
        String string = String.valueOf(ref);
        throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string).length()).append("Cannot calculate size of ResourceRef ").append(string).toString());
    }

    private static int legacyUserSize(Value.LegacyUser user) {
        int size = NaturalSizer.stringSize(PROPERTY_NAME_EMAIL) + NaturalSizer.stringSize(user.email()) + NaturalSizer.stringSize(PROPERTY_NAME_AUTH_DOMAIN) + NaturalSizer.stringSize(user.authDomain());
        if (user.federatedIdentity() != null) {
            size += NaturalSizer.stringSize(PROPERTY_NAME_FEDERATED_IDENTITY) + NaturalSizer.stringSize(user.federatedIdentity());
        }
        if (user.federatedProvider() != null) {
            size += NaturalSizer.stringSize(PROPERTY_NAME_FEDERATED_PROVIDER) + NaturalSizer.stringSize(user.federatedProvider());
        }
        return size;
    }

    private static boolean excludeProperty(PropertyName propertyName) {
        return propertyName.special().isConfigDependent();
    }

    public static int indexEntrySize(IndexEntry indexEntry) {
        return NaturalSizer.indexEntryKeySize(indexEntry);
    }

    public static int indexEntryKeySize(IndexEntry indexEntry) {
        switch (indexEntry.index().definition().form()) {
            case KEY_ASCENDING: 
            case KIND_AND_PARENT_ASCENDING: 
            case KINDLESS_SCATTER: {
                return 0;
            }
            case KIND_AND_KEY_ASCENDING: {
                return NaturalSizer.builtinKindNaturalSize(indexEntry);
            }
            case BUILTIN_SINGLE_PROPERTY: {
                return NaturalSizer.builtinPropertyNaturalSize(indexEntry);
            }
            case BUILTIN_FIRESTORE_COLLECTION_SINGLE_PROPERTY: 
            case BUILTIN_FIRESTORE_COLLECTION_GROUP_SINGLE_PROPERTY: {
                return NaturalSizer.firestoreSingleFieldIndexNaturalSize(indexEntry);
            }
            case USER_DEFINED: {
                return NaturalSizer.userDefinedNaturalSize(indexEntry);
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    private static int builtinKindNaturalSize(IndexEntry indexEntry) {
        return 32 + NaturalSizer.entityRefSize(indexEntry.entityRef()) + NaturalSizer.stringSize(indexEntry.entityRef().collectionId());
    }

    private static int builtinPropertyNaturalSize(IndexEntry indexEntry) {
        IndexDef.PropertyDef builtinPropertyDef = (IndexDef.PropertyDef)indexEntry.index().definition().propertyDefs().get(0);
        IndexValue builtinIndexValue = (IndexValue)indexEntry.values().get(0);
        return 32 + NaturalSizer.entityRefSize(indexEntry.entityRef()) + NaturalSizer.stringSize(indexEntry.entityRef().collectionId()) + NaturalSizer.propertyPathSize(builtinPropertyDef.path()) + builtinIndexValue.naturalSize();
    }

    private static int firestoreSingleFieldIndexNaturalSize(IndexEntry indexEntry) {
        int ancestorSize = indexEntry.ancestorValue() == null ? NaturalSizer.partitionRefSize(indexEntry.entityRef().partitionRef()) : indexEntry.ancestorValue().naturalSize();
        return 32 + NaturalSizer.entityRefSize(indexEntry.entityRef()) + ancestorSize + NaturalSizer.propertyPathSize(((IndexDef.PropertyDef)indexEntry.index().definition().propertyDefs().get(0)).path()) + ((IndexValue)indexEntry.values().get(0)).naturalSize();
    }

    private static int userDefinedNaturalSize(IndexEntry indexEntry) {
        int indexFieldValueSum = indexEntry.ancestorValue() == null ? 0 : indexEntry.ancestorValue().naturalSize();
        for (IndexValue indexValue : indexEntry.values()) {
            indexFieldValueSum += indexValue.naturalSize();
        }
        return 32 + NaturalSizer.entityRefSize(indexEntry.entityRef()) + indexFieldValueSum;
    }
}

