/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.validator;

import com.google.cloud.datastore.core.exception.ValidationException;
import com.google.cloud.datastore.core.rep.backups.Backup;
import java.time.Duration;

public final class BackupValidator {
    private static final Duration MAX_EXPIRE_TIME = Duration.ofDays(365L);

    private BackupValidator() {
    }

    public static void validate(Backup backup) throws ValidationException {
        ValidationException.validateAssertion(backup.createTime().isBefore(backup.expireTime()), "backup creation time (%s) required to be before the expire time (%s)", backup.createTime(), backup.expireTime());
        ValidationException.validateAssertion(backup.createTime().plus(MAX_EXPIRE_TIME).isAfter(backup.expireTime()), "backup expiration time (%s) cannot be longer than 1 year from the creation time (%s)", backup.expireTime(), backup.createTime());
        switch (backup.state()) {
            case INITIALIZED: 
            case UPLOADING: {
                ValidationException.validateAssertion(backup.stats() == null, "stats not allowed for non-finalized backups.", new Object[0]);
                ValidationException.validateAssertion(backup.metadataBlobPath() == null, "metadata not allowed for non-finalized backups.", new Object[0]);
                break;
            }
            case FINALIZED: {
                ValidationException.validateAssertion(backup.stats() != null, "stats are required for finalized backups.", new Object[0]);
                ValidationException.validateAssertion(backup.metadataBlobPath() != null, "metadata required for finalized backups.", new Object[0]);
                ValidationException.validateAssertion(backup.stats().sizeBytes() >= 0L, "negative backup size not allowed.", new Object[0]);
                ValidationException.validateAssertion(backup.stats().entityCount() >= 0L, "negative entity count not allowed.", new Object[0]);
            }
        }
    }
}

