/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.apphosting.utils.config.QueueXml;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

abstract class DevQueue {
    protected static final Logger logger = Logger.getLogger(DevQueue.class.getName());
    protected final QueueXml.Entry queueXmlEntry;
    static AtomicInteger taskNameGenerator = null;

    DevQueue(QueueXml.Entry queueXmlEntry) {
        this.queueXmlEntry = queueXmlEntry;
    }

    static String genTaskName() {
        if (taskNameGenerator != null) {
            int n = taskNameGenerator.incrementAndGet();
            return new StringBuilder(15).append("task").append(n).toString();
        }
        String string = String.valueOf(UUID.randomUUID());
        return new StringBuilder(5 + String.valueOf(string).length()).append("task-").append(string).toString();
    }

    abstract TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest.Builder var1);

    protected String getQueueName() {
        return this.queueXmlEntry.getName();
    }

    protected TaskQueuePb.TaskQueueRetryParameters getRetryParameters(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        if (addRequest.hasRetryParameters()) {
            return addRequest.getRetryParameters();
        }
        QueueXml.RetryParameters retryParams = this.queueXmlEntry.getRetryParameters();
        if (retryParams == null) {
            return null;
        }
        TaskQueuePb.TaskQueueRetryParameters.Builder paramsPb = TaskQueuePb.TaskQueueRetryParameters.newBuilder();
        if (retryParams.getRetryLimit() != null) {
            paramsPb.setRetryLimit(retryParams.getRetryLimit().intValue());
        }
        if (retryParams.getAgeLimitSec() != null) {
            paramsPb.setAgeLimitSec((long)retryParams.getAgeLimitSec().intValue());
        }
        if (retryParams.getMinBackoffSec() != null) {
            paramsPb.setMinBackoffSec(retryParams.getMinBackoffSec().doubleValue());
        }
        if (retryParams.getMaxBackoffSec() != null) {
            paramsPb.setMaxBackoffSec(retryParams.getMaxBackoffSec().doubleValue());
        }
        if (retryParams.getMaxDoublings() != null) {
            paramsPb.setMaxDoublings(retryParams.getMaxDoublings().intValue());
        }
        return paramsPb.build();
    }

    abstract QueueStateInfo getStateInfo();

    abstract boolean deleteTask(String var1);

    abstract void flush();

    abstract TaskQueuePb.TaskQueueMode.Mode getMode();

    abstract boolean runTask(String var1);
}

