/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import java.io.Serializable;
import javax.annotation.CheckReturnValue;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp final class S1Angle
implements Comparable<S1Angle>,
Serializable {
    @Deprecated
    public static final double EARTH_RADIUS_METERS = 6367000.0;
    public static final S1Angle INFINITY = new S1Angle(Double.POSITIVE_INFINITY);
    public static final S1Angle ZERO = new S1Angle();
    private final double radians;

    public double radians() {
        return this.radians;
    }

    public double degrees() {
        return this.radians * 57.29577951308232;
    }

    public int e5() {
        return Ints.checkedCast((long)Math.round(this.degrees() * 100000.0));
    }

    public int e6() {
        return Ints.checkedCast((long)Math.round(this.degrees() * 1000000.0));
    }

    public int e7() {
        return Ints.checkedCast((long)Math.round(this.degrees() * 1.0E7));
    }

    @JsIgnore
    public S1Angle() {
        this(0.0);
    }

    @JsConstructor
    private S1Angle(double radians) {
        this.radians = radians;
    }

    @JsIgnore
    public S1Angle(S2Point x, S2Point y) {
        this(x.angle(y));
    }

    public boolean equals(Object that) {
        if (that instanceof S1Angle) {
            return this.radians == ((S1Angle)that).radians;
        }
        return false;
    }

    public int hashCode() {
        long value = Double.doubleToLongBits(this.radians);
        return (int)(value ^ value >>> 32);
    }

    public boolean lessThan(S1Angle that) {
        return this.radians < that.radians;
    }

    public boolean greaterThan(S1Angle that) {
        return this.radians > that.radians;
    }

    public boolean lessOrEquals(S1Angle that) {
        return this.radians <= that.radians;
    }

    public boolean greaterOrEquals(S1Angle that) {
        return this.radians >= that.radians;
    }

    public static S1Angle max(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? right : left;
    }

    public static S1Angle min(S1Angle left, S1Angle right) {
        return right.greaterThan(left) ? left : right;
    }

    public static S1Angle radians(double radians) {
        return new S1Angle(radians);
    }

    public static S1Angle degrees(double degrees) {
        return new S1Angle(degrees * (Math.PI / 180));
    }

    public static S1Angle e5(int e5) {
        return S1Angle.degrees((double)e5 * 1.0E-5);
    }

    public static S1Angle e6(int e6) {
        return S1Angle.degrees((double)e6 * 1.0E-6);
    }

    public static S1Angle e7(int e7) {
        return S1Angle.degrees((double)e7 * 1.0E-7);
    }

    @Deprecated
    public static S1Angle fromEarthDistance(double meters) {
        return S1Angle.radians(meters / 6367000.0);
    }

    public double distance(double radius) {
        return this.radians * radius;
    }

    @Deprecated
    public double earthDistance() {
        return this.radians * 6367000.0;
    }

    public S1Angle neg() {
        return new S1Angle(-this.radians);
    }

    @CheckReturnValue
    public S1Angle add(S1Angle a) {
        return new S1Angle(this.radians + a.radians);
    }

    @CheckReturnValue
    public S1Angle sub(S1Angle a) {
        return new S1Angle(this.radians - a.radians);
    }

    @CheckReturnValue
    public S1Angle mul(double m) {
        return new S1Angle(this.radians * m);
    }

    @CheckReturnValue
    public S1Angle div(double d) {
        return new S1Angle(this.radians / d);
    }

    public double cos() {
        return Math.cos(this.radians);
    }

    public double sin() {
        return Math.sin(this.radians);
    }

    public double tan() {
        return Math.tan(this.radians);
    }

    @CheckReturnValue
    public S1Angle normalize() {
        boolean isNormalized;
        boolean bl = isNormalized = this.radians > -Math.PI && this.radians <= Math.PI;
        if (isNormalized) {
            return this;
        }
        double normalized = Platform.IEEEremainder(this.radians, Math.PI * 2);
        if (normalized <= -Math.PI) {
            normalized = Math.PI;
        }
        assert (normalized > -Math.PI);
        assert (normalized <= Math.PI);
        return new S1Angle(normalized);
    }

    public String toString() {
        double d = this.degrees();
        return new StringBuilder(25).append(d).append("d").toString();
    }

    @Override
    public int compareTo(S1Angle that) {
        return this.radians < that.radians ? -1 : (this.radians > that.radians ? 1 : 0);
    }

    public Builder toBuilder() {
        return new Builder().add(this);
    }

    @JsType
    public strictfp static final class Builder {
        private double radians;

        public Builder add(S1Angle angle) {
            this.radians += angle.radians;
            return this;
        }

        @JsMethod(name="addRadians")
        public Builder add(double radians) {
            this.radians += radians;
            return this;
        }

        public S1Angle build() {
            return new S1Angle(this.radians);
        }
    }
}

