/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis.cn;

import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.tokenattributes.TermAttribute;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class ChineseFilter
extends TokenFilter {
    public static final String[] STOP_WORDS = new String[]{"and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    private Map stopTable = new HashMap(STOP_WORDS.length);
    private TermAttribute termAtt;

    public ChineseFilter(TokenStream in) {
        super(in);
        for (int i = 0; i < STOP_WORDS.length; ++i) {
            this.stopTable.put(STOP_WORDS[i], STOP_WORDS[i]);
        }
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            String text = this.termAtt.term();
            if (this.stopTable.get(text) != null) continue;
            switch (Character.getType(text.charAt(0))) {
                case 1: 
                case 2: {
                    if (text.length() <= 1) break;
                    return true;
                }
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }
}

