/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import java.io.Serializable;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=false)
public strictfp abstract class S2LatLngRectBase
implements S2Region,
Serializable {
    protected final R1Interval lat;
    protected final S1Interval lng;
    private static final S2Point ORTHO_LNG = S2Point.Y_NEG;

    S2LatLngRectBase(S2LatLng lo, S2LatLng hi) {
        this.lat = new R1Interval(lo.lat().radians(), hi.lat().radians());
        this.lng = new S1Interval(lo.lng().radians(), hi.lng().radians());
    }

    S2LatLngRectBase(R1Interval lat, S1Interval lng) {
        this.lat = lat;
        this.lng = lng;
    }

    S2LatLngRectBase() {
        this.lat = R1Interval.empty();
        this.lng = S1Interval.empty();
    }

    public final boolean isValid() {
        return Math.abs(this.lat.lo()) <= 1.5707963267948966 && Math.abs(this.lat.hi()) <= 1.5707963267948966 && this.lng.isValid() && this.lat.isEmpty() == this.lng.isEmpty();
    }

    public final S1Angle latLo() {
        return S1Angle.radians(this.lat.lo());
    }

    public final S1Angle latHi() {
        return S1Angle.radians(this.lat.hi());
    }

    public final S1Angle lngLo() {
        return S1Angle.radians(this.lng.lo());
    }

    public final S1Angle lngHi() {
        return S1Angle.radians(this.lng.hi());
    }

    public abstract R1Interval lat();

    public abstract S1Interval lng();

    public final S2LatLng lo() {
        return new S2LatLng(this.latLo(), this.lngLo());
    }

    public final S2LatLng hi() {
        return new S2LatLng(this.latHi(), this.lngHi());
    }

    public final boolean isEmpty() {
        return this.lat.isEmpty();
    }

    public final boolean isFull() {
        return this.lat.equals(S2LatLngRect.fullLat()) && this.lng.isFull();
    }

    public final boolean isPoint() {
        return this.lat().lo() == this.lat().hi() && this.lng.lo() == this.lng().hi();
    }

    public final boolean isInverted() {
        return this.lng.isInverted();
    }

    public final S2LatLng getVertex(int k) {
        switch (k) {
            case 0: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.lo());
            }
            case 1: {
                return S2LatLng.fromRadians(this.lat.lo(), this.lng.hi());
            }
            case 2: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.hi());
            }
            case 3: {
                return S2LatLng.fromRadians(this.lat.hi(), this.lng.lo());
            }
        }
        throw new IllegalArgumentException("Invalid vertex index.");
    }

    public final S2LatLng getCenter() {
        return S2LatLng.fromRadians(this.lat.getCenter(), this.lng.getCenter());
    }

    @JsMethod(name="getDistanceLatLng")
    public final S1Angle getDistance(S2LatLng p) {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)p.isValid());
        if (this.lng().contains(p.lng().radians())) {
            return S1Angle.radians(Math.max(0.0, Math.max(p.lat().radians() - this.lat().hi(), this.lat().lo() - p.lat().radians())));
        }
        S1Interval interval = new S1Interval(this.lng().hi(), this.lng().complement().getCenter());
        double lng = this.lng().lo();
        if (interval.contains(p.lng().radians())) {
            lng = this.lng().hi();
        }
        S2Point lo = S2LatLng.fromRadians(this.lat().lo(), lng).toPoint();
        S2Point hi = S2LatLng.fromRadians(this.lat().hi(), lng).toPoint();
        S2Point loCrossHi = S2LatLng.fromRadians(0.0, lng - 1.5707963267948966).normalized().toPoint();
        return S2EdgeUtil.getDistance(p.toPoint(), lo, hi, loCrossHi);
    }

    public final S1Angle getDistance(S2LatLngRectBase other) {
        return S2LatLngRectBase.getDistance(this, other);
    }

    private static final S1Angle getDistance(S2LatLngRectBase a, S2LatLngRectBase b) {
        S1Angle bLng;
        S1Angle aLng;
        Preconditions.checkState((!a.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isEmpty() ? 1 : 0) != 0);
        if (a.lng().intersects(b.lng())) {
            S1Angle hi;
            S1Angle lo;
            if (a.lat().intersects(b.lat())) {
                return S1Angle.radians(0.0);
            }
            if (a.lat().lo() > b.lat().hi()) {
                lo = b.latHi();
                hi = a.latLo();
            } else {
                lo = a.latHi();
                hi = b.latLo();
            }
            return S1Angle.radians(hi.radians() - lo.radians());
        }
        S1Interval loHi = S1Interval.fromPointPair(a.lng().lo(), b.lng().hi());
        S1Interval hiLo = S1Interval.fromPointPair(a.lng().hi(), b.lng().lo());
        if (loHi.getLength() < hiLo.getLength()) {
            aLng = a.lngLo();
            bLng = b.lngHi();
        } else {
            aLng = a.lngHi();
            bLng = b.lngLo();
        }
        S2Point aLo = new S2LatLng(a.latLo(), aLng).toPoint();
        S2Point aHi = new S2LatLng(a.latHi(), aLng).toPoint();
        S2Point aLoCrossHi = S2LatLng.fromRadians(0.0, aLng.radians() - 1.5707963267948966).normalized().toPoint();
        S2Point bLo = new S2LatLng(b.latLo(), bLng).toPoint();
        S2Point bHi = new S2LatLng(b.latHi(), bLng).toPoint();
        S2Point bLoCrossHi = S2LatLng.fromRadians(0.0, bLng.radians() - 1.5707963267948966).normalized().toPoint();
        return S1Angle.min(S2EdgeUtil.getDistance(aLo, bLo, bHi, bLoCrossHi), S1Angle.min(S2EdgeUtil.getDistance(aHi, bLo, bHi, bLoCrossHi), S1Angle.min(S2EdgeUtil.getDistance(bLo, aLo, aHi, aLoCrossHi), S2EdgeUtil.getDistance(bHi, aLo, aHi, aLoCrossHi))));
    }

    public final S1Angle getHausdorffDistance(S2LatLngRectBase other) {
        return S1Angle.max(this.getDirectedHausdorffDistance(other), other.getDirectedHausdorffDistance(this));
    }

    public final S1Angle getDirectedHausdorffDistance(S2LatLngRectBase other) {
        if (this.isEmpty()) {
            return S1Angle.radians(0.0);
        }
        if (other.isEmpty()) {
            return S1Angle.radians(Math.PI);
        }
        double lngDistance = this.lng().getDirectedHausdorffDistance(other.lng());
        return S2LatLngRectBase.getDirectedHausdorffDistance(lngDistance, this.lat(), other.lat());
    }

    private static S1Angle getDirectedHausdorffDistance(double lngDiff, R1Interval a, R1Interval b) {
        if (lngDiff == 0.0) {
            return S1Angle.radians(a.getDirectedHausdorffDistance(b));
        }
        double bLng = lngDiff;
        S2Point bLo = S2LatLng.fromRadians(b.lo(), bLng).toPoint();
        S2Point bHi = S2LatLng.fromRadians(b.hi(), bLng).toPoint();
        S2Point aLo = S2LatLng.fromRadians(a.lo(), 0.0).toPoint();
        S2Point aHi = S2LatLng.fromRadians(a.hi(), 0.0).toPoint();
        S1Angle maxDistance = S2EdgeUtil.getDistance(aLo, bLo, bHi);
        maxDistance = S1Angle.max(maxDistance, S2EdgeUtil.getDistance(aHi, bLo, bHi));
        if (lngDiff <= 1.5707963267948966) {
            if (a.contains(0.0) && b.contains(0.0)) {
                maxDistance = S1Angle.max(maxDistance, S1Angle.radians(lngDiff));
            }
        } else {
            S2Point p = S2LatLngRectBase.getBisectorIntersection(b, bLng);
            double pLat = S2LatLng.latitude(p).radians();
            if (a.contains(pLat)) {
                maxDistance = S1Angle.max(maxDistance, new S1Angle(p, bLo));
            }
            if (pLat > a.lo()) {
                maxDistance = S1Angle.max(maxDistance, S2LatLngRectBase.getInteriorMaxDistance(new R1Interval(a.lo(), Math.min(pLat, a.hi())), bLo));
            }
            if (pLat < a.hi()) {
                maxDistance = S1Angle.max(maxDistance, S2LatLngRectBase.getInteriorMaxDistance(new R1Interval(Math.max(pLat, a.lo()), a.hi()), bHi));
            }
        }
        return maxDistance;
    }

    private static S2Point getBisectorIntersection(R1Interval lat, double lng) {
        lng = Math.abs(lng);
        double latCenter = lat.getCenter();
        S2LatLng orthoBisector = latCenter >= 0.0 ? S2LatLng.fromRadians(latCenter - 1.5707963267948966, lng) : S2LatLng.fromRadians(-latCenter - 1.5707963267948966, lng - Math.PI);
        return S2.robustCrossProd(ORTHO_LNG, orthoBisector.toPoint());
    }

    private static S1Angle getInteriorMaxDistance(R1Interval aLat, S2Point b) {
        if (aLat.isEmpty() || b.getX() >= 0.0) {
            return S1Angle.radians(-1.0);
        }
        S2Point intersectionPoint = new S2Point(-b.getX(), 0.0, -b.getZ()).normalize();
        if (aLat.interiorContains(S2LatLng.latitude(intersectionPoint).radians())) {
            return new S1Angle(b, intersectionPoint);
        }
        return S1Angle.radians(-1.0);
    }

    public final S2LatLng getSize() {
        return S2LatLng.fromRadians(this.lat.getLength(), this.lng.getLength());
    }

    public final S2Point getCentroid() {
        if (this.isEmpty()) {
            return new S2Point();
        }
        double z1 = Math.sin(this.latLo().radians());
        double z2 = Math.sin(this.latHi().radians());
        double r1 = Math.cos(this.latLo().radians());
        double r2 = Math.cos(this.latHi().radians());
        double alpha = 0.5 * this.lng.getLength();
        double r = Math.sin(alpha) * (r2 * z2 - r1 * z1 + this.lat.getLength());
        double lngCenter = this.lng.getCenter();
        double z = alpha * (z2 + z1) * (z2 - z1);
        return new S2Point(r * Math.cos(lngCenter), r * Math.sin(lngCenter), z);
    }

    @JsMethod(name="containsLatLng")
    public final boolean contains(S2LatLng ll) {
        return this.lat.contains(ll.latRadians()) && this.lng.contains(ll.lngRadians());
    }

    @JsMethod(name="interiorContainsPoint")
    public final boolean interiorContains(S2Point p) {
        return this.interiorContains(new S2LatLng(p));
    }

    @JsMethod(name="interiorContainsLatLng")
    public final boolean interiorContains(S2LatLng ll) {
        return this.lat.interiorContains(ll.lat().radians()) && this.lng.interiorContains(ll.lng().radians());
    }

    public final boolean contains(S2LatLngRectBase other) {
        return this.lat.contains(other.lat) && this.lng.contains(other.lng);
    }

    public final boolean interiorContains(S2LatLngRectBase other) {
        return this.lat.interiorContains(other.lat) && this.lng.interiorContains(other.lng);
    }

    public final boolean intersects(S2LatLngRectBase other) {
        return this.lat.intersects(other.lat) && this.lng.intersects(other.lng);
    }

    @JsMethod(name="intersectsCell")
    public final boolean intersects(S2Cell cell) {
        int i;
        if (this.isEmpty()) {
            return false;
        }
        if (this.contains(cell.getCenterRaw())) {
            return true;
        }
        if (cell.contains(this.getCenter().toPoint())) {
            return true;
        }
        if (!this.intersects(cell.getRectBound())) {
            return false;
        }
        S2Point[] cellV = new S2Point[4];
        S2LatLng[] cellLl = new S2LatLng[4];
        for (i = 0; i < 4; ++i) {
            cellV[i] = cell.getVertex(i);
            cellLl[i] = new S2LatLng(cellV[i]);
            if (!this.contains(cellLl[i])) continue;
            return true;
        }
        for (i = 0; i < 4; ++i) {
            S1Interval edgeLng = S1Interval.fromPointPair(cellLl[i].lng().radians(), cellLl[i + 1 & 3].lng().radians());
            if (!this.lng.intersects(edgeLng)) continue;
            S2Point a = cellV[i];
            S2Point b = cellV[i + 1 & 3];
            if (edgeLng.contains(this.lng.lo()) && S2LatLngRectBase.intersectsLngEdge(a, b, this.lat, this.lng.lo())) {
                return true;
            }
            if (edgeLng.contains(this.lng.hi()) && S2LatLngRectBase.intersectsLngEdge(a, b, this.lat, this.lng.hi())) {
                return true;
            }
            if (S2LatLngRectBase.intersectsLatEdge(a, b, this.lat.lo(), this.lng)) {
                return true;
            }
            if (!S2LatLngRectBase.intersectsLatEdge(a, b, this.lat.hi(), this.lng)) continue;
            return true;
        }
        return false;
    }

    public final boolean interiorIntersects(S2LatLngRectBase other) {
        return this.lat.interiorIntersects(other.lat) && this.lng.interiorIntersects(other.lng);
    }

    public final boolean boundaryIntersects(S2Point v0, S2Point v1) {
        if (this.isEmpty()) {
            return false;
        }
        if (!this.lng.isFull()) {
            if (S2LatLngRectBase.intersectsLngEdge(v0, v1, this.lat, this.lng.lo())) {
                return true;
            }
            if (S2LatLngRectBase.intersectsLngEdge(v0, v1, this.lat, this.lng.hi())) {
                return true;
            }
        }
        if (this.lat.lo() != -1.5707963267948966 && S2LatLngRectBase.intersectsLatEdge(v0, v1, this.lat.lo(), this.lng)) {
            return true;
        }
        return this.lat.hi() != 1.5707963267948966 && S2LatLngRectBase.intersectsLatEdge(v0, v1, this.lat.hi(), this.lng);
    }

    public final double area() {
        if (this.isEmpty()) {
            return 0.0;
        }
        return this.lng().getLength() * Math.abs(Math.sin(this.latHi().radians()) - Math.sin(this.latLo().radians()));
    }

    public final boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        S2LatLngRectBase otherRect = (S2LatLngRectBase)that;
        return this.lat().equals(otherRect.lat()) && this.lng().equals(otherRect.lng());
    }

    @JsMethod(name="approxEqualsWithMaxError")
    public final boolean approxEquals(S2LatLngRectBase other, double maxError) {
        return this.lat.approxEquals(other.lat, maxError) && this.lng.approxEquals(other.lng, maxError);
    }

    public final boolean approxEquals(S2LatLngRectBase other) {
        return this.approxEquals(other, 1.0E-15);
    }

    @JsMethod(name="approxEqualsLatLng")
    public final boolean approxEquals(S2LatLngRectBase other, S2LatLng maxError) {
        return this.lat.approxEquals(other.lat, maxError.lat().radians()) && this.lng.approxEquals(other.lng, maxError.lng().radians());
    }

    public final int hashCode() {
        int value = 17;
        value = 37 * value + this.lat.hashCode();
        return 37 * value + this.lng.hashCode();
    }

    @Override
    public S2Cap getCapBound() {
        double poleAngle;
        double poleZ;
        if (this.isEmpty()) {
            return S2Cap.empty();
        }
        if (this.lat.lo() + this.lat.hi() < 0.0) {
            poleZ = -1.0;
            poleAngle = 1.5707963267948966 + this.lat.hi();
        } else {
            poleZ = 1.0;
            poleAngle = 1.5707963267948966 - this.lat.lo();
        }
        S2Cap poleCap = S2Cap.fromAxisAngle(new S2Point(0.0, 0.0, poleZ), S1Angle.radians(poleAngle));
        double lngSpan = this.lng.hi() - this.lng.lo();
        if (Platform.IEEEremainder(lngSpan, Math.PI * 2) >= 0.0 && lngSpan < Math.PI * 2) {
            S2Cap midCap = S2Cap.fromAxisAngle(this.getCenter().toPoint(), S1Angle.radians(0.0));
            for (int k = 0; k < 4; ++k) {
                midCap = midCap.addPoint(this.getVertex(k).toPoint());
            }
            if (midCap.height() < poleCap.height()) {
                return midCap;
            }
        }
        return poleCap;
    }

    @Override
    @JsMethod(name="containsCell")
    public final boolean contains(S2Cell cell) {
        return this.contains(cell.getRectBound());
    }

    @Override
    public final boolean mayIntersect(S2Cell cell) {
        return this.intersects(cell.getRectBound());
    }

    @Override
    @JsMethod(name="containsPoint")
    public final boolean contains(S2Point p) {
        return this.contains(new S2LatLng(p));
    }

    public static final boolean intersectsLngEdge(S2Point a, S2Point b, R1Interval lat, double lng) {
        return S2.simpleCrossing(a, b, S2LatLng.fromRadians(lat.lo(), lng).toPoint(), S2LatLng.fromRadians(lat.hi(), lng).toPoint());
    }

    public static final boolean intersectsLatEdge(S2Point a, S2Point b, double lat, S1Interval lng) {
        S2Point z = S2.robustCrossProd(a, b).normalize();
        if (z.z < 0.0) {
            z = z.neg();
        }
        S2Point y = S2.robustCrossProd(z, S2Point.Z_POS).normalize();
        S2Point x = y.crossProd(z);
        double sinLat = Math.sin(lat);
        if (Math.abs(sinLat) >= x.z) {
            return false;
        }
        double cosTheta = sinLat / x.z;
        double sinTheta = Math.sqrt(1.0 - cosTheta * cosTheta);
        double theta = Math.atan2(sinTheta, cosTheta);
        S1Interval abTheta = S1Interval.fromPointPair(Math.atan2(a.dotProd(y), a.dotProd(x)), Math.atan2(b.dotProd(y), b.dotProd(x)));
        if (abTheta.contains(theta)) {
            S2Point isect = x.mul(cosTheta).add(y.mul(sinTheta));
            if (lng.contains(Math.atan2(isect.y, isect.x))) {
                return true;
            }
        }
        if (abTheta.contains(-theta)) {
            S2Point intersection = x.mul(cosTheta).sub(y.mul(sinTheta));
            if (lng.contains(Math.atan2(intersection.y, intersection.x))) {
                return true;
            }
        }
        return false;
    }

    public final String toString() {
        String string = String.valueOf(this.lo());
        String string2 = String.valueOf(this.hi());
        return new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[Lo=").append(string).append(", Hi=").append(string2).append("]").toString();
    }

    public final String toStringDegrees() {
        String string = this.lo().toStringDegrees();
        String string2 = this.hi().toStringDegrees();
        return new StringBuilder(10 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[Lo=").append(string).append(", Hi=").append(string2).append("]").toString();
    }
}

