/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.primitives.Doubles;
import java.io.Serializable;
import jsinterop.annotations.JsConstructor;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp final class S1ChordAngle
implements Comparable<S1ChordAngle>,
Serializable {
    public static final double MAX_LENGTH2 = 4.0;
    public static final S1ChordAngle ZERO = new S1ChordAngle(0.0);
    public static final S1ChordAngle RIGHT = new S1ChordAngle(2.0);
    public static final S1ChordAngle STRAIGHT = new S1ChordAngle(4.0);
    public static final S1ChordAngle INFINITY = new S1ChordAngle(Double.POSITIVE_INFINITY);
    public static final S1ChordAngle NEGATIVE = new S1ChordAngle(-1.0);
    private final double length2;

    @JsConstructor
    private S1ChordAngle(double length2) {
        this.length2 = length2;
        Preconditions.checkArgument((boolean)this.isValid());
    }

    @JsIgnore
    public S1ChordAngle(S2Point x, S2Point y) {
        this(Math.min(4.0, x.getDistance2(y)));
        Preconditions.checkArgument((boolean)S2.isUnitLength(x));
        Preconditions.checkArgument((boolean)S2.isUnitLength(y));
        Preconditions.checkArgument((boolean)this.isValid());
    }

    public static S1ChordAngle fromS1Angle(S1Angle angle) {
        if (angle.radians() < 0.0) {
            return NEGATIVE;
        }
        if (angle.equals(S1Angle.INFINITY)) {
            return INFINITY;
        }
        double length = 2.0 * Math.sin(0.5 * Math.min(Math.PI, angle.radians()));
        return new S1ChordAngle(length * length);
    }

    public static S1ChordAngle fromLength2(double length2) {
        return new S1ChordAngle(Math.min(4.0, length2));
    }

    public boolean isZero() {
        return this.length2 == 0.0;
    }

    public boolean isNegative() {
        return this.length2 < 0.0;
    }

    public boolean isInfinity() {
        return this.length2 == Double.POSITIVE_INFINITY;
    }

    public boolean isSpecial() {
        return this.isNegative() || this.isInfinity();
    }

    public boolean isValid() {
        return this.length2 >= 0.0 && this.length2 <= 4.0 || this.isNegative() || this.isInfinity();
    }

    public S1Angle toAngle() {
        if (this.isNegative()) {
            return S1Angle.radians(-1.0);
        }
        if (this.isInfinity()) {
            return S1Angle.INFINITY;
        }
        return S1Angle.radians(2.0 * Math.asin(0.5 * Math.sqrt(this.length2)));
    }

    public double getLength2() {
        return this.length2;
    }

    public S1ChordAngle successor() {
        if (this.length2 >= 4.0) {
            return INFINITY;
        }
        if (this.length2 < 0.0) {
            return ZERO;
        }
        return new S1ChordAngle(Platform.nextAfter(this.length2, 10.0));
    }

    public S1ChordAngle predecessor() {
        if (this.length2 <= 0.0) {
            return NEGATIVE;
        }
        if (this.length2 > 4.0) {
            return STRAIGHT;
        }
        return new S1ChordAngle(Platform.nextAfter(this.length2, -10.0));
    }

    public static S1ChordAngle add(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isSpecial() ? 1 : 0) != 0);
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 + b2 >= 4.0) {
            return STRAIGHT;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        return new S1ChordAngle(Math.min(4.0, x + y + 2.0 * Math.sqrt(x * y)));
    }

    public static S1ChordAngle sub(S1ChordAngle a, S1ChordAngle b) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        Preconditions.checkArgument((!b.isSpecial() ? 1 : 0) != 0);
        double a2 = a.length2;
        double b2 = b.length2;
        if (b2 == 0.0) {
            return a;
        }
        if (a2 <= b2) {
            return ZERO;
        }
        double x = a2 * (1.0 - 0.25 * b2);
        double y = b2 * (1.0 - 0.25 * a2);
        return new S1ChordAngle(Math.max(0.0, x + y - 2.0 * Math.sqrt(x * y)));
    }

    public static S1ChordAngle min(S1ChordAngle a, S1ChordAngle b) {
        return a.length2 <= b.length2 ? a : b;
    }

    public static S1ChordAngle max(S1ChordAngle a, S1ChordAngle b) {
        return a.length2 > b.length2 ? a : b;
    }

    public static double sin2(S1ChordAngle a) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        return a.length2 * (1.0 - 0.25 * a.length2);
    }

    public static double sin(S1ChordAngle a) {
        return Math.sqrt(S1ChordAngle.sin2(a));
    }

    public static double cos(S1ChordAngle a) {
        Preconditions.checkArgument((!a.isSpecial() ? 1 : 0) != 0);
        return 1.0 - 0.5 * a.length2;
    }

    public static double tan(S1ChordAngle a) {
        return S1ChordAngle.sin(a) / S1ChordAngle.cos(a);
    }

    public S1ChordAngle plusError(double error) {
        return this.isSpecial() ? this : S1ChordAngle.fromLength2(Math.max(0.0, Math.min(4.0, this.length2 + error)));
    }

    public double getS1AngleConstructorMaxError() {
        return S2.DBL_EPSILON * this.length2;
    }

    public double getS2PointConstructorMaxError() {
        return 4.5 * S2.DBL_EPSILON * this.length2 + 16.0 * S2.DBL_EPSILON * S2.DBL_EPSILON;
    }

    public String toString() {
        return this.toAngle().toString();
    }

    @Override
    public int compareTo(S1ChordAngle that) {
        return Double.compare(this.length2, that.length2);
    }

    public boolean equals(Object other) {
        return other instanceof S1ChordAngle && this.length2 == ((S1ChordAngle)other).length2;
    }

    public int hashCode() {
        return this.length2 == 0.0 ? 0 : Doubles.hashCode((double)this.length2);
    }
}

