/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianInput;
import com.google.appengine.repackaged.com.google.common.geometry.LittleEndianOutput;
import com.google.appengine.repackaged.com.google.common.geometry.Platform;
import com.google.appengine.repackaged.com.google.common.geometry.R1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S1Interval;
import com.google.appengine.repackaged.com.google.common.geometry.S2;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLngRect;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import jsinterop.annotations.JsIgnore;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

@JsType
@GwtCompatible(serializable=true)
public strictfp final class S2Cap
implements S2Region,
Serializable {
    private final S2Point axis;
    private final S1ChordAngle radius;

    private S2Cap(S2Point axis, S1ChordAngle radius) {
        this.axis = axis;
        this.radius = radius;
    }

    public static S2Cap fromAxisChord(S2Point center, S1ChordAngle radius) {
        return new S2Cap(center, radius);
    }

    public static S2Cap fromAxisHeight(S2Point axis, double height) {
        return new S2Cap(axis, S1ChordAngle.fromLength2(2.0 * height));
    }

    public static S2Cap fromAxisAngle(S2Point axis, S1Angle angle) {
        return S2Cap.fromAxisChord(axis, S1ChordAngle.fromS1Angle(S1Angle.radians(Math.min(angle.radians(), Math.PI))));
    }

    public static S2Cap fromAxisArea(S2Point axis, double area) {
        return new S2Cap(axis, S1ChordAngle.fromLength2(area / Math.PI));
    }

    public static S2Cap empty() {
        return new S2Cap(S2Point.X_POS, S1ChordAngle.NEGATIVE);
    }

    public static S2Cap full() {
        return new S2Cap(S2Point.X_POS, S1ChordAngle.STRAIGHT);
    }

    public S2Point axis() {
        return this.axis;
    }

    public S1ChordAngle radius() {
        return this.radius;
    }

    public double height() {
        return 0.5 * this.radius.getLength2();
    }

    public double area() {
        return Math.PI * 2 * Math.max(0.0, this.height());
    }

    public S1Angle angle() {
        return this.radius.toAngle();
    }

    public boolean isValid() {
        return S2.isUnitLength(this.axis) && this.radius.getLength2() <= 4.0;
    }

    public boolean isEmpty() {
        return this.radius.isNegative();
    }

    public boolean isFull() {
        return S1ChordAngle.STRAIGHT.equals(this.radius);
    }

    @CheckReturnValue
    public S2Cap complement() {
        if (this.isFull()) {
            return S2Cap.empty();
        }
        if (this.isEmpty()) {
            return S2Cap.full();
        }
        return S2Cap.fromAxisChord(this.axis.neg(), S1ChordAngle.fromLength2(4.0 - this.radius.getLength2()));
    }

    @JsMethod(name="containsCap")
    public boolean contains(S2Cap other) {
        if (this.isFull() || other.isEmpty()) {
            return true;
        }
        S1ChordAngle axialDistance = new S1ChordAngle(this.axis, other.axis);
        return this.radius.compareTo(S1ChordAngle.add(axialDistance, other.radius)) >= 0;
    }

    public boolean interiorIntersects(S2Cap other) {
        return !this.complement().contains(other);
    }

    public boolean interiorContains(S2Point p) {
        return this.isFull() || new S1ChordAngle(this.axis, p).compareTo(this.radius) < 0;
    }

    @CheckReturnValue
    public S2Cap addPoint(S2Point p) {
        if (this.isEmpty()) {
            return new S2Cap(p, S1ChordAngle.ZERO);
        }
        return new S2Cap(this.axis, S1ChordAngle.fromLength2(Math.max(this.radius.getLength2(), this.axis.getDistance2(p))));
    }

    @CheckReturnValue
    public S2Cap addCap(S2Cap other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        S1ChordAngle dist = S1ChordAngle.add(new S1ChordAngle(this.axis, other.axis), other.radius);
        S1ChordAngle roundedUp = dist.plusError(S2.DBL_EPSILON * dist.getLength2());
        return new S2Cap(this.axis, S1ChordAngle.max(this.radius, roundedUp));
    }

    @Override
    public S2Cap getCapBound() {
        return this;
    }

    @Override
    public S2LatLngRect getRectBound() {
        double sinC;
        double sinA;
        if (this.isEmpty()) {
            return S2LatLngRect.empty();
        }
        if (this.isFull()) {
            return S2LatLngRect.full();
        }
        S2LatLng axisLatLng = new S2LatLng(this.axis);
        double capAngle = this.angle().radians();
        boolean allLongitudes = false;
        double[] lat = new double[2];
        double[] lng = new double[]{-Math.PI, Math.PI};
        lat[0] = axisLatLng.lat().radians() - capAngle;
        if (lat[0] <= -1.5707963267948966) {
            lat[0] = -1.5707963267948966;
            allLongitudes = true;
        }
        lat[1] = axisLatLng.lat().radians() + capAngle;
        if (lat[1] >= 1.5707963267948966) {
            lat[1] = 1.5707963267948966;
            allLongitudes = true;
        }
        if (!allLongitudes && (sinA = S1ChordAngle.sin(this.radius)) <= (sinC = Math.cos(axisLatLng.lat().radians()))) {
            double angleA = Math.asin(sinA / sinC);
            lng[0] = Platform.IEEEremainder(axisLatLng.lng().radians() - angleA, Math.PI * 2);
            lng[1] = Platform.IEEEremainder(axisLatLng.lng().radians() + angleA, Math.PI * 2);
        }
        return new S2LatLngRect(new R1Interval(lat[0], lat[1]), new S1Interval(lng[0], lng[1]));
    }

    @Override
    @JsMethod(name="containsCell")
    public boolean contains(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (this.contains(vertices[k])) continue;
            return false;
        }
        return !this.complement().intersects(cell, vertices);
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        S2Point[] vertices = new S2Point[4];
        for (int k = 0; k < 4; ++k) {
            vertices[k] = cell.getVertex(k);
            if (!this.contains(vertices[k])) continue;
            return true;
        }
        return this.intersects(cell, vertices);
    }

    public boolean intersects(S2Cell cell, S2Point[] vertices) {
        if (this.radius.compareTo(S1ChordAngle.RIGHT) >= 0) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (cell.contains(this.axis)) {
            return true;
        }
        double sin2Angle = S1ChordAngle.sin2(this.radius);
        for (int k = 0; k < 4; ++k) {
            S2Point edge = cell.getEdgeRaw(k);
            double dot = this.axis.dotProd(edge);
            if (dot > 0.0) continue;
            if (dot * dot > sin2Angle * edge.norm2()) {
                return false;
            }
            S2Point dir = edge.crossProd(this.axis);
            if (!(dir.dotProd(vertices[k]) < 0.0) || !(dir.dotProd(vertices[k + 1 & 3]) > 0.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    @JsMethod(name="containsPoint")
    public boolean contains(S2Point p) {
        return new S1ChordAngle(this.axis, p).compareTo(this.radius) <= 0;
    }

    public boolean equals(Object that) {
        if (that instanceof S2Cap) {
            S2Cap other = (S2Cap)that;
            return this.axis.equalsPoint(other.axis) && this.radius.equals(other.radius) || this.isEmpty() && other.isEmpty() || this.isFull() && other.isFull();
        }
        return false;
    }

    public int hashCode() {
        if (this.isFull()) {
            return 17;
        }
        if (this.isEmpty()) {
            return 37;
        }
        return 37 * (629 + this.axis.hashCode()) + this.radius.hashCode();
    }

    boolean approxEquals(S2Cap other, double maxError) {
        double r2 = this.radius.getLength2();
        double otherR2 = other.radius.getLength2();
        return S2.approxEquals(this.axis, other.axis, maxError) && Math.abs(r2 - otherR2) <= maxError || this.isEmpty() && otherR2 <= maxError || other.isEmpty() && r2 <= maxError || this.isFull() && otherR2 >= 2.0 - maxError || other.isFull() && r2 >= 2.0 - maxError;
    }

    boolean approxEquals(S2Cap other) {
        return this.approxEquals(other, 1.0E-14);
    }

    public String toString() {
        String string = String.valueOf(this.axis);
        String string2 = String.valueOf(this.radius);
        return new StringBuilder(20 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[Point = ").append(string).append(" Radius = ").append(string2).append("]").toString();
    }

    @JsIgnore
    public void encode(OutputStream os) throws IOException {
        this.encode(new LittleEndianOutput(os));
    }

    void encode(LittleEndianOutput os) throws IOException {
        this.axis.encode(os);
        os.writeDouble(this.radius.getLength2());
    }

    @JsIgnore
    public static S2Cap decode(InputStream is) throws IOException {
        return S2Cap.decode(new LittleEndianInput(is));
    }

    static S2Cap decode(LittleEndianInput is) throws IOException {
        S2Point axis = S2Point.decode(is);
        S1ChordAngle chord = S1ChordAngle.fromLength2(is.readDouble());
        return S2Cap.fromAxisChord(axis, chord);
    }
}

