/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S1Angle;
import com.google.appengine.repackaged.com.google.common.geometry.S1ChordAngle;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cap;
import com.google.appengine.repackaged.com.google.common.geometry.S2Cell;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellUnion;
import com.google.appengine.repackaged.com.google.common.geometry.S2EdgeUtil;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.geometry.S2PointIndex;
import com.google.appengine.repackaged.com.google.common.geometry.S2Region;
import com.google.appengine.repackaged.com.google.common.geometry.S2RegionCoverer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;

@GwtCompatible
public final class S2ClosestPointQuery<T> {
    private static final int MAX_BRUTE_FORCE_POINTS = 150;
    private static final int MAX_LEAF_POINTS = 12;
    private final S2PointIndex<T> index;
    private int maxPoints;
    private S1Angle maxDistance;
    private S2Region region;
    private boolean useBruteForce;
    private final List<S2CellId> indexCovering = Lists.newArrayList();
    private final PriorityQueue<QueueEntry> queue = new PriorityQueue();
    private S2Iterator<S2PointIndex.Entry<T>> iter;
    private final ArrayList<S2CellId> regionCovering = Lists.newArrayList();
    private final ArrayList<S2CellId> maxDistanceCovering = Lists.newArrayList();
    private final List<S2CellId> intersectionWithRegion = Lists.newArrayList();
    private final List<S2CellId> intersectionWithMaxDistance = Lists.newArrayList();
    private final S2PointIndex.Entry<T>[] tmpPoints = new S2PointIndex.Entry[12];
    private final PriorityQueue<Result<T>> results = new PriorityQueue();
    private S1ChordAngle maxDistanceLimit;

    public S2ClosestPointQuery(S2PointIndex<T> index) {
        this.index = index;
        this.maxPoints = Integer.MAX_VALUE;
        this.maxDistance = S1Angle.INFINITY;
        this.region = null;
        this.reset();
    }

    public void reset() {
        this.iter = this.index.iterator();
        this.useBruteForce(this.index.numPoints() <= 150);
    }

    public S2PointIndex<T> index() {
        return this.index;
    }

    public int getMaxPoints() {
        return this.maxPoints;
    }

    public void setMaxPoints(int maxPoints) {
        Preconditions.checkArgument((maxPoints >= 1 ? 1 : 0) != 0, (Object)"Must be at least 1.");
        this.maxPoints = maxPoints;
    }

    public S1Angle getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(S1Angle maxDistance) {
        this.maxDistance = maxDistance;
    }

    public S2Region getRegion() {
        return this.region;
    }

    public void setRegion(S2Region region) {
        this.region = region;
    }

    @VisibleForTesting
    void useBruteForce(boolean useBruteForce) {
        this.useBruteForce = useBruteForce;
        if (!useBruteForce) {
            this.initIndexCovering();
        }
    }

    private List<Result<T>> toList(List<Result<T>> list) {
        int size;
        int index = size = this.results.size();
        if (list == null) {
            list = Lists.newArrayListWithCapacity((int)size);
        } else {
            index += list.size();
        }
        list.addAll(Collections.nCopies(size, null));
        while (size-- > 0) {
            list.set(--index, this.results.poll());
        }
        return list;
    }

    public List<Result<T>> findClosestPoints(S2Point target) {
        this.findClosestPointsToTarget(new PointTarget(target));
        return this.toList(null);
    }

    public void findClosestPoints(List<Result<T>> results, S2Point target) {
        this.findClosestPointsToTarget(new PointTarget(target));
        this.toList(results);
    }

    public Result<T> findClosestPoint(S2Point target) {
        this.setMaxPoints(1);
        return (Result)Iterables.getOnlyElement(this.findClosestPoints(target), null);
    }

    public List<Result<T>> findClosestPointsToEdge(S2Point a, S2Point b) {
        this.findClosestPointsToTarget(new EdgeTarget(a, b));
        return this.toList(null);
    }

    public void findClosestPointsToEdge(List<Result<T>> results, S2Point a, S2Point b) {
        this.findClosestPointsToTarget(new EdgeTarget(a, b));
        this.toList(results);
    }

    private void initIndexCovering() {
        this.indexCovering.clear();
        this.iter.restart();
        if (this.iter.done()) {
            return;
        }
        S2Iterator<S2PointIndex.Entry<T>> nextIt = this.iter.copy();
        S2CellId indexNext = nextIt.id();
        S2Iterator<S2PointIndex.Entry<T>> lastIt = this.iter.copy();
        lastIt.finish();
        lastIt.prev();
        S2CellId indexLast = lastIt.id();
        if (!nextIt.equalIterators(lastIt)) {
            int level = indexNext.getCommonAncestorLevel(indexLast) + 1;
            S2CellId coverLast = indexLast.parent(level);
            S2CellId cover = indexNext.parent(level);
            while (!cover.equals(coverLast) && !nextIt.done()) {
                S2CellId coverMax = cover.rangeMax();
                if (nextIt.compareTo(coverMax) <= 0) {
                    S2CellId prevId = indexNext;
                    nextIt.seek(coverMax.next());
                    indexNext = nextIt.id();
                    S2Iterator<S2PointIndex.Entry<T>> cellLast = nextIt.copy();
                    cellLast.prev();
                    this.coverRange(prevId, cellLast.id());
                }
                cover = cover.next();
            }
        }
        this.coverRange(indexNext, indexLast);
    }

    private void coverRange(S2CellId firstId, S2CellId lastId) {
        int level = firstId.getCommonAncestorLevel(lastId);
        this.indexCovering.add(firstId.parent(level));
    }

    private void findClosestPointsToTarget(Target target) {
        this.maxDistanceLimit = S1ChordAngle.fromS1Angle(this.maxDistance);
        if (this.useBruteForce) {
            this.findClosestPointsBruteForce(target);
        } else {
            this.findClosestPointsOptimized(target);
        }
    }

    private void findClosestPointsBruteForce(Target target) {
        this.iter.restart();
        while (!this.iter.done()) {
            this.maybeAddResult(this.iter.entry(), target);
            this.iter.next();
        }
    }

    private void findClosestPointsOptimized(Target target) {
        this.initQueue(target);
        while (!this.queue.isEmpty()) {
            QueueEntry entry = this.queue.poll();
            if (entry.distance().compareTo(this.maxDistanceLimit) >= 0) {
                this.queue.clear();
                break;
            }
            S2CellId child = entry.id.childBegin();
            boolean seek = true;
            int i = 0;
            while (i < 4) {
                seek = this.addCell(child, this.iter, seek, target);
                ++i;
                child = child.next();
            }
        }
    }

    private void maybeAddResult(S2PointIndex.Entry<T> entry, Target target) {
        S1ChordAngle distance = target.getMinDistance(entry.point(), this.maxDistanceLimit);
        if (distance == this.maxDistanceLimit) {
            return;
        }
        if (this.region != null && !this.region.contains(entry.point())) {
            return;
        }
        if (this.results.size() >= this.maxPoints) {
            this.results.poll();
        }
        this.results.add(new Result(distance, entry));
        if (this.results.size() >= this.maxPoints) {
            this.maxDistanceLimit = this.results.peek().distance();
        }
    }

    private void initQueue(Target target) {
        if (this.maxPoints == 1) {
            this.iter.seek(S2CellId.fromPoint(target.center()));
            if (!this.iter.done()) {
                this.maybeAddResult(this.iter.entry(), target);
            }
            if (!this.iter.atBegin()) {
                this.iter.prev();
                this.maybeAddResult(this.iter.entry(), target);
            }
        }
        List<S2CellId> initialCells = this.indexCovering;
        S2RegionCoverer coverer = S2RegionCoverer.builder().setMaxCells(4).build();
        if (this.region != null) {
            coverer.getCovering(this.region, this.regionCovering);
            S2CellUnion.getIntersection(this.indexCovering, this.regionCovering, this.intersectionWithRegion);
            initialCells = this.intersectionWithRegion;
        }
        if (!this.maxDistanceLimit.isInfinity()) {
            S2Cap searchCap = S2Cap.fromAxisAngle(target.center(), S1Angle.radians(target.radius() + this.maxDistanceLimit.toAngle().radians()));
            coverer.getFastCovering(searchCap, this.maxDistanceCovering);
            S2CellUnion.getIntersection(initialCells, this.maxDistanceCovering, this.intersectionWithMaxDistance);
            initialCells = this.intersectionWithMaxDistance;
        }
        this.iter.restart();
        for (int i = 0; i < initialCells.size() && !this.iter.done(); ++i) {
            S2CellId id = initialCells.get(i);
            boolean seek = this.iter.compareTo(id.rangeMin()) <= 0;
            this.addCell(id, this.iter, seek, target);
        }
    }

    private boolean addCell(S2CellId id, S2Iterator<S2PointIndex.Entry<T>> iter, boolean seek, Target target) {
        if (seek) {
            iter.seek(id.rangeMin());
        }
        if (id.isLeaf()) {
            while (!iter.done() && iter.compareTo(id) == 0) {
                this.maybeAddResult(iter.entry(), target);
                iter.next();
            }
            return false;
        }
        S2CellId last = id.rangeMax();
        int numPoints = 0;
        while (!iter.done() && iter.compareTo(last) <= 0) {
            if (numPoints == 12) {
                S2Cell cell = new S2Cell(id);
                S1ChordAngle distance = target.getDistance(cell);
                if (distance.compareTo(this.maxDistanceLimit) < 0 && (this.region == null || this.region.mayIntersect(cell))) {
                    this.queue.add(new QueueEntry(distance, id));
                }
                return true;
            }
            this.tmpPoints[numPoints++] = iter.entry();
            iter.next();
        }
        for (int i = 0; i < numPoints; ++i) {
            this.maybeAddResult(this.tmpPoints[i], target);
        }
        return false;
    }

    private static class QueueEntry
    extends ChordComparable {
        private final S2CellId id;

        QueueEntry(S1ChordAngle distance, S2CellId id) {
            super(distance);
            this.id = id;
        }

        public int hashCode() {
            return this.id.hashCode() * 31 + this.distance().hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof QueueEntry) {
                QueueEntry q = (QueueEntry)o;
                return this.id.equals(q.id) && this.distance.equals(q.distance);
            }
            return false;
        }

        @Override
        public int compareTo(ChordComparable other) {
            return this.distance.compareTo(other.distance);
        }
    }

    public static class Result<T>
    extends ChordComparable {
        private final S2PointIndex.Entry<T> pointData;

        private Result(S1ChordAngle distance, S2PointIndex.Entry<T> pointData) {
            super(distance);
            this.pointData = pointData;
        }

        public S2PointIndex.Entry<T> entry() {
            return this.pointData;
        }

        public int hashCode() {
            return this.pointData.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Result) {
                Result other = (Result)o;
                return this.pointData.equals(other.pointData);
            }
            return false;
        }

        public String toString() {
            double d = this.distance().toAngle().degrees();
            String string = String.valueOf(this.pointData);
            return new StringBuilder(26 + String.valueOf(string).length()).append(d).append(": ").append(string).toString();
        }

        @Override
        public int compareTo(ChordComparable other) {
            return other.distance.compareTo(this.distance);
        }
    }

    private static abstract class ChordComparable
    implements Comparable<ChordComparable> {
        protected final S1ChordAngle distance;

        ChordComparable(S1ChordAngle distance) {
            this.distance = distance;
        }

        public final S1ChordAngle distance() {
            return this.distance;
        }
    }

    private static class EdgeTarget
    implements Target {
        private final S2Point a;
        private final S2Point b;

        public EdgeTarget(S2Point a, S2Point b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public S2Point center() {
            return this.a.add(this.b).normalize();
        }

        @Override
        public double radius() {
            return 0.5 * this.a.angle(this.b);
        }

        @Override
        public S1ChordAngle getMinDistance(S2Point x, S1ChordAngle minDist) {
            return S2EdgeUtil.updateMinDistance(x, this.a, this.b, minDist);
        }

        @Override
        public S1ChordAngle getDistance(S2Cell cell) {
            return cell.getDistanceToEdge(this.a, this.b);
        }
    }

    private static class PointTarget
    implements Target {
        private final S2Point point;

        public PointTarget(S2Point point) {
            this.point = point;
        }

        @Override
        public S2Point center() {
            return this.point;
        }

        @Override
        public double radius() {
            return 0.0;
        }

        @Override
        public S1ChordAngle getMinDistance(S2Point x, S1ChordAngle minDist) {
            S1ChordAngle angle = new S1ChordAngle(x, this.point);
            return angle.compareTo(minDist) > 0 ? minDist : angle;
        }

        @Override
        public S1ChordAngle getDistance(S2Cell cell) {
            return cell.getDistance(this.point);
        }
    }

    private static interface Target {
        public S2Point center();

        public S1ChordAngle getDistance(S2Cell var1);

        public double radius();

        public S1ChordAngle getMinDistance(S2Point var1, S1ChordAngle var2);
    }
}

