/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.geometry;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.geometry.S2CellId;
import com.google.appengine.repackaged.com.google.common.geometry.S2Iterator;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.com.google.common.geometry.S2Point;
import com.google.appengine.repackaged.com.google.common.primitives.UnsignedLongs;
import java.util.Collections;
import java.util.List;

@GwtCompatible
public final class S2PointIndex<D> {
    private final List<Entry<D>> entries = Lists.newArrayList();
    private boolean sorted = true;

    public int numPoints() {
        return this.entries.size();
    }

    public S2Iterator<Entry<D>> iterator() {
        if (!this.sorted) {
            Collections.sort(this.entries);
            this.sorted = true;
        }
        return S2Iterator.create(this.entries);
    }

    public void add(S2Point point, D data) {
        this.add(S2PointIndex.createEntry(point, data));
    }

    public void add(Entry<D> entry) {
        this.sorted = false;
        this.entries.add(entry);
    }

    public boolean remove(S2Point point, D data) {
        return this.remove(S2PointIndex.createEntry(point, data));
    }

    public boolean remove(Entry<D> entry) {
        return this.entries.remove(entry);
    }

    public void reset() {
        this.sorted = true;
        this.entries.clear();
    }

    public static <D> Entry<D> createEntry(S2Point point, D data) {
        return new Entry(S2CellId.fromPoint(point), point, data);
    }

    public static class Entry<D>
    implements S2Iterator.Entry,
    Comparable<Entry<D>> {
        private final long id;
        private final S2Point point;
        private final D data;

        private Entry(S2CellId cellId, S2Point point, D data) {
            this.id = cellId.id();
            this.point = point;
            this.data = data;
        }

        @Override
        public long id() {
            return this.id;
        }

        public S2Point point() {
            return this.point;
        }

        public D data() {
            return this.data;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry e = (Entry)other;
                return this.point.equalsPoint(e.point) && Objects.equal(this.data, e.data);
            }
            return false;
        }

        public int hashCode() {
            return this.point.hashCode() * 31 + (this.data == null ? 0 : this.data.hashCode());
        }

        @Override
        public int compareTo(Entry<D> other) {
            return UnsignedLongs.compare((long)this.id, (long)other.id);
        }

        public String toString() {
            String string = String.valueOf(new S2LatLng(this.point));
            String string2 = String.valueOf(this.data);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString();
        }
    }
}

