/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import java.util.function.DoubleBinaryOperator;

final class BinaryNumericExpression
extends NumericExpression {
    private final DoubleBinaryOperator op;
    private final NumericExpression left;
    private final NumericExpression right;
    private static final ImmutableMap<Integer, DoubleBinaryOperator> BINARY_OPS = ImmutableMap.builder().put((Object)19, (a, b) -> a * b).put((Object)20, (a, b) -> a / b).put((Object)17, (a, b) -> a + b).put((Object)18, (a, b) -> a - b).put((Object)43, Math::pow).put((Object)11, (a, b) -> BinaryNumericExpression.truth(a < b)).put((Object)13, (a, b) -> BinaryNumericExpression.truth(a > b)).put((Object)12, (a, b) -> BinaryNumericExpression.truth(a <= b)).put((Object)15, (a, b) -> BinaryNumericExpression.truth(a == b)).put((Object)16, (a, b) -> BinaryNumericExpression.truth(a != b)).put((Object)14, (a, b) -> BinaryNumericExpression.truth(a >= b)).build();

    private BinaryNumericExpression(DoubleBinaryOperator op, NumericExpression left, NumericExpression right) {
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @Override
    public double evalDouble(Document doc) throws EvaluationException {
        double leftValue = this.left.evalDouble(doc);
        double rightValue = this.right.evalDouble(doc);
        return this.op.applyAsDouble(leftValue, rightValue);
    }

    private static double truth(boolean b) {
        return b ? 1.0 : 0.0;
    }

    static BinaryNumericExpression make(int type, NumericExpression left, NumericExpression right) {
        return new BinaryNumericExpression((DoubleBinaryOperator)BINARY_OPS.get((Object)type), left, right);
    }
}

